/*
 * Decompiled with CFR 0.152.
 */
package de.pseudonymisierung.controlnumbers;

import de.pseudonymisierung.controlnumbers.ControlNumber;
import de.pseudonymisierung.controlnumbers.Utils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.function.Function;

public class ControlNumberGenerator
implements Function<String, ControlNumber> {
    public static final int defaultHashLength = 500;
    public static final int defaultNGramLength = 2;
    public static final int defaultNHashFunctions = 15;
    public static final Charset defaultEncoding = StandardCharsets.UTF_16;
    private int hashLength;
    private int nGramLength;
    private int nHashFunctions;
    protected Charset encoding;
    private MessageDigest sha1;
    private MessageDigest md5;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ControlNumber apply(String input) {
        ControlNumber out = new ControlNumber(this.hashLength);
        List<String> nGrams = Utils.getNGrams(input, this.nGramLength);
        for (String nGram : nGrams) {
            byte[] md5 = this.getMd5Hash(nGram);
            byte[] sha1 = this.getSha1Hash(nGram);
            for (int i = 0; i < this.nHashFunctions; ++i) {
                int hashRet = this.hash(md5, sha1, i);
                out.set(hashRet);
            }
        }
        return out;
    }

    protected synchronized byte[] getMd5Hash(String input) {
        return this.md5.digest(input.getBytes(this.encoding));
    }

    protected synchronized byte[] getSha1Hash(String input) {
        return this.sha1.digest(input.getBytes(this.encoding));
    }

    protected int hash(byte[] basehash1, byte[] baseHash2, int index) {
        int hash1 = 0;
        int hash2 = 0;
        int nSignBytes = (int)Math.ceil(Math.log(this.hashLength) / Math.log(256.0));
        for (int byteInd = 0; byteInd < nSignBytes; ++byteInd) {
            hash1 = (int)((double)hash1 + Math.pow(256.0, byteInd) * (double)(basehash1[basehash1.length - 1 - byteInd] + 128));
            hash2 = (int)((double)hash2 + Math.pow(256.0, byteInd) * (double)(baseHash2[baseHash2.length - 1 - byteInd] + 128));
        }
        return (hash1 + index * hash2) % this.hashLength;
    }

    protected ControlNumberGenerator(AbstractBuilder<?> builder) {
        this.hashLength = builder.hashLength;
        this.nGramLength = builder.nGramLength;
        this.nHashFunctions = builder.nHashFunctions;
        this.encoding = builder.encoding;
        try {
            this.md5 = MessageDigest.getInstance("MD5");
            this.sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("ControlNumberGenerator needs MessageDigest algorithms MD5 and SHA1.", e);
        }
    }

    public static class Builder
    extends AbstractBuilder<ControlNumberGenerator> {
        private Builder() {
        }

        @Override
        public ControlNumberGenerator build() {
            return new ControlNumberGenerator(this);
        }
    }

    public static abstract class AbstractBuilder<T extends ControlNumberGenerator> {
        protected int hashLength = 500;
        protected int nGramLength = 2;
        protected int nHashFunctions = 15;
        protected Charset encoding = defaultEncoding;

        public AbstractBuilder<T> hashLength(int hashLength) {
            this.hashLength = hashLength;
            return this;
        }

        public AbstractBuilder<T> nGramLength(int nGramLength) {
            this.nGramLength = nGramLength;
            return this;
        }

        public AbstractBuilder<T> nHashFunctions(int nHashFunctions) {
            this.nHashFunctions = nHashFunctions;
            return this;
        }

        public AbstractBuilder<T> encoding(String encoding) {
            this.encoding = Charset.forName(encoding);
            return this;
        }

        public AbstractBuilder<T> encoding(Charset encoding) {
            this.encoding = encoding;
            return this;
        }

        public abstract T build();
    }
}

