/*
 * Decompiled with CFR 0.152.
 */
package de.pseudonymisierung.controlnumbers;

import java.util.BitSet;

public class ControlNumber
extends BitSet {
    private int length;

    public ControlNumber(int length) {
        super(length);
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void set(int bitIndex) throws IndexOutOfBoundsException {
        if (bitIndex >= this.length) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + bitIndex);
        }
        super.set(bitIndex);
    }

    @Override
    public void set(int fromIndex, int toIndex) throws IndexOutOfBoundsException {
        if (fromIndex >= this.length || toIndex >= this.length) {
            throw new IndexOutOfBoundsException("Index out of bounds: [" + fromIndex + ", " + toIndex + "]");
        }
        super.set(fromIndex, toIndex);
    }

    @Override
    public void clear(int bitIndex) throws IndexOutOfBoundsException {
        if (bitIndex >= this.length) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + bitIndex);
        }
        super.clear(bitIndex);
    }

    @Override
    public void clear(int fromIndex, int toIndex) throws IndexOutOfBoundsException {
        if (fromIndex >= this.length || toIndex >= this.length) {
            throw new IndexOutOfBoundsException("Index out of bounds: [" + fromIndex + ", " + toIndex + "]");
        }
        super.clear(fromIndex, toIndex);
    }

    public String toBitString() {
        StringBuffer result = new StringBuffer(this.length());
        for (int i = 0; i < this.length(); ++i) {
            if (this.get(i)) {
                result.append("1");
                continue;
            }
            result.append("0");
        }
        return result.toString();
    }

    public static ControlNumber fromBitString(String bitString) {
        if (bitString == null) {
            throw new IllegalArgumentException("Cannot create a ControlNumber from null");
        }
        ControlNumber cn = new ControlNumber(bitString.length());
        block4: for (int i = 0; i < bitString.length(); ++i) {
            char thisChar = bitString.charAt(i);
            switch (thisChar) {
                case '1': {
                    cn.set(i);
                }
                case '0': {
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Argument bitString contains illegal character %c at position %d", Character.valueOf(thisChar), i));
                }
            }
        }
        return cn;
    }
}

