package de.pseudonymisierung.controlnumbers;

import java.util.List;
import java.util.Vector;

public class Utils {
	
	/** Split the input string into n-grams of length nGramLength. The string is
	 * padded with nGramLength-1 spaces (trailing and leading).
	 *
	 * For example, the input string "Java" yields the output bigrams (n=2) "
	 * J", "Ja", "av", "va", "a ".
	 *
	 * @param input
	 *            String to split into n-grams.
	 * @param nGramLength
	 *            Length of n-grams.
	 * @return The set of n-grams. */
	public static List<String> getNGrams(String input, int nGramLength) {
		// initialize Buffer to hold input and padding
		// (nGramLength - 1 spaces on each side)
		StringBuffer buffer = new StringBuffer(input.length() + 2 * (nGramLength - 1));
		// Add leading padding
		for (int i = 0; i < nGramLength - 1; i++)
			buffer.append(" ");
		// add input string
		buffer.append(input);
		// add leading padding
		for (int i = 0; i < nGramLength - 1; i++)
			buffer.append(" ");
		
		Vector<String> output = new Vector<String>(buffer.length() - nGramLength + 1);
		for (int i = 0; i <= buffer.length() - nGramLength; i++) {
			output.addElement(buffer.substring(i, i + nGramLength));
		}
		return output;
	}
}
