/*
 * Decompiled with CFR 0.152.
 */
package de.psdev.licensesdialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import de.psdev.licensesdialog.NoticesHtmlBuilder;
import de.psdev.licensesdialog.R;
import de.psdev.licensesdialog.SingleLicenseDialog;
import de.psdev.licensesdialog.model.Notice;
import java.io.Serializable;

public class SingleLicenseDialogFragment
extends DialogFragment {
    private static final String ARGUMENT_NOTICE = "ARGUMENT_NOTICE";
    private static final String STATE_LICENSE_TEXT = "license_text";
    private static final String STATE_TITLE_TEXT = "title_text";
    private static final String STATE_CLOSE_TEXT = "close_text";
    private String mTitleText;
    private String mCloseButtonText;
    private String mLicenseText;
    private boolean mShowFullLicenseText;
    private DialogInterface.OnDismissListener mOnDismissListener;

    public static SingleLicenseDialogFragment newInstance(Notice notice) {
        SingleLicenseDialogFragment fragment = new SingleLicenseDialogFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARGUMENT_NOTICE, (Serializable)notice);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Resources resources = this.getResources();
        if (savedInstanceState != null) {
            this.mTitleText = savedInstanceState.getString(STATE_TITLE_TEXT);
            this.mLicenseText = savedInstanceState.getString(STATE_LICENSE_TEXT);
            this.mCloseButtonText = savedInstanceState.getString(STATE_CLOSE_TEXT);
        } else {
            this.mTitleText = resources.getString(R.string.notices_title);
            this.mCloseButtonText = resources.getString(R.string.notices_close);
            try {
                Notice notice = this.getNotice();
                this.mLicenseText = NoticesHtmlBuilder.create((Context)this.getActivity()).setNotice(notice).build();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(STATE_TITLE_TEXT, this.mTitleText);
        outState.putString(STATE_LICENSE_TEXT, this.mLicenseText);
        outState.putString(STATE_CLOSE_TEXT, this.mCloseButtonText);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return new SingleLicenseDialog((Context)this.getActivity(), this.mTitleText, this.mLicenseText, this.mCloseButtonText).create();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    public DialogInterface.OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public boolean isShowFullLicenseText() {
        return this.mShowFullLicenseText;
    }

    public void setShowFullLicenseText(boolean showFullLicenseText) {
        this.mShowFullLicenseText = showFullLicenseText;
    }

    private Notice getNotice() {
        Bundle arguments = this.getArguments();
        if (arguments != null && arguments.containsKey(ARGUMENT_NOTICE)) {
            return (Notice)arguments.getSerializable(ARGUMENT_NOTICE);
        }
        throw new IllegalStateException("no notice provided");
    }
}

