/*
 * Decompiled with CFR 0.152.
 */
package de.psdev.licensesdialog;

import de.psdev.licensesdialog.licenses.ApacheSoftwareLicense20;
import de.psdev.licensesdialog.licenses.BSD3ClauseLicense;
import de.psdev.licensesdialog.licenses.ISCLicense;
import de.psdev.licensesdialog.licenses.License;
import de.psdev.licensesdialog.licenses.MITLicense;
import java.util.HashMap;
import java.util.Map;

public class LicenseResolver {
    private static final int INITIAL_LICENSES_COUNT = 4;
    private static Map<String, License> sLicenses = new HashMap<String, License>(4);

    public static void registerLicense(License license) {
        sLicenses.put(license.getName(), license);
    }

    public static License read(String license) {
        String trimmedLicense = license.trim();
        if (sLicenses.containsKey(trimmedLicense)) {
            return sLicenses.get(trimmedLicense);
        }
        throw new IllegalStateException(String.format("no such license available: %s, did you forget to register it?", trimmedLicense));
    }

    static {
        LicenseResolver.registerLicense(new ApacheSoftwareLicense20());
        LicenseResolver.registerLicense(new BSD3ClauseLicense());
        LicenseResolver.registerLicense(new ISCLicense());
        LicenseResolver.registerLicense(new MITLicense());
    }
}

