/*
 * Decompiled with CFR 0.152.
 */
package de.psdev.licensesdialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import de.psdev.licensesdialog.LicensesDialog;
import de.psdev.licensesdialog.NoticesHtmlBuilder;
import de.psdev.licensesdialog.NoticesXmlParser;
import de.psdev.licensesdialog.model.Notices;

public class LicensesDialogFragment
extends DialogFragment {
    private static final String ARGUMENT_NOTICES_XML_ID = "ARGUMENT_NOTICES_XML_ID";
    private static final String ARGUMENT_INCLUDE_OWN_LICENSE = "ARGUMENT_INCLUDE_OWN_LICENSE";
    private static final String STATE_TITLE_TEXT = "title_text";
    private static final String STATE_LICENSES_TEXT = "licenses_text";
    private static final String STATE_CLOSE_TEXT = "close_text";
    private String mTitleText;
    private String mCloseButtonText;
    private String mLicensesText;
    private DialogInterface.OnDismissListener mOnDismissListener;

    public static LicensesDialogFragment newInstace(int rawNoticesResourceId, boolean includeOwnLicense) {
        LicensesDialogFragment licensesDialogFragment = new LicensesDialogFragment();
        Bundle args = new Bundle();
        args.putInt(ARGUMENT_NOTICES_XML_ID, rawNoticesResourceId);
        args.putBoolean(ARGUMENT_INCLUDE_OWN_LICENSE, includeOwnLicense);
        licensesDialogFragment.setArguments(args);
        return licensesDialogFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Resources resources = this.getResources();
        if (savedInstanceState != null) {
            this.mTitleText = savedInstanceState.getString(STATE_TITLE_TEXT);
            this.mLicensesText = savedInstanceState.getString(STATE_LICENSES_TEXT);
            this.mCloseButtonText = savedInstanceState.getString(STATE_CLOSE_TEXT);
        } else {
            this.mTitleText = resources.getString(2130968577);
            this.mCloseButtonText = resources.getString(2130968578);
            try {
                Notices notices = NoticesXmlParser.parse(resources.openRawResource(this.getNoticesXmlResourceId()));
                if (this.getArguments() != null && this.getArguments().getBoolean(ARGUMENT_INCLUDE_OWN_LICENSE, false)) {
                    notices.getNotices().add(LicensesDialog.LICENSES_DIALOG_NOTICE);
                }
                this.mLicensesText = NoticesHtmlBuilder.create((Context)this.getActivity()).setNotices(notices).build();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(STATE_TITLE_TEXT, this.mTitleText);
        outState.putString(STATE_LICENSES_TEXT, this.mLicensesText);
        outState.putString(STATE_CLOSE_TEXT, this.mCloseButtonText);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return new LicensesDialog((Context)this.getActivity(), this.mTitleText, this.mLicensesText, this.mCloseButtonText).create();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    public DialogInterface.OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    private int getNoticesXmlResourceId() {
        int resourceId = 2130903044;
        Bundle arguments = this.getArguments();
        if (arguments != null && arguments.containsKey(ARGUMENT_NOTICES_XML_ID)) {
            resourceId = arguments.getInt(ARGUMENT_NOTICES_XML_ID);
            if (!"raw".equalsIgnoreCase(this.getResources().getResourceTypeName(resourceId))) {
                throw new IllegalStateException("not a raw resource");
            }
        }
        return resourceId;
    }
}

