/*
 * Decompiled with CFR 0.152.
 */
package de.psdev.licensesdialog;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.view.View;
import android.webkit.WebView;
import de.psdev.licensesdialog.NoticesHtmlBuilder;
import de.psdev.licensesdialog.NoticesXmlParser;
import de.psdev.licensesdialog.licenses.ApacheSoftwareLicense20;
import de.psdev.licensesdialog.model.Notice;
import de.psdev.licensesdialog.model.Notices;
import java.util.List;

public class LicensesDialog {
    public static final Notice LICENSES_DIALOG_NOTICE = new Notice("LicensesDialog", "http://psdev.de/LicensesDialog", "Copyright 2013 Philip Schiffer", new ApacheSoftwareLicense20());
    private final Context mContext;
    private final String mTitleText;
    private final String mLicensesText;
    private final String mCloseText;
    private DialogInterface.OnDismissListener mOnDismissListener;

    public LicensesDialog(Context context, int rawNoticesResourceId, boolean showFullLicenseText, boolean includeOwnLicense) {
        this.mContext = context;
        String style = context.getString(2130968576);
        this.mTitleText = context.getString(2130968577);
        try {
            Notices notices;
            Resources resources = context.getResources();
            if ("raw".equals(resources.getResourceTypeName(rawNoticesResourceId))) {
                notices = NoticesXmlParser.parse(resources.openRawResource(rawNoticesResourceId));
                if (includeOwnLicense) {
                    List<Notice> noticeList = notices.getNotices();
                    noticeList.add(LICENSES_DIALOG_NOTICE);
                }
            } else {
                throw new IllegalStateException("not a raw resource");
            }
            this.mLicensesText = NoticesHtmlBuilder.create(this.mContext).setShowFullLicenseText(showFullLicenseText).setNotices(notices).setStyle(style).build();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.mCloseText = context.getString(2130968578);
    }

    public LicensesDialog(Context context, String titleText, String licensesText, String closeText) {
        this.mContext = context;
        this.mTitleText = titleText;
        this.mLicensesText = licensesText;
        this.mCloseText = closeText;
    }

    public LicensesDialog setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    public Dialog create() {
        WebView webView = new WebView(this.mContext);
        webView.loadDataWithBaseURL(null, this.mLicensesText, "text/html", "utf-8", null);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)this.mTitleText).setView((View)webView).setPositiveButton((CharSequence)this.mCloseText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (LicensesDialog.this.mOnDismissListener != null) {
                    LicensesDialog.this.mOnDismissListener.onDismiss(dialog);
                }
            }
        });
        return dialog;
    }

    public void show() {
        this.create().show();
    }
}

