/*
 * Decompiled with CFR 0.152.
 */
package de.psdev.licensesdialog;

import de.psdev.licensesdialog.licenses.ApacheSoftwareLicense20;
import de.psdev.licensesdialog.licenses.ISCLicense;
import de.psdev.licensesdialog.licenses.License;
import java.util.HashMap;
import java.util.Map;
import org.simpleframework.xml.transform.Transform;

public class LicenseResolver
implements Transform<License> {
    private static final int INITIAL_LICENSES_COUNT = 2;
    private static Map<String, License> sLicenses = new HashMap<String, License>(2);

    public static void registerLicense(License license) {
        sLicenses.put(license.getName(), license);
    }

    public License read(String license) {
        if (sLicenses.containsKey(license)) {
            return sLicenses.get(license);
        }
        throw new IllegalStateException("no such license available: " + license + ", did you forget to register it?");
    }

    public String write(License value) {
        return value.getName();
    }

    static {
        LicenseResolver.registerLicense(new ApacheSoftwareLicense20());
        LicenseResolver.registerLicense(new ISCLicense());
    }
}

