/*
 * Decompiled with CFR 0.152.
 */
package de.psdev.formvalidations.sample;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import butterknife.Bind;
import butterknife.ButterKnife;
import de.psdev.formvalidations.EditTextErrorHandler;
import de.psdev.formvalidations.Field;
import de.psdev.formvalidations.Form;
import de.psdev.formvalidations.FormErrorHandler;
import de.psdev.formvalidations.FormUtils;
import de.psdev.formvalidations.validations.InRange;
import de.psdev.formvalidations.validations.IsEmail;
import de.psdev.formvalidations.validations.NotEmpty;

public class SampleActivity
extends Activity {
    private static final String GITHUB_PAGE = "https://github.com/PSDev/FormValidations";
    @Bind(value={2131230720})
    EditText mName;
    @Bind(value={2131230721})
    EditText mEmail;
    @Bind(value={2131230722})
    EditText mAge;
    @Bind(value={2131230723})
    Button mSubmit;
    private Form mForm;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903040);
        this.initFields();
        this.initValidationForm();
        this.initCallbacks();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(0x7F070000, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131230724: {
                this.openGitHub();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void initFields() {
        ButterKnife.bind((Activity)this);
    }

    private void initValidationForm() {
        this.mForm = Form.create();
        this.mForm.addField(Field.using((EditText)this.mName).validate(NotEmpty.build()));
        this.mForm.addField(Field.using((EditText)this.mEmail).validate(NotEmpty.build()).validate(IsEmail.build()));
        this.mForm.addField(Field.using((EditText)this.mAge).validate(InRange.build((int)0, (int)120)));
        this.mForm.errorHandler((FormErrorHandler)new EditTextErrorHandler());
    }

    private void initCallbacks() {
        this.mAge.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView view, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    SampleActivity.this.submit();
                    return true;
                }
                return false;
            }
        });
        this.mSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SampleActivity.this.submit();
            }
        });
    }

    private void submit() {
        FormUtils.hideKeyboard((Context)this, (TextView)this.mAge);
        if (this.mForm.isValid()) {
            Toast.makeText((Context)this, (int)2130968587, (int)1).show();
        }
    }

    private void openGitHub() {
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)GITHUB_PAGE));
        this.startActivity(browserIntent);
    }
}

