/*
 * Copyright 2013 Philip Schiffer
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 *  This file incorporates code covered by the following terms:
 *
 *     The MIT License (MIT)
 *
 *     Copyright (c) 2013 Vitaliy Zasadnyy
 *
 *     Permission is hereby granted, free of charge, to any person obtaining a copy of
 *     this software and associated documentation files (the "Software"), to deal in
 *     the Software without restriction, including without limitation the rights to
 *     use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 *     the Software, and to permit persons to whom the Software is furnished to do so,
 *     subject to the following conditions:
 *
 *     The above copyright notice and this permission notice shall be included in all
 *     copies or substantial portions of the Software.
 *
 *     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 *     FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 *     COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 *     IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 *     CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package de.psdev.formvalidations;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;

import android.widget.EditText;

public class Form {

    private final List<Field> mFields;
    @Nullable
    private FormErrorHandler mHandler;

    public static Form create() {
        return new Form();
    }

    private Form() {
        mFields = new ArrayList<Field>();
    }

    public void addField(final Field field) {
        mFields.add(field);
    }

    public Form errorHandler(final FormErrorHandler handler) {
        mHandler = handler;
        return this;
    }

    public boolean isValid() {
        boolean result = true;
        try {
            resetErrors();
            for (final Field field : mFields) {
                result &= field.isValid();
            }
        } catch (final FieldValidationException e) {
            result = false;

            final EditText textView = e.getTextView();
            textView.requestFocus();
            textView.selectAll();

            FormUtils.showKeyboard(textView.getContext(), textView);


            showErrorMessage(e);
        }
        return result;
    }

    public void resetErrors() {
        final FormErrorHandler handler = mHandler;
        if (handler != null) {
            for (final Field field : mFields) {
                handler.resetError(field);
            }
        }
    }

    //

    protected void showErrorMessage(final FieldValidationException e) {
        if (mHandler != null) {
            mHandler.handleError(e);
        }
    }
}
