/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.otto;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.squareup.otto.Bus;
import com.squareup.otto.HandlerFinder;
import com.squareup.otto.ThreadEnforcer;

public class AsyncBus
extends Bus
implements Handler.Callback {
    private static final int MESSAGE_POST_EVENT = 1;
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);

    public AsyncBus() {
        this("default");
    }

    public AsyncBus(String identifier) {
        this(ThreadEnforcer.MAIN, identifier);
    }

    public AsyncBus(ThreadEnforcer enforcer) {
        this(enforcer, "default");
    }

    public AsyncBus(ThreadEnforcer enforcer, String identifier) {
        this(enforcer, identifier, HandlerFinder.ANNOTATED);
    }

    public AsyncBus(ThreadEnforcer enforcer, String identifier, HandlerFinder handlerFinder) {
        super(enforcer, identifier, handlerFinder);
    }

    public void post(Object event) {
        if (Thread.currentThread().equals(this.mMainThreadHandler.getLooper().getThread())) {
            super.post(event);
        } else {
            this.mMainThreadHandler.sendMessage(this.mMainThreadHandler.obtainMessage(1, event));
        }
    }

    public boolean handleMessage(Message message) {
        boolean messageHandled = false;
        if (message.what == 1) {
            AsyncBus.super.post(message.obj);
            messageHandled = true;
        }
        return messageHandled;
    }
}

