/*
 * Decompiled with CFR 0.152.
 */
package de.proxietv.configmanager.test;

import de.proxietv.configmanager.ConfigFile;
import de.proxietv.configmanager.ConfigPicker;
import de.proxietv.configmanager.test.ConfigManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;

public class Test {
    private static final Random RAND = new Random();

    public static void main(String[] args) throws InterruptedException {
        new Thread(){

            @Override
            public void run() {
                int i;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ArrayList<String> cfgs = new ArrayList<String>();
                ArrayList<String> comments = new ArrayList<String>();
                for (i = 0; i < 100; ++i) {
                    cfgs.add("test.test.test.test");
                }
                for (i = 0; i < 100; ++i) {
                    comments.add("Simple config xd");
                }
                System.out.println("Testing with ConfigManager 2");
                ConfigFile file = new ConfigFile(new File("test.cm2"));
                ConfigPicker picker = file.getPicker();
                for (String cfg : cfgs) {
                    picker.addConfig(cfg, "test");
                }
                for (String comment : comments) {
                    picker.addComment(comment);
                }
                file.save();
                file.save();
                long s1 = System.nanoTime();
                file.save();
                System.out.println((float)(System.nanoTime() - s1) / 1000000.0f + "ms write time");
                s1 = System.nanoTime();
                file.load();
                System.out.println((float)(System.nanoTime() - s1) / 1000000.0f + "ms read time");
                System.out.println("Testing with ConfigManager 1");
                ConfigManager cm = new ConfigManager(new File("test.cm2"));
                for (String cfg : cfgs) {
                    cm.addConfig(cfg, "test");
                }
                for (String comment : comments) {
                    cm.addComment(comment);
                }
            }
        }.start();
    }

    private static String randomConfig() {
        String str = "";
        for (int i = 0; i < 50; ++i) {
            str = str.length() >= 1 && !str.endsWith(".") && RAND.nextInt(10) >= 8 ? str + "." : str + (char)RAND.nextInt(65535);
        }
        return str;
    }
}

