/*
 * Decompiled with CFR 0.152.
 */
package de.proxietv.configmanager.objects;

import de.proxietv.configmanager.ConfigContainer;
import de.proxietv.configmanager.objects.Config;
import de.proxietv.configmanager.objects.ListItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Tree
extends Config {
    private final ConfigContainer container;
    private final List<Config> childs = new ArrayList<Config>();
    private final List<String> rawChilds = new ArrayList<String>();

    public Tree(String name, Tree parent) {
        super(name, parent);
        this.container = null;
    }

    public Tree(ConfigContainer container) {
        super("", null);
        this.container = container;
    }

    @Override
    public byte getType() {
        return 0;
    }

    public void addChild(Config config) {
        this.childs.add(config);
        if (config.getType() == 1 && this.isInsideRoot()) {
            this.getConfigContainer().getPicker().getAllConfigs().add(config);
        }
    }

    public List<Tree> getTreeChilds() {
        ArrayList<Tree> list = new ArrayList<Tree>();
        for (Config c : this.childs) {
            if (c.getType() != 0) continue;
            list.add((Tree)c);
        }
        return list;
    }

    @Nullable
    public Tree getTreeChild(String name) {
        for (Tree t : this.getTreeChilds()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public List<Config> getConfigChilds() {
        ArrayList<Config> list = new ArrayList<Config>();
        for (Config c : this.childs) {
            if (c.getType() != 1) continue;
            list.add(c);
        }
        return list;
    }

    @Nullable
    public Config getConfigChild(String name) {
        for (Config c : this.getConfigChilds()) {
            if (c.getType() != 1 || c.getName() == null || !c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public List<Config> getConfigChilds(String name) {
        ArrayList<Config> list = new ArrayList<Config>();
        for (Config c : this.getConfigChilds()) {
            if (c.getType() != 1 || c.getName() == null || !c.getName().equals(name)) continue;
            list.add(c);
        }
        return list;
    }

    @Deprecated
    public List<ListItem> getListItems() {
        ArrayList<ListItem> items = new ArrayList<ListItem>();
        for (Config c : this.getConfigChilds()) {
            if (c.getType() != 5) continue;
            items.add((ListItem)c);
        }
        return items;
    }

    public void clear() {
        this.childs.clear();
    }

    public boolean isRoot() {
        return this.container != null;
    }

    public boolean isInsideRoot() {
        return this.isRoot() ? true : this.getParent().isInsideRoot();
    }

    @Nullable
    public ConfigContainer getConfigContainer() {
        if (this.isInsideRoot()) {
            return this.isRoot() ? this.container : this.getParent().getConfigContainer();
        }
        return null;
    }

    public List<Config> getChilds() {
        return this.childs;
    }

    public List<String> getRawChilds() {
        return this.rawChilds;
    }
}

