/*
 * Decompiled with CFR 0.152.
 */
package de.proxietv.configmanager;

import de.proxietv.configmanager.ConfigContainer;
import de.proxietv.configmanager.objects.Comment;
import de.proxietv.configmanager.objects.Config;
import de.proxietv.configmanager.objects.Description;
import de.proxietv.configmanager.objects.EmptyLine;
import de.proxietv.configmanager.objects.Tree;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class IOHandler {
    private final ConfigContainer container;

    public IOHandler(ConfigContainer container) {
        this.container = container;
    }

    public int load() {
        this.container.getRootTree().clear();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.container.openInputStream(), StandardCharsets.UTF_8));
            String line = null;
            Tree tree = this.container.getRootTree();
            while ((line = reader.readLine()) != null) {
                if ((line = this.replaceFirstSpaces(line)).length() == 0) {
                    tree.addChild(new EmptyLine(tree));
                    continue;
                }
                char firstChar = line.charAt(0);
                char lastChar = line.charAt(line.length() - 1);
                boolean newParent = false;
                if (firstChar == '#') {
                    tree.addChild(new Comment(tree, this.replaceFirstSpaces(line.substring(1))));
                } else if (line.contains(":")) {
                    String[] strs = line.split(":");
                    String value = "";
                    for (int i = 1; i < strs.length; ++i) {
                        value = value + strs[i];
                        if (i + 1 >= strs.length) continue;
                        value = value + ":";
                    }
                    if (!line.startsWith("!")) {
                        tree.addChild(new Config(this.replaceLastSpaces(strs[0]), tree, this.replaceFirstSpaces(value)));
                    } else {
                        tree.addChild(new Description(tree, this.replaceLastSpaces(strs[0]).substring(1), this.replaceFirstSpaces(value)));
                    }
                } else if (lastChar == '{') {
                    String name = this.replaceLastSpaces(line.substring(0, line.length() - 1));
                    tree = new Tree(name, tree);
                    tree.getParent().addChild(tree);
                    newParent = true;
                } else if (this.replaceLastSpaces(line).equals("}")) {
                    tree = tree.getParent();
                    newParent = true;
                    if (tree == null) {
                        reader.close();
                        return 4;
                    }
                } else {
                    tree.addChild(new EmptyLine(tree));
                }
                if (newParent) continue;
                String value = this.replaceLastSpaces(line);
                tree.getRawChilds().add(value);
            }
            reader.close();
            if (!tree.equals(this.container.getRootTree())) {
                return 4;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public int save() {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.container.openOutputStream(), StandardCharsets.UTF_8));
            List<String> lines = this.getLines(this.container.getRootTree(), "");
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    private List<String> getLines(Tree tree, String currentPrefix) {
        return this.getLines(tree, currentPrefix, tree.equals(this.container.getRootTree()));
    }

    private List<String> getLines(Tree tree, String currentPrefix, boolean root) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Config c : tree.getChilds()) {
            if (c.getType() == 0) {
                lines.add(currentPrefix + c.getName() + " {");
                lines.addAll(this.getLines((Tree)c, currentPrefix + "\t", false));
                lines.add(currentPrefix + "}");
                continue;
            }
            if (c.getType() == 2) {
                lines.add(currentPrefix + "# " + c.getValue());
                continue;
            }
            if (c.getType() == 3) {
                lines.add("");
                continue;
            }
            if (c.getType() == 4) {
                lines.add(currentPrefix + "!" + c.getName() + ": " + c.getValue());
                continue;
            }
            if (c.getType() == 5) {
                lines.add(currentPrefix + c.getValue());
                continue;
            }
            lines.add(currentPrefix + c.getName() + ": " + c.getValue());
        }
        return lines;
    }

    private String replaceFirstSpaces(String str) {
        while (str.startsWith(" ") || str.startsWith("\t")) {
            str = str.substring(1, str.length());
        }
        return str;
    }

    private String replaceLastSpaces(String str) {
        while (str.endsWith(" ") || str.endsWith("\t")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public ConfigContainer getContainer() {
        return this.container;
    }
}

