/*
 * Decompiled with CFR 0.152.
 */
package de.proxietv.configmanager;

import de.proxietv.configmanager.ConfigContainer;
import de.proxietv.configmanager.objects.Comment;
import de.proxietv.configmanager.objects.Config;
import de.proxietv.configmanager.objects.Description;
import de.proxietv.configmanager.objects.EmptyLine;
import de.proxietv.configmanager.objects.Tree;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ConfigPicker {
    private final ConfigContainer container;
    private final List<Config> allConfigs = new ArrayList<Config>();

    public ConfigPicker(ConfigContainer container) {
        this.container = container;
    }

    public Config addConfig(String path, Object value) {
        return this.addConfig(path, value.toString());
    }

    public Config addConfig(String path, String value) {
        String[] strs = path.split("\\.");
        Tree tree = path.contains(".") ? this.getTree(path.substring(0, path.lastIndexOf(46)), true) : this.container.getRootTree();
        Config config = new Config(strs[strs.length - 1], tree, value);
        tree.addChild(config);
        this.allConfigs.add(config);
        return config;
    }

    public Comment addComment(String value) {
        return this.addComment("", value);
    }

    public Comment addComment(String path, String value) {
        Tree tree = this.getTree(path, true);
        Comment config = new Comment(tree, value);
        tree.addChild(config);
        return config;
    }

    public EmptyLine addEmptyLine() {
        return this.addEmptyLine("");
    }

    public EmptyLine addEmptyLine(String path) {
        Tree tree = this.getTree(path, true);
        EmptyLine config = new EmptyLine(tree);
        tree.addChild(config);
        return config;
    }

    @Nullable
    public Config getConfig(String path) {
        Tree tree = this.getTree(path.contains("\\.") ? path.substring(0, path.lastIndexOf(46)) : "", false);
        if (tree != null) {
            String[] strs = path.split("\\.");
            return tree.getConfigChild(strs[strs.length - 1]);
        }
        return !this.container.getConfigNeverNull ? null : new Config(null, null, null);
    }

    public List<Config> getConfigsWhichStartWith(String name) {
        ArrayList<Config> list = new ArrayList<Config>();
        for (Config c : this.allConfigs) {
            if (!c.getAbsolutePath().startsWith(name)) continue;
            list.add(c);
        }
        return list;
    }

    public List<Config> getConfigsWhichEndWith(String name) {
        ArrayList<Config> list = new ArrayList<Config>();
        for (Config c : this.allConfigs) {
            if (!c.getAbsolutePath().endsWith(name)) continue;
            list.add(c);
        }
        return list;
    }

    public List<Config> getConfigs(String name) {
        ArrayList<Config> list = new ArrayList<Config>();
        for (Config c : this.allConfigs) {
            if (!c.getAbsolutePath().equals(name)) continue;
            list.add(c);
        }
        return list;
    }

    public Description setDescription(String name, String value) {
        Description config;
        if (!this.containsBase()) {
            this.container.getRootTree().getChilds().add(0, new EmptyLine(this.container.getRootTree()));
        }
        if ((config = this.getDescription(name)) == null) {
            config = new Description(this.container.getRootTree(), name, value);
        } else {
            config.setValue(value);
        }
        this.container.getRootTree().getChilds().add(0, config);
        return config;
    }

    @Nullable
    public Description getDescription(String name) {
        for (Config c : this.container.getRootTree().getChilds()) {
            if (c.getName() == null || !c.getName().equals(name) || c.getType() != 4) continue;
            return (Description)c;
        }
        return null;
    }

    public boolean containsBase() {
        for (Config c : this.container.getRootTree().getChilds()) {
            if (c.getType() != 4 || !((Description)c).isBase()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Tree getTree(String path, boolean newInstance) {
        if (path.equals("")) {
            return this.container.getRootTree();
        }
        String[] strs = path.split("\\.");
        String name = "";
        Tree cTree = this.container.getRootTree();
        for (int cIndex = 0; cIndex < strs.length; ++cIndex) {
            if (!name.equals("")) {
                name = name + ".";
            }
            name = name + strs[cIndex];
            Tree nTree = cTree.getTreeChild(strs[cIndex]);
            if (nTree == null) {
                if (newInstance) {
                    nTree = new Tree(strs[cIndex], cTree);
                    cTree.addChild(nTree);
                } else {
                    return null;
                }
            }
            cTree = nTree;
        }
        return cTree;
    }

    public ConfigContainer getContainer() {
        return this.container;
    }

    public List<Config> getAllConfigs() {
        return this.allConfigs;
    }
}

