/*
 * Decompiled with CFR 0.152.
 */
package de.proxietv.configmanager;

import de.proxietv.configmanager.ConfigContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ConfigFile
extends ConfigContainer {
    private final File file;

    public ConfigFile(File file) {
        this(file, false);
    }

    public ConfigFile(File file, boolean getConfigNeverNull) {
        super(getConfigNeverNull);
        this.file = file;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public int load() {
        if (!this.file.exists()) {
            return 2;
        }
        if (!this.file.canRead()) {
            return 3;
        }
        return super.load();
    }

    @Override
    public int save() {
        if (this.file.exists() && !this.file.canWrite()) {
            return 2;
        }
        try {
            if (this.file.exists()) {
                this.file.delete();
            }
            this.file.createNewFile();
            if (!this.file.canWrite()) {
                return 2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 2;
        }
        return super.save();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public File getFile() {
        return this.file;
    }
}

