/*
 * Decompiled with CFR 0.152.
 */
package de.proxietv.configmanager.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ConfigManager {
    private static final Random rand = new Random();
    private File configFile = null;
    private MultiKey.MultiKeyMap<String, Object> configs = new MultiKey.MultiKeyMap();

    public ConfigManager(File file) {
        this(file, true);
    }

    public ConfigManager(File file, boolean createNewFile) {
        this.setPath(file.getAbsolutePath(), createNewFile);
    }

    public ConfigManager(String pluginName, String configName) {
        this(pluginName, configName, true);
    }

    public ConfigManager(String pluginName, String configName, boolean createNewFile) {
        this.setPath("plugins/" + pluginName + "/" + configName, createNewFile);
    }

    public void addConfig(String name) {
        this.configs.put(name, null);
    }

    public void addConfig(String name, Object value) {
        this.configs.put(name, value);
    }

    public void addConfig(String name, String value) {
        this.configs.put(name, value);
    }

    public void addConfig(String name, boolean value) {
        this.configs.put(name, value);
    }

    public void addConfig(String name, Double value) {
        this.configs.put(name, value);
    }

    public void addConfig(String name, int value) {
        this.configs.put(name, value);
    }

    public void addComment(String comment) {
        this.addConfig("# " + comment, "");
    }

    public String getConfigString(String name) {
        Object obj = this.getConfigObj(name);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public Boolean getConfigBoolean(String name) {
        String str;
        Object obj = this.getConfigObj(name);
        if (obj instanceof Boolean) {
            return (boolean)((Boolean)obj);
        }
        if (obj instanceof String && ((str = String.valueOf(obj)).equalsIgnoreCase("true") || str.equalsIgnoreCase("false"))) {
            return Boolean.valueOf(str);
        }
        return null;
    }

    public Double getConfigDouble(String name) {
        Object obj = this.getConfigObj(name);
        if (obj instanceof Double) {
            return (double)((Double)obj);
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof String) {
            return Double.valueOf((String)obj);
        }
        return null;
    }

    public Integer getConfigInt(String name) {
        Object obj = this.getConfigObj(name);
        if (obj instanceof String && ConfigManager.Util_IsInteger(String.valueOf(obj))) {
            return Integer.valueOf(String.valueOf(obj));
        }
        return null;
    }

    public void addEmptyLine() {
        this.addConfig("empty" + rand.nextInt(), (String)null);
    }

    public MultiKey.MultiKeyMap<String, String> getKeysWhichStartWith(String startsWith) {
        MultiKey.MultiKeyMap<String, String> list = new MultiKey.MultiKeyMap<String, String>();
        for (MultiKey.MultiKeyEntry<String, Object> MultiKeyEntry2 : this.configs.entrySet()) {
            String name = MultiKeyEntry2.getKey();
            if (!name.startsWith(startsWith)) continue;
            if (MultiKeyEntry2.getValue() != null) {
                String value = MultiKeyEntry2.getValue().toString();
                list.put(name, value);
                continue;
            }
            list.put(name, null);
        }
        return list;
    }

    public MultiKey.MultiKeyMap<String, String> getKeysWhichEndWith(String endsWith) {
        MultiKey.MultiKeyMap<String, String> list = new MultiKey.MultiKeyMap<String, String>();
        for (MultiKey.MultiKeyEntry<String, Object> MultiKeyEntry2 : this.configs.entrySet()) {
            String name = MultiKeyEntry2.getKey();
            if (!name.endsWith(endsWith)) continue;
            if (MultiKeyEntry2.getValue() != null) {
                String value = MultiKeyEntry2.getValue().toString();
                list.put(name, value);
                continue;
            }
            list.put(name, null);
        }
        return list;
    }

    public MultiKey.MultiKeyMap<String, String> getKeysWhichEqualsWith(String equalsWith) {
        MultiKey.MultiKeyMap<String, String> list = new MultiKey.MultiKeyMap<String, String>();
        for (MultiKey.MultiKeyEntry<String, Object> MultiKeyEntry2 : this.configs.entrySet()) {
            String name = MultiKeyEntry2.getKey();
            if (!name.equals(equalsWith)) continue;
            if (MultiKeyEntry2.getValue() != null) {
                String value = MultiKeyEntry2.getValue().toString();
                list.put(name, value);
                continue;
            }
            list.put(name, null);
        }
        return list;
    }

    public Object getConfigObj(String name) {
        return this.configs.getFirst(name);
    }

    public boolean update() {
        if (!this.configFile.exists()) {
            this.save();
            return false;
        }
        return true;
    }

    public MultiKey.MultiKeyMap<String, Object> getInside(int insideLvl) {
        MultiKey.MultiKeyMap<String, Object> list = new MultiKey.MultiKeyMap<String, Object>();
        for (MultiKey.MultiKeyEntry<String, Object> MultiKeyEntry2 : this.configs.entrySet()) {
            String name = MultiKeyEntry2.getKey();
            Object value = MultiKeyEntry2.getValue();
            if (String.valueOf(name).startsWith("# ") || name.split("\\.").length - 1 != insideLvl) continue;
            String str = "";
            int i = 1;
            int max = name.split("\\.").length;
            for (String s : name.split("\\.")) {
                while (s.startsWith("\t")) {
                    s = s.substring(1, s.length());
                }
                if (i >= max) {
                    str = str + s;
                    continue;
                }
                str = str + s + ".";
                ++i;
            }
            if (value instanceof String) {
                String v = (String)value;
                while (v.startsWith("\t")) {
                    v = v.substring(1, v.length());
                }
                value = v;
            }
            list.put(str, value);
        }
        return list;
    }

    public void save() {
        try {
            this.savee();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void savee() throws IOException {
        if (this.configFile.exists()) {
            this.configFile.delete();
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), "UTF8"));
        ArrayList<String> doneInsideConfigs = new ArrayList<String>();
        for (MultiKey.MultiKeyEntry<String, Object> MultiKeyEntry2 : this.configs.entrySet()) {
            String name = MultiKeyEntry2.getKey();
            Object value = MultiKeyEntry2.getValue();
            if (name.startsWith("empty") && value == null) {
                bw.write("");
                bw.newLine();
                continue;
            }
            if (!String.valueOf(name).startsWith("# ")) {
                if (name.split("\\.").length >= 2) {
                    String insideConfig = "";
                    for (int i = 0; i < name.split("\\.").length - 1; ++i) {
                        insideConfig = i <= name.split("\\.").length - 2 ? insideConfig + name.split("\\.")[i] : insideConfig + name.split("\\.")[i] + ".";
                    }
                    if (doneInsideConfigs.contains(insideConfig)) continue;
                    bw.write(insideConfig + " {");
                    bw.newLine();
                    for (MultiKey.MultiKeyEntry<String, Object> MultiKeyEntry1 : this.configs.entrySet()) {
                        String name1 = MultiKeyEntry1.getKey();
                        Object value1 = MultiKeyEntry1.getValue();
                        if (String.valueOf(name1).startsWith("# ") || name1.split("\\.").length < 2) continue;
                        String insideConfig1 = "";
                        for (int i = 0; i < name1.split("\\.").length - 1; ++i) {
                            insideConfig1 = i <= name1.split("\\.").length - 2 ? insideConfig1 + name1.split("\\.")[i] : insideConfig1 + name1.split("\\.")[i] + ".";
                        }
                        if (!insideConfig.equals(insideConfig1)) continue;
                        String s = "";
                        for (int i = 0; i < name1.split("\\.").length - 1; ++i) {
                            s = s + "\t";
                        }
                        if (value1 != null) {
                            bw.write(s + name1.replace(insideConfig, "").substring(1) + ": " + String.valueOf(value1));
                        } else {
                            bw.write(s + name1.replace(insideConfig, "").substring(1));
                        }
                        bw.newLine();
                    }
                    doneInsideConfigs.add(insideConfig);
                    bw.write("}");
                    bw.newLine();
                    continue;
                }
                if (value != null) {
                    bw.write(name + ": " + String.valueOf(value));
                } else {
                    bw.write(name);
                }
                bw.newLine();
                continue;
            }
            bw.write(name);
            bw.newLine();
        }
        bw.close();
    }

    public void load() {
        this.load(true);
    }

    public void load(boolean utf8) {
        BufferedReader br = null;
        try {
            br = !utf8 ? new BufferedReader(new InputStreamReader(new FileInputStream(this.configFile))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.configFile), "UTF8"));
        }
        catch (Exception e) {
            System.err.println("[MBedwars] There was an issue with loading a config with utf8.");
            if (!utf8) {
                e.printStackTrace();
            }
            this.load(false);
        }
        String line = null;
        String currentLooking = "";
        try {
            this.clear();
            while ((line = br.readLine()) != null) {
                String[] strs;
                boolean b = false;
                if (line.endsWith("{")) {
                    String z = line.substring(0, line.length() - 1);
                    while (z.startsWith("\t")) {
                        z = z.substring(1, z.length());
                    }
                    while (z.endsWith(" ")) {
                        z = z.substring(0, z.length() - 1);
                    }
                    currentLooking = currentLooking.equals("") ? currentLooking + z : currentLooking + "." + z;
                    b = true;
                } else if (line.startsWith("}") && !line.equals("")) {
                    strs = currentLooking.split("\\.");
                    currentLooking = currentLooking.substring(0, currentLooking.length() - strs[strs.length - 1].length());
                    b = true;
                }
                if (b) continue;
                strs = line.split(":");
                String name = strs[0];
                String value = "";
                if (strs.length >= 2) {
                    for (int i = 1; i < strs.length; ++i) {
                        value = i > 1 ? value + ":" + strs[i] : value + strs[i];
                    }
                } else {
                    value = null;
                }
                if (value != null) {
                    while (value.startsWith("\t") || value.startsWith(" ")) {
                        value = value.substring(1, value.length());
                    }
                }
                while (name.startsWith("\t") || name.startsWith(" ")) {
                    name = name.substring(1, name.length());
                }
                if (currentLooking.equals("")) {
                    this.configs.put(name, value);
                    continue;
                }
                this.configs.put(currentLooking + "." + name, value);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> getInsideAsStringList(String insideName) {
        ArrayList<String> list = new ArrayList<String>();
        for (MultiKey.MultiKeyEntry<String, String> e : this.getKeysWhichStartWith(insideName).entrySet()) {
            String str = e.getKey().replaceFirst(insideName.endsWith(".") ? insideName : insideName + ".", "") + (e.getValue() != null ? ": " + e.getValue() : "");
            while (str.startsWith("\t") || str.startsWith(" ")) {
                str = str.substring(1, str.length());
            }
            list.add(str);
        }
        return list;
    }

    public void clear() {
        this.configs.clear();
    }

    public boolean exists() {
        return this.configFile.exists();
    }

    public boolean isEmpty() {
        return this.configFile.length() == 0L;
    }

    public void setPath(String path) {
        this.setPath(path, true);
    }

    public void setPath(String path, boolean createNewFile) {
        this.configFile = new File(path);
        File dir = this.configFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (createNewFile && !this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getPath() {
        return this.configFile.getPath();
    }

    public File getFile() {
        return this.configFile;
    }

    public MultiKey.MultiKeyMap<String, Object> getCache() {
        return this.configs;
    }

    private static boolean Util_IsInteger(String str) {
        try {
            Integer.valueOf(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void saveRecourceFile(Class klasse, String name, String path, boolean replace) {
        File file = new File(path, name);
        File filepath = new File(path);
        if (replace && file.exists()) {
            file.delete();
            ConfigManager.saveRecource(klasse, name, path);
        } else {
            filepath.mkdirs();
            ConfigManager.saveRecource(klasse, name, path);
        }
    }

    private static void saveRecource(Class klasse, String name, String path) {
        try {
            InputStream inStream = klasse.getResourceAsStream("/" + name);
            FileOutputStream outStream = new FileOutputStream(new File(path, name));
            int b = -1;
            while ((b = inStream.read()) != -1) {
                ((OutputStream)outStream).write(b);
            }
            inStream.close();
            ((OutputStream)outStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class MultiKey {

        public static class MultiKeyMap<obj1, obj2> {
            List<obj1> l1 = new ArrayList<obj1>();
            List<obj2> l2 = new ArrayList<obj2>();

            public MultiKeyMap() {
            }

            public MultiKeyMap(MultiKeyMap<obj1, obj2> map) {
                this.l1 = new ArrayList<obj1>(map.l1);
                this.l2 = new ArrayList<obj2>(map.l2);
            }

            public int size() {
                return this.l1.size();
            }

            public void put(obj1 o1, obj2 o2) {
                this.l1.add(o1);
                this.l2.add(o2);
            }

            public obj2 getFirst(obj1 o1) {
                if (this.get(o1).size() >= 1) {
                    return this.get(o1).get(0);
                }
                return null;
            }

            public List<obj2> get(obj1 o1) {
                ArrayList<obj2> list = new ArrayList<obj2>();
                int i = 0;
                for (obj1 o : this.l1) {
                    if (o1.equals(o)) {
                        list.add(this.l2.get(i));
                    }
                    ++i;
                }
                return list;
            }

            public List<MultiKeyEntry<obj1, obj2>> entrySet() {
                ArrayList<MultiKeyEntry<obj1, obj2>> list = new ArrayList<MultiKeyEntry<obj1, obj2>>();
                int i = 0;
                for (obj1 o : new ArrayList<obj1>(this.l1)) {
                    list.add(new MultiKeyEntry<obj1, obj2>(o, this.l2.get(i)));
                    ++i;
                }
                return list;
            }

            public void remove(obj1 o1) {
                int i = 0;
                for (obj1 o : this.l1) {
                    if (o.equals(o1)) {
                        this.l1.remove(i);
                        this.l2.remove(i);
                    }
                    ++i;
                }
            }

            public void remove(obj1 o1, obj2 o2) {
                int i = 0;
                for (obj1 o : new ArrayList<obj1>(this.l1)) {
                    if (o.equals(o1) && this.l2.get(i).equals(o2)) {
                        this.l1.remove(i);
                        this.l2.remove(i);
                        --i;
                    }
                    ++i;
                }
            }

            public boolean containsKey(obj1 o1) {
                return this.l1.contains(o1);
            }

            public boolean containsValue(obj2 o2) {
                return this.l2.contains(o2);
            }

            public void replace(obj1 o1, obj2 o2) {
                this.remove(o1);
                this.put(o1, o2);
            }

            public List<obj1> keySet() {
                return new ArrayList<obj1>(this.l1);
            }

            public List<obj2> values() {
                return new ArrayList<obj2>(this.l2);
            }

            public boolean removeFirst() {
                if (this.size() >= 1) {
                    this.l1.remove(0);
                    this.l2.remove(0);
                    return true;
                }
                return false;
            }

            public boolean removeLast() {
                if (this.size() >= 1) {
                    this.l1.remove(this.l1.size() - 1);
                    this.l2.remove(this.l2.size() - 2);
                    return true;
                }
                return false;
            }

            public void clear() {
                this.l1.clear();
                this.l2.clear();
            }
        }

        public static class MultiKeyEntry<obj1, obj2>
        implements Map.Entry<obj1, obj2> {
            private obj1 o1;
            private obj2 o2;

            public MultiKeyEntry(obj1 key, obj2 value) {
                this.o1 = key;
                this.o2 = value;
            }

            @Override
            public obj1 getKey() {
                return this.o1;
            }

            @Override
            public obj2 getValue() {
                return this.o2;
            }

            @Override
            public obj2 setValue(obj2 value) {
                this.o2 = value;
                return value;
            }
        }
    }
}

