/*
 * Decompiled with CFR 0.152.
 */
package de.proxietv.configmanager.objects;

import de.proxietv.configmanager.objects.Tree;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Config {
    public static final byte TYPE_TREE = 0;
    public static final byte TYPE_CONFIG = 1;
    public static final byte TYPE_COMMENT = 2;
    public static final byte TYPE_EMPTYLINE = 3;
    public static final byte TYPE_DESCRIPTION = 4;
    public static final byte TYPE_LISTITEM = 5;
    private final String name;
    private final Tree parent;
    String value;

    public Config(String name, Tree parent) {
        this(name, parent, null);
    }

    public Config(String name, Tree parent, String value) {
        this.name = name;
        this.parent = parent;
        this.value = value;
    }

    public byte getType() {
        return 1;
    }

    public String getAbsolutePath() {
        return this.parent != null ? this.parent.getAbsolutePath() + (!this.parent.getAbsolutePath().isEmpty() ? "." : "") + this.name : "";
    }

    @Nullable
    public Boolean getValueAsBoolean() {
        if (this.getValue().equalsIgnoreCase("true") || this.value.equalsIgnoreCase("false")) {
            return Boolean.valueOf(this.getValue());
        }
        return null;
    }

    @Nullable
    public int getValueAsInt() {
        String value = this.getValue();
        return Integer.parseInt(value);
    }

    @Nullable
    private static Boolean getBoolean(String str) {
        return Boolean.valueOf(str);
    }

    public static List<String> valuesToString(List<Config> configs) {
        ArrayList<String> list = new ArrayList<String>();
        for (Config c : configs) {
            list.add(c.value);
        }
        return list;
    }

    public String getName() {
        return this.name;
    }

    public Tree getParent() {
        return this.parent;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

