/*
 * Decompiled with CFR 0.152.
 */
package de.proxietv.configmanager;

import de.proxietv.configmanager.ConfigFile;
import de.proxietv.configmanager.objects.Config;
import de.proxietv.configmanager.objects.Description;
import de.proxietv.configmanager.objects.ListItem;
import de.proxietv.configmanager.objects.Tree;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

public class EZConfigManager
extends ConfigFile {
    public EZConfigManager(File file) {
        this(file, true);
    }

    public EZConfigManager(File file, boolean createNewFile) {
        super(file);
        File dir = this.getFile().getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (createNewFile && !this.getFile().exists()) {
            try {
                this.getFile().createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public EZConfigManager(String path) {
        this(path, true);
    }

    public EZConfigManager(String path, boolean createNewFile) {
        this(new File(path));
    }

    public void addConfig(String name, Object value) {
        this.getPicker().addConfig(name, value);
    }

    public void addComment(String value) {
        this.getPicker().addComment(value);
    }

    public void addComment(String value, String path) {
        this.getPicker().addComment(path, value);
    }

    @Nullable
    public String getConfigString(String name) {
        Config config = this.getPicker().getConfig(name);
        if (config != null) {
            return config.getValue();
        }
        return null;
    }

    @Nullable
    public Boolean getConfigBoolean(String name) {
        String config = this.getConfigString(name);
        if (config != null && (config.equalsIgnoreCase("true") || config.equalsIgnoreCase("false"))) {
            return Boolean.valueOf(config);
        }
        return null;
    }

    private static boolean isDouble(String str) {
        try {
            Double.valueOf(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isInteger(String str) {
        try {
            Integer.valueOf(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nullable
    public Double getConfigDouble(String name) {
        String config = this.getConfigString(name);
        if (config != null && EZConfigManager.isDouble(config)) {
            return Double.valueOf(config);
        }
        return null;
    }

    @Nullable
    public Integer getConfigInt(String name) {
        String config = this.getConfigString(name);
        if (config != null && EZConfigManager.isInteger(config)) {
            return Integer.valueOf(config);
        }
        return null;
    }

    public void addEmptyLine() {
        this.getPicker().addEmptyLine();
    }

    public void addEmptyLine(String path) {
        this.getPicker().addEmptyLine(path);
    }

    public List<Config> getConfigsWhichStartWith(String startsWith) {
        return this.getPicker().getConfigsWhichStartWith(startsWith);
    }

    public List<Config> getConfigsWhichEndWith(String startsWith) {
        return this.getPicker().getConfigsWhichEndWith(startsWith);
    }

    public List<Config> getConfigs(String equals) {
        return this.getPicker().getConfigs(equals);
    }

    @Nullable
    public List<String> getListItems(String path) {
        Tree tree = this.getPicker().getTree(path, false);
        if (tree != null) {
            return tree.getRawChilds();
        }
        return null;
    }

    public void addListItems(List<String> items, String path) {
        Tree tree = this.getPicker().getTree(path, true);
        for (String item : items) {
            tree.addChild(new ListItem(item, tree));
            tree.getRawChilds().add(item);
        }
    }

    @Nullable
    public String getDescription(String name) {
        Description desc = this.getPicker().getDescription(name);
        return desc != null ? desc.getValue() : null;
    }

    public void addDescription(String name, String value) {
        this.getPicker().setDescription(name, value);
    }
}

