/*
 * Decompiled with CFR 0.152.
 */
package de.proxietv.configmanager;

import de.proxietv.configmanager.ConfigPicker;
import de.proxietv.configmanager.IOHandler;
import de.proxietv.configmanager.objects.Tree;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ConfigContainer {
    public static final String VERSION = "2.2";
    public boolean getConfigNeverNull = false;
    private final IOHandler ioHandler;
    private final ConfigPicker picker;
    private final Tree rootTree = new Tree(this);

    public ConfigContainer() {
        this(false);
    }

    public ConfigContainer(boolean getConfigNeverNull) {
        this.ioHandler = new IOHandler(this);
        this.picker = new ConfigPicker(this);
        this.getConfigNeverNull = getConfigNeverNull;
    }

    public abstract InputStream openInputStream() throws IOException;

    public abstract OutputStream openOutputStream() throws IOException;

    public void clear() {
        this.rootTree.clear();
        this.picker.getAllConfigs().clear();
    }

    public int load() {
        return this.ioHandler.load();
    }

    public int save() {
        return this.ioHandler.save();
    }

    public ConfigPicker getPicker() {
        return this.picker;
    }

    public Tree getRootTree() {
        return this.rootTree;
    }
}

