/*
 * Decompiled with CFR 0.152.
 */
package de.profhenry.sshsig.core;

import de.profhenry.sshsig.core.HashAlgorithm;
import de.profhenry.sshsig.core.JcaSingingBackend;
import de.profhenry.sshsig.core.SshBuffer;
import de.profhenry.sshsig.core.SshPublicKeyEncoder;
import de.profhenry.sshsig.core.SshSignature;
import de.profhenry.sshsig.core.SshSignatureException;
import de.profhenry.sshsig.core.spi.SigningBackend;
import de.profhenry.sshsig.core.util.HexUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SshSignatureGenerator<K> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshSignatureGenerator.class);
    private static final String MAGIC_PREAMBLE = "SSHSIG";
    private static final int SIG_VERSION = 1;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final SigningBackend<K> signingBackend;
    private final SshPublicKeyEncoder publicKeyEncoder;
    private final HashAlgorithm hashAlgorithm;
    private final int bufferSize;

    private SshSignatureGenerator(SigningBackend<K> aSigningBackend, SshPublicKeyEncoder aPublicKeyEncoder, HashAlgorithm aHashAlgorithm, int aBufferSize) {
        this.signingBackend = aSigningBackend;
        this.publicKeyEncoder = aPublicKeyEncoder;
        this.hashAlgorithm = aHashAlgorithm;
        this.bufferSize = Math.max(1024, aBufferSize);
    }

    public SigningBackend<K> getSigningBackend() {
        return this.signingBackend;
    }

    public SshPublicKeyEncoder getPublicKeyEncoder() {
        return this.publicKeyEncoder;
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public SshSignature generateSignature(K aKey, String aNamespace, String aMessage) throws SshSignatureException {
        Objects.requireNonNull(aKey, "key is required.");
        Objects.requireNonNull(aNamespace, "namespace is required.");
        Objects.requireNonNull(aMessage, "message is required.");
        LOGGER.info("Generating SSH signature...");
        LOGGER.info("namespace: '{}'", (Object)aNamespace);
        LOGGER.info("message: '{}'", (Object)aMessage);
        return this.generateSignature0(aKey, aNamespace, this.hashMessage(aMessage.getBytes()));
    }

    public SshSignature generateSignature(K aKey, String aNamespace, byte[] aMessage) throws SshSignatureException {
        Objects.requireNonNull(aKey, "key is required.");
        Objects.requireNonNull(aNamespace, "namespace is required.");
        Objects.requireNonNull(aMessage, "message is required.");
        LOGGER.info("Generating SSH signature...");
        LOGGER.info("namespace: '{}'", (Object)aNamespace);
        LOGGER.info("message: {}", (Object)Arrays.toString(aMessage));
        return this.generateSignature0(aKey, aNamespace, this.hashMessage(aMessage));
    }

    public SshSignature generateSignature(K aKey, String aNamespace, File aFile) throws IOException, SshSignatureException {
        Objects.requireNonNull(aKey, "key is required.");
        Objects.requireNonNull(aNamespace, "namespace is required.");
        Objects.requireNonNull(aFile, "file is required.");
        LOGGER.info("Generating SSH signature...");
        LOGGER.info("namespace: '{}'", (Object)aNamespace);
        LOGGER.info("message: {}", (Object)aFile.getCanonicalPath());
        try (FileInputStream tFileInputStream = new FileInputStream(aFile);){
            SshSignature sshSignature = this.generateSignature0(aKey, aNamespace, this.hashMessage(tFileInputStream));
            return sshSignature;
        }
    }

    public SshSignature generateSignature(K aKey, String aNamespace, InputStream anInputStream) throws IOException, SshSignatureException {
        Objects.requireNonNull(aKey, "key is required.");
        Objects.requireNonNull(aNamespace, "namespace is required.");
        Objects.requireNonNull(anInputStream, "input stream is required.");
        LOGGER.info("Generating SSH signature...");
        LOGGER.info("namespace: '{}'", (Object)aNamespace);
        LOGGER.info("message: {}", (Object)anInputStream.getClass().getName());
        return this.generateSignature0(aKey, aNamespace, this.hashMessage(anInputStream));
    }

    private byte[] hashMessage(byte[] aMessage) throws SshSignatureException {
        MessageDigest tMessageDigest = this.hashAlgorithm.createMessageDigestInstance();
        LOGGER.debug("hashed {} bytes using {} ({})", new Object[]{aMessage.length, tMessageDigest.getAlgorithm(), tMessageDigest.getProvider()});
        byte[] tHash = tMessageDigest.digest(aMessage);
        LOGGER.debug("hashed message: {}", (Object)HexUtil.bytesToHex(tHash));
        return tHash;
    }

    private byte[] hashMessage(InputStream anInputStream) throws SshSignatureException, IOException {
        int i;
        MessageDigest tMessageDigest = this.hashAlgorithm.createMessageDigestInstance();
        byte[] tBuffer = new byte[this.bufferSize];
        int tReadBytes = 0;
        while ((i = anInputStream.read(tBuffer, 0, tBuffer.length)) >= 0) {
            tMessageDigest.update(tBuffer, 0, i);
            tReadBytes += i;
        }
        byte[] tHash = tMessageDigest.digest();
        LOGGER.debug("hashed {} bytes using {} ({})", new Object[]{tReadBytes, tMessageDigest.getAlgorithm(), tMessageDigest.getProvider()});
        LOGGER.debug("hashed message: {}", (Object)HexUtil.bytesToHex(tHash));
        return tHash;
    }

    private SshSignature generateSignature0(K aKey, String aNamespace, byte[] aHashedMessage) throws SshSignatureException {
        byte[] tDataToSign = this.generateDataToSign(aNamespace, aHashedMessage);
        LOGGER.debug("data to sign: {}", (Object)HexUtil.bytesToHex(tDataToSign));
        SigningBackend.SigningResult tSigningResult = this.signingBackend.signData(aKey, tDataToSign);
        LOGGER.debug("signed data: {}", (Object)HexUtil.bytesToHex(tSigningResult.getSignedContent()));
        SshBuffer tBuffer = new SshBuffer();
        tBuffer.appendPreamble(MAGIC_PREAMBLE);
        tBuffer.appendInt(1);
        tBuffer.appendByteArray(this.publicKeyEncoder.encodePublicKey(this.signingBackend.extractPublicKey(aKey)));
        tBuffer.appendString(aNamespace);
        tBuffer.appendInt(0);
        tBuffer.appendString(this.hashAlgorithm.getNameUsedInSshProtocol());
        tBuffer.appendStringAndByteArray(tSigningResult.getSignatureAlgorithm().getNameUsedInSshProtocol(), tSigningResult.getSignedContent());
        return new SshSignature(tBuffer.toByteArray(), tSigningResult.getSignatureAlgorithm());
    }

    private byte[] generateDataToSign(String aNamespace, byte[] aHashedMessage) {
        SshBuffer tBuffer = new SshBuffer();
        tBuffer.appendPreamble(MAGIC_PREAMBLE);
        tBuffer.appendString(aNamespace);
        tBuffer.appendInt(0);
        tBuffer.appendString(this.hashAlgorithm.getNameUsedInSshProtocol());
        tBuffer.appendByteArray(aHashedMessage);
        return tBuffer.toByteArray();
    }

    public static SshSignatureGenerator<KeyPair> create() {
        return new SshSignatureGenerator<KeyPair>(new JcaSingingBackend(), new SshPublicKeyEncoder(), HashAlgorithm.SHA_512, 8192);
    }

    public <KK> SshSignatureGenerator<KK> withSigningBackend(SigningBackend<KK> aSigningBackend) {
        return new SshSignatureGenerator<KK>(aSigningBackend, this.publicKeyEncoder, this.hashAlgorithm, this.bufferSize);
    }

    public SshSignatureGenerator<K> withPublicKeyEncoder(SshPublicKeyEncoder aPublicKeyEncoder) {
        return new SshSignatureGenerator<K>(this.signingBackend, aPublicKeyEncoder, this.hashAlgorithm, this.bufferSize);
    }

    public SshSignatureGenerator<K> withHashAlgorithm(HashAlgorithm aHashAlgorithm) {
        return new SshSignatureGenerator<K>(this.signingBackend, this.publicKeyEncoder, aHashAlgorithm, this.bufferSize);
    }

    public SshSignatureGenerator<K> withBufferSize(int aBufferSize) {
        return new SshSignatureGenerator<K>(this.signingBackend, this.publicKeyEncoder, this.hashAlgorithm, aBufferSize);
    }
}

