/*
 * Decompiled with CFR 0.152.
 */
package de.profhenry.sshsig.core;

import de.profhenry.sshsig.core.PemWriter;
import de.profhenry.sshsig.core.SignatureAlgorithm;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class SshSignature {
    private static final String PEM_LABEL = "SSH SIGNATURE";
    private static final int LINE_LENGTH = 70;
    private final byte[] signatureData;
    private final SignatureAlgorithm signatureAlgorithm;

    public SshSignature(byte[] someSignatureData, SignatureAlgorithm aSignatureAlgorithm) {
        this.signatureData = someSignatureData;
        this.signatureAlgorithm = aSignatureAlgorithm;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public byte[] getSignatureData() {
        return this.signatureData;
    }

    public String toPem() {
        StringWriter tWriter = new StringWriter();
        this.writeAsPem(tWriter);
        return tWriter.toString();
    }

    public void writeAsPem(Writer aWriter) {
        PemWriter tPemWriter = new PemWriter(aWriter, 70);
        tPemWriter.writeData(PEM_LABEL, this.signatureData);
    }

    public void writeAsPem(Path aPath) throws IOException {
        try (BufferedWriter tWriter = Files.newBufferedWriter(aPath, new OpenOption[0]);){
            this.writeAsPem(tWriter);
        }
    }
}

