/*
 * Decompiled with CFR 0.152.
 */
package de.profhenry.sshsig.core;

import de.profhenry.sshsig.core.SshBuffer;
import de.profhenry.sshsig.core.SshSignatureException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;

public class SshPublicKeyEncoder {
    private static final String KEY_FORMAT_IDENTIFIER_DSS = "ssh-dss";
    private static final String KEY_FORMAT_IDENTIFIER_RSA = "ssh-rsa";
    private static final String KEY_FORMAT_IDENTIFIER_ED25519 = "ssh-ed25519";

    public byte[] encodePublicKey(PublicKey aPublicKey) throws SshSignatureException {
        if (aPublicKey instanceof DSAPublicKey) {
            return this.encodeDsaPublicKey((DSAPublicKey)aPublicKey);
        }
        if (aPublicKey instanceof RSAPublicKey) {
            return this.encodeRsaPublicKey((RSAPublicKey)aPublicKey);
        }
        if ("Ed25519".equals(aPublicKey.getAlgorithm())) {
            return this.encodeEd25519PublicKey(aPublicKey);
        }
        if ("EdDSA".equals(aPublicKey.getAlgorithm())) {
            return this.encodeEd25519PublicKey(aPublicKey);
        }
        throw new SshSignatureException("Could not encode public key (" + aPublicKey.getClass().getName() + ")!");
    }

    protected final byte[] encodeDsaPublicKey(DSAPublicKey aDsaPublicKey) {
        SshBuffer tBuffer = new SshBuffer();
        tBuffer.appendString(KEY_FORMAT_IDENTIFIER_DSS);
        tBuffer.appendBigInteger(aDsaPublicKey.getParams().getP());
        tBuffer.appendBigInteger(aDsaPublicKey.getParams().getQ());
        tBuffer.appendBigInteger(aDsaPublicKey.getParams().getG());
        tBuffer.appendBigInteger(aDsaPublicKey.getY());
        return tBuffer.toByteArray();
    }

    protected final byte[] encodeRsaPublicKey(RSAPublicKey aRsaPublicKey) {
        SshBuffer tBuffer = new SshBuffer();
        tBuffer.appendString(KEY_FORMAT_IDENTIFIER_RSA);
        tBuffer.appendBigInteger(aRsaPublicKey.getPublicExponent());
        tBuffer.appendBigInteger(aRsaPublicKey.getModulus());
        return tBuffer.toByteArray();
    }

    protected byte[] encodeEd25519PublicKey(PublicKey aPublicKey) throws SshSignatureException {
        if ("X.509".equals(aPublicKey.getFormat())) {
            SshBuffer tBuffer = new SshBuffer();
            tBuffer.appendString(KEY_FORMAT_IDENTIFIER_ED25519);
            tBuffer.appendByteArray(aPublicKey.getEncoded(), 12, 32);
            return tBuffer.toByteArray();
        }
        throw new SshSignatureException("Cannot encode ED25519 public key which has " + aPublicKey.getFormat() + " format!");
    }
}

