/*
 * Decompiled with CFR 0.152.
 */
package de.profhenry.sshsig.core;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public final class SshBuffer {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

    public void appendPreamble(String aPreamble) {
        this.write(aPreamble);
    }

    public void appendString(String aString) {
        this.write(aString.length());
        this.write(aString);
    }

    public void appendByteArray(byte[] aByteArray) {
        this.write(aByteArray.length);
        this.write(aByteArray);
    }

    public void appendByteArray(byte[] aByteArray, int anOffset, int aLength) {
        this.write(aLength);
        this.write(aByteArray, anOffset, aLength);
    }

    public void appendInt(int anInteger) {
        this.write(anInteger);
    }

    public void appendBigInteger(BigInteger aBigInteger) {
        this.appendByteArray(aBigInteger.toByteArray());
    }

    public void appendStringAndByteArray(String aString, byte[] aByteArray) {
        this.write(4 + aString.length() + 4 + aByteArray.length);
        this.appendString(aString);
        this.appendByteArray(aByteArray);
    }

    public byte[] toByteArray() {
        return this.byteArrayOutputStream.toByteArray();
    }

    private void write(byte[] aByteArray, int anOffset, int aLength) {
        this.byteArrayOutputStream.write(aByteArray, anOffset, aLength);
    }

    private void write(byte[] aByteArray) {
        this.write(aByteArray, 0, aByteArray.length);
    }

    private void write(String aString) {
        this.write(aString.getBytes(StandardCharsets.US_ASCII));
    }

    private void write(int anInt) {
        this.byteArrayOutputStream.write(anInt >>> 24);
        this.byteArrayOutputStream.write(anInt >>> 16);
        this.byteArrayOutputStream.write(anInt >>> 8);
        this.byteArrayOutputStream.write(anInt >>> 0);
    }
}

