/*
 * Decompiled with CFR 0.152.
 */
package de.profhenry.sshsig.core;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Base64;

public class PemWriter {
    private static final int DEFAULT_LINE_LENGTH = 64;
    private final PrintWriter printWriter;
    private final int lineLength;

    public PemWriter(Writer aWriter, int aLineLength) {
        this.printWriter = new PrintWriter(aWriter);
        this.lineLength = aLineLength;
    }

    public PemWriter(Writer aWriter) {
        this(aWriter, 64);
    }

    public void writeData(String aLabel, byte[] someBytes) {
        this.writeHeader(aLabel);
        this.writeData(someBytes);
        this.writeFooter(aLabel);
        this.printWriter.flush();
    }

    private void writeHeader(String aLabel) {
        this.printWriter.println("-----BEGIN " + aLabel + "-----");
    }

    private void writeData(byte[] someBytes) {
        String tEncoded = Base64.getEncoder().encodeToString(someBytes);
        for (int i = 0; i < tEncoded.length(); i += this.lineLength) {
            this.printWriter.println(tEncoded.substring(i, Math.min(tEncoded.length(), i + this.lineLength)));
        }
    }

    private void writeFooter(String aLabel) {
        this.printWriter.println("-----END " + aLabel + "-----");
    }
}

