/*
 * Decompiled with CFR 0.152.
 */
package de.profhenry.sshsig.core;

import de.profhenry.sshsig.core.SignatureAlgorithm;
import de.profhenry.sshsig.core.SshSignatureException;
import de.profhenry.sshsig.core.spi.SigningBackend;
import de.profhenry.sshsig.core.util.HexUtil;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcaSingingBackend
implements SigningBackend<KeyPair> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcaSingingBackend.class);

    @Override
    public PublicKey extractPublicKey(KeyPair aKeyPair) {
        return aKeyPair.getPublic();
    }

    @Override
    public SigningBackend.SigningResult signData(KeyPair aKeyPair, byte[] someDataToSign) throws SshSignatureException {
        PrivateKey tPrivateKey = aKeyPair.getPrivate();
        PublicKey tPublicKey = aKeyPair.getPublic();
        LOGGER.debug("PrivateKey: {} {} ({})", new Object[]{tPrivateKey.getAlgorithm(), tPrivateKey.getFormat(), tPrivateKey.getClass().getName()});
        LOGGER.debug("PublicKey: {} {} ({})", new Object[]{tPublicKey.getAlgorithm(), tPublicKey.getFormat(), tPublicKey.getClass().getName()});
        if (!tPrivateKey.getAlgorithm().equals(tPublicKey.getAlgorithm())) {
            throw new SshSignatureException("Key mismatch detected: private=" + tPrivateKey.getAlgorithm() + " public=" + tPublicKey.getAlgorithm());
        }
        if ("DSA".equals(tPrivateKey.getAlgorithm())) {
            return this.signDsa(tPrivateKey, someDataToSign);
        }
        if ("RSA".equals(tPrivateKey.getAlgorithm())) {
            return this.signRsa(tPrivateKey, someDataToSign);
        }
        if ("Ed25519".equals(tPrivateKey.getAlgorithm())) {
            return this.signEd25519(tPrivateKey, someDataToSign);
        }
        if ("EdDSA".equals(tPrivateKey.getAlgorithm())) {
            return this.signEd25519(tPrivateKey, someDataToSign);
        }
        throw new SshSignatureException("Unsupported private key: " + tPrivateKey.getAlgorithm() + " (" + tPrivateKey.getClass().getName() + ")");
    }

    private byte[] sign(PrivateKey aPrivateKey, String anAlgorithm, byte[] someDataToSign) throws SshSignatureException {
        try {
            Signature tSignature = Signature.getInstance(anAlgorithm);
            tSignature.initSign(aPrivateKey);
            tSignature.update(someDataToSign);
            return tSignature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException exc) {
            throw new SshSignatureException("Signing failed!", exc);
        }
    }

    private SigningBackend.SigningResult signDsa(PrivateKey aPrivateKey, byte[] someDataToSign) throws SshSignatureException {
        byte[] tSignedData = this.sign(aPrivateKey, "SHA1WithDSA", someDataToSign);
        LOGGER.debug("ASN.1 encoded dsa signed data ({} bytes) {}", (Object)tSignedData.length, (Object)HexUtil.bytesToHex(tSignedData));
        byte tLengthR = tSignedData[3];
        int tOffsetR = 4;
        byte tLengthS = tSignedData[tOffsetR + tLengthR + 1];
        int tOffsetS = tOffsetR + tLengthR + 2;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("extracting r: offset={} length={}", (Object)tOffsetR, (Object)tLengthR);
            byte[] tR = new byte[tLengthR];
            System.arraycopy(tSignedData, tOffsetR, tR, 0, tLengthR);
            LOGGER.debug("r: {}", (Object)HexUtil.bytesToHex(tR));
            LOGGER.debug("extracting s: offset={} length={}", (Object)tOffsetS, (Object)tLengthS);
            byte[] tS = new byte[tLengthS];
            System.arraycopy(tSignedData, tOffsetS, tS, 0, tLengthS);
            LOGGER.debug("s: {}", (Object)HexUtil.bytesToHex(tS));
        }
        byte[] tRAndS = new byte[40];
        this.arrayCopyExact20Bytes(tSignedData, tOffsetR, tRAndS, 0, tLengthR);
        this.arrayCopyExact20Bytes(tSignedData, tOffsetS, tRAndS, 20, tLengthS);
        LOGGER.debug("r+s: {}", (Object)HexUtil.bytesToHex(tRAndS));
        LOGGER.debug("     <                  r                   ><                  s                   >");
        return new SigningBackend.SigningResult(SignatureAlgorithm.SSH_DSS, tRAndS);
    }

    private void arrayCopyExact20Bytes(byte[] aSrc, int aScrOffset, byte[] aDst, int aDstOffset, int aLength) {
        if (aLength <= 20) {
            System.arraycopy(aSrc, aScrOffset, aDst, aDstOffset + 20 - aLength, aLength);
        } else if (aLength == 21 && aSrc[aScrOffset] == 0) {
            System.arraycopy(aSrc, aScrOffset + 1, aDst, aDstOffset, 20);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private SigningBackend.SigningResult signRsa(PrivateKey aPrivateKey, byte[] someDataToSign) throws SshSignatureException {
        byte[] tSignedData = this.sign(aPrivateKey, "SHA512WithRSA", someDataToSign);
        return new SigningBackend.SigningResult(SignatureAlgorithm.RSA_SHA2_512, tSignedData);
    }

    private SigningBackend.SigningResult signEd25519(PrivateKey aPrivateKey, byte[] someDataToSign) throws SshSignatureException {
        byte[] tSignedData = "net.i2p.crypto.eddsa.EdDSAPrivateKey".equals(aPrivateKey.getClass().getName()) ? this.sign(aPrivateKey, "NONEwithEdDSA", someDataToSign) : this.sign(aPrivateKey, "ED25519", someDataToSign);
        return new SigningBackend.SigningResult(SignatureAlgorithm.SSH_ED25519, tSignedData);
    }
}

