/*
 * Decompiled with CFR 0.152.
 */
package de.profhenry.sshsig.core;

import de.profhenry.sshsig.core.SshSignatureException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public enum HashAlgorithm {
    SHA_256("SHA-256", "sha256"),
    SHA_512("SHA-512", "sha512");

    private final String messageDigestName;
    private final String nameUsedInSshProtocol;

    private HashAlgorithm(String aMessageDigestName, String aNameUsedInSshProtocol) {
        this.messageDigestName = aMessageDigestName;
        this.nameUsedInSshProtocol = aNameUsedInSshProtocol;
    }

    public MessageDigest createMessageDigestInstance() throws SshSignatureException {
        try {
            return MessageDigest.getInstance(this.messageDigestName);
        }
        catch (NoSuchAlgorithmException exc) {
            throw new SshSignatureException("Hash algorithm " + (Object)((Object)this) + " not available!", exc);
        }
    }

    public String getNameUsedInSshProtocol() {
        return this.nameUsedInSshProtocol;
    }
}

