/*
 * Decompiled with CFR 0.152.
 */
package de.ppi.deepsampler.junit5;

import de.ppi.deepsampler.core.api.Sampler;
import de.ppi.deepsampler.junit.JUnitPluginUtils;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class DeepSamplerExtension
implements TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback {
    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        JUnitPluginUtils.injectSamplers((Object)testInstance);
    }

    public void beforeEach(ExtensionContext context) {
        Sampler.clear();
        context.getTestMethod().ifPresent(testMethod -> {
            JUnitPluginUtils.applyTestFixture((Method)testMethod);
            JUnitPluginUtils.loadSamples((Method)testMethod);
        });
    }

    public void afterEach(ExtensionContext context) {
        context.getTestMethod().ifPresent(JUnitPluginUtils::saveSamples);
    }
}

