/*
 * Decompiled with CFR 0.152.
 */
package de.ppi.deepsampler.junit.json;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import de.ppi.deepsampler.core.error.InvalidConfigException;
import de.ppi.deepsampler.junit.JUnitSamplerUtils;
import de.ppi.deepsampler.junit.SampleRootPath;
import de.ppi.deepsampler.junit.SourceManagerFactory;
import de.ppi.deepsampler.junit.UseCharset;
import de.ppi.deepsampler.junit.UseSourceManagerForLoading;
import de.ppi.deepsampler.junit.UseSourceManagerForSaving;
import de.ppi.deepsampler.junit.json.LoadSamples;
import de.ppi.deepsampler.junit.json.SaveSamples;
import de.ppi.deepsampler.junit.json.UseJsonDeserializer;
import de.ppi.deepsampler.junit.json.UseJsonSerializer;
import de.ppi.deepsampler.persistence.json.JsonSourceManager;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;

public class JsonSourceManagerFactory
implements SourceManagerFactory<JsonSourceManager> {
    public static final String DEFAULT_ROOT_PATH = "./";

    public JsonSourceManager createSourceManagerToLoadSamples(Method testMethod) {
        JsonSourceManager.Builder persistentSampleManagerBuilder = JsonSourceManager.builder();
        LoadSamples loadSamples = testMethod.getDeclaredAnnotation(LoadSamples.class);
        if (loadSamples == null) {
            throw new InvalidConfigException("The %s is used without the annotation %s by the method %s. The method is supposedly annotated with an annotation that itself is annotated with %s, which falsely binds to %s", new Object[]{JsonSourceManagerFactory.class, LoadSamples.class, testMethod, UseSourceManagerForLoading.class, JsonSourceManagerFactory.class});
        }
        this.applyJsonSerializersFromTestCaseAndTestFixture(testMethod, persistentSampleManagerBuilder);
        this.applyCharsetFromTestCaseOrTestFixture(testMethod, persistentSampleManagerBuilder);
        Optional rootPath = JUnitSamplerUtils.loadAnnotationFromTestOrSamplerFixture((Method)testMethod, SampleRootPath.class);
        switch (loadSamples.source()) {
            case CLASSPATH: {
                String classPathResource = this.createPathForClasspath(loadSamples, testMethod);
                return persistentSampleManagerBuilder.buildWithClassPathResource(classPathResource, testMethod.getDeclaringClass());
            }
        }
        Path file = this.createPathForFilesystem(rootPath, loadSamples.value(), testMethod);
        return persistentSampleManagerBuilder.buildWithFile(file);
    }

    public JsonSourceManager createSourceManagerToSaveSamples(Method testMethod) {
        JsonSourceManager.Builder persistentSampleManagerBuilder = JsonSourceManager.builder();
        SaveSamples saveSamples = testMethod.getDeclaredAnnotation(SaveSamples.class);
        if (saveSamples == null) {
            throw new InvalidConfigException("The %s is used without the annotation %s by the method %s. The method is supposedly annotated with an annotation that itself is annotated with %s, which falsely binds to %s", new Object[]{JsonSourceManagerFactory.class, SaveSamples.class, testMethod, UseSourceManagerForSaving.class, JsonSourceManagerFactory.class});
        }
        this.applyJsonSerializersFromTestCaseAndTestFixture(testMethod, persistentSampleManagerBuilder);
        this.applyCharsetFromTestCaseOrTestFixture(testMethod, persistentSampleManagerBuilder);
        Optional sampleRootPath = JUnitSamplerUtils.loadAnnotationFromTestOrSamplerFixture((Method)testMethod, SampleRootPath.class);
        Path fileName = this.createPathForFilesystem(sampleRootPath, saveSamples.value(), testMethod);
        return persistentSampleManagerBuilder.buildWithFile(fileName);
    }

    private void applyJsonSerializersFromTestCaseAndTestFixture(Method testMethod, JsonSourceManager.Builder persistentSampleManagerBuilder) {
        JUnitSamplerUtils.loadSamplerFixtureFromMethodOrDeclaringClass((Method)testMethod).map(JUnitSamplerUtils::getDefineSamplersMethod).ifPresent(samplerFixtureMethod -> {
            this.applyAnnotatedJsonSerializers((Method)samplerFixtureMethod, persistentSampleManagerBuilder);
            this.applyAnnotatedJsonDeserializers((Method)samplerFixtureMethod, persistentSampleManagerBuilder);
        });
        this.applyAnnotatedJsonSerializers(testMethod, persistentSampleManagerBuilder);
        this.applyAnnotatedJsonDeserializers(testMethod, persistentSampleManagerBuilder);
    }

    private void applyCharsetFromTestCaseOrTestFixture(Method testMethod, JsonSourceManager.Builder persistentSampleManagerBuilder) {
        JUnitSamplerUtils.loadAnnotationFromTestOrSamplerFixture((Method)testMethod, UseCharset.class).map(UseCharset::value).map(Charset::forName).ifPresent(arg_0 -> ((JsonSourceManager.Builder)persistentSampleManagerBuilder).withCharset(arg_0));
    }

    Path createPathForFilesystem(Optional<SampleRootPath> sampleRootPath, String file, Method testMethod) {
        Path path = sampleRootPath.map(a -> Paths.get(a.value(), new String[0])).orElse(Paths.get(DEFAULT_ROOT_PATH, new String[0]));
        if (file.equals("`v\u00b0\u00b0v\u00b4$de.ppi.deepsampler.junit.AnnotationConstants$$$DefaultValueMustBeCalculated$")) {
            return path.resolve(testMethod.getDeclaringClass().getPackage().getName().replace(".", "/")).resolve(this.getDefaultJsonFileName(testMethod));
        }
        return path.resolve(file.replaceFirst("^[/\\\\]", ""));
    }

    String createPathForClasspath(LoadSamples loadSamples, Method testMethod) {
        if (loadSamples.value().equals("`v\u00b0\u00b0v\u00b4$de.ppi.deepsampler.junit.AnnotationConstants$$$DefaultValueMustBeCalculated$")) {
            return "/" + testMethod.getDeclaringClass().getPackage().getName().replace(".", "/") + "/" + this.getDefaultJsonFileName(testMethod);
        }
        return loadSamples.value();
    }

    public String getDefaultJsonFileName(Method testMethod) {
        return testMethod.getDeclaringClass().getSimpleName() + "_" + testMethod.getName() + ".json";
    }

    private void applyAnnotatedJsonSerializers(Method testMethod, JsonSourceManager.Builder persistentSampleManagerBuilder) {
        UseJsonSerializer[] serializersOnMethod = (UseJsonSerializer[])testMethod.getAnnotationsByType(UseJsonSerializer.class);
        UseJsonSerializer[] serializersOnClass = (UseJsonSerializer[])testMethod.getDeclaringClass().getAnnotationsByType(UseJsonSerializer.class);
        Stream.of(serializersOnClass, serializersOnMethod).flatMap(Stream::of).forEach(serializerAnnotation -> this.addSerializer((UseJsonSerializer)serializerAnnotation, persistentSampleManagerBuilder));
    }

    private void applyAnnotatedJsonDeserializers(Method testMethod, JsonSourceManager.Builder persistentSampleManagerBuilder) {
        UseJsonDeserializer[] deserializersOnMethod = (UseJsonDeserializer[])testMethod.getAnnotationsByType(UseJsonDeserializer.class);
        UseJsonDeserializer[] deserializersOnClass = (UseJsonDeserializer[])testMethod.getDeclaringClass().getAnnotationsByType(UseJsonDeserializer.class);
        Stream.of(deserializersOnClass, deserializersOnMethod).flatMap(Stream::of).forEach(deserializerAnnotation -> this.addDeserializer((UseJsonDeserializer)deserializerAnnotation, persistentSampleManagerBuilder));
    }

    private <T> void addSerializer(UseJsonSerializer useJsonSerializer, JsonSourceManager.Builder persistentSampleManagerBuilder) {
        Class<? extends JsonSerializer<?>> serializerClass = useJsonSerializer.serializer();
        Class<?> typeToSerialize = useJsonSerializer.forType();
        this.validateTypesOfSerializerAndSerializable(serializerClass, typeToSerialize);
        JsonSerializer jsonSerializer = (JsonSerializer)JUnitSamplerUtils.instantiate(serializerClass);
        persistentSampleManagerBuilder.addSerializer(typeToSerialize, jsonSerializer);
    }

    private <T> void addDeserializer(UseJsonDeserializer useJsonDeserializer, JsonSourceManager.Builder persistentSampleManagerBuilder) {
        Class<? extends JsonDeserializer<?>> deserializerClass = useJsonDeserializer.deserializer();
        Class<?> typeToDeserialize = useJsonDeserializer.forType();
        this.validateTypesOfDeserializerAndDeserializable(deserializerClass, typeToDeserialize);
        JsonDeserializer jsonDeserializer = (JsonDeserializer)JUnitSamplerUtils.instantiate(deserializerClass);
        persistentSampleManagerBuilder.addDeserializer(typeToDeserialize, jsonDeserializer);
    }

    private void validateTypesOfSerializerAndSerializable(Class<? extends JsonSerializer<?>> serializerClass, Class<?> typeToSerialize) {
        Type[] typeArguments = this.getParameterizedParentType(serializerClass).getActualTypeArguments();
        if (!typeArguments[0].equals(typeToSerialize)) {
            throw new InvalidConfigException("%s must have a parameter of type %s since the serializer is registered for the latter type. But it is %s", new Object[]{serializerClass.getName(), typeToSerialize.getName(), typeArguments[0].getTypeName()});
        }
    }

    private void validateTypesOfDeserializerAndDeserializable(Class<? extends JsonDeserializer<?>> deserializerClass, Class<?> typeToDeserialize) {
        Type[] typeArguments = this.getParameterizedParentType(deserializerClass).getActualTypeArguments();
        if (!typeArguments[0].equals(typeToDeserialize)) {
            throw new InvalidConfigException("%s must have a parameter of type %s since the deserializer is registered for the latter type. But it is %s", new Object[]{deserializerClass.getName(), typeToDeserialize.getName(), typeArguments[0].getTypeName()});
        }
    }

    private ParameterizedType getParameterizedParentType(Class<?> clazz) {
        if (clazz.getGenericSuperclass() instanceof ParameterizedType) {
            return (ParameterizedType)clazz.getGenericSuperclass();
        }
        return this.getParameterizedParentType((Class)clazz.getGenericSuperclass());
    }
}

