/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.utils;

import de.poiu.coat.annotation.Coat;
import de.poiu.coat.processor.CoatProcessorException;
import de.poiu.coat.processor.specs.EnclosedType;
import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class TypeHelper {
    private final ProcessingEnvironment pEnv;
    public final TypeMirror arrayTypeElement;
    public final TypeMirror listTypeElement;
    public final TypeMirror setTypeElement;
    public final TypeMirror optionalType;
    public final TypeMirror optionalIntType;
    public final TypeMirror optionalDoubleType;
    public final TypeMirror optionalLongType;
    public final TypeMirror intType;
    public final TypeMirror doubleType;
    public final TypeMirror longType;
    public final TypeMirror coatConfigType;
    public final TypeMirror coatParamType;
    public final TypeMirror coatEmbeddedType;
    public final EnumSet<TypeKind> supportedTypes = EnumSet.of(TypeKind.BOOLEAN, TypeKind.INT, TypeKind.LONG, TypeKind.DOUBLE);

    public TypeHelper(ProcessingEnvironment pEnv) {
        this.pEnv = pEnv;
        this.arrayTypeElement = this.pEnv.getElementUtils().getTypeElement(Array.class.getCanonicalName()).asType();
        this.listTypeElement = this.pEnv.getElementUtils().getTypeElement(List.class.getCanonicalName()).asType();
        this.setTypeElement = this.pEnv.getElementUtils().getTypeElement(Set.class.getCanonicalName()).asType();
        this.optionalType = this.pEnv.getElementUtils().getTypeElement(Optional.class.getCanonicalName()).asType();
        this.optionalIntType = this.pEnv.getElementUtils().getTypeElement(OptionalInt.class.getCanonicalName()).asType();
        this.optionalDoubleType = this.pEnv.getElementUtils().getTypeElement(OptionalDouble.class.getCanonicalName()).asType();
        this.optionalLongType = this.pEnv.getElementUtils().getTypeElement(OptionalLong.class.getCanonicalName()).asType();
        this.intType = this.pEnv.getTypeUtils().getPrimitiveType(TypeKind.INT);
        this.doubleType = this.pEnv.getTypeUtils().getPrimitiveType(TypeKind.DOUBLE);
        this.longType = this.pEnv.getTypeUtils().getPrimitiveType(TypeKind.LONG);
        this.coatConfigType = this.pEnv.getElementUtils().getTypeElement(Coat.Config.class.getCanonicalName()).asType();
        this.coatParamType = this.pEnv.getElementUtils().getTypeElement(Coat.Param.class.getCanonicalName()).asType();
        this.coatEmbeddedType = this.pEnv.getElementUtils().getTypeElement(Coat.Embedded.class.getCanonicalName()).asType();
    }

    public boolean isOptional(@Nullable TypeMirror type) {
        if (type == null) {
            return false;
        }
        TypeMirror erasure = this.pEnv.getTypeUtils().erasure(type);
        return this.pEnv.getTypeUtils().isAssignable(erasure, this.optionalType) || this.pEnv.getTypeUtils().isAssignable(erasure, this.optionalIntType) || this.pEnv.getTypeUtils().isAssignable(erasure, this.optionalLongType) || this.pEnv.getTypeUtils().isAssignable(erasure, this.optionalDoubleType);
    }

    public boolean isOptionalPrimitive(@Nullable TypeMirror type) {
        if (type == null) {
            return false;
        }
        return this.pEnv.getTypeUtils().isAssignable(type, this.optionalIntType) || this.pEnv.getTypeUtils().isAssignable(type, this.optionalLongType) || this.pEnv.getTypeUtils().isAssignable(type, this.optionalDoubleType);
    }

    public boolean isPrimitive(@Nullable TypeMirror type) {
        if (type == null) {
            return false;
        }
        return type.getKind() == TypeKind.INT || type.getKind() == TypeKind.LONG || type.getKind() == TypeKind.DOUBLE || type.getKind() == TypeKind.BOOLEAN;
    }

    public Optional<TypeMirror> getCollectionType(@Nullable TypeMirror type) {
        if (type == null) {
            return Optional.empty();
        }
        if (this.pEnv.getTypeUtils().isAssignable(type, this.optionalType)) {
            return Optional.empty();
        }
        if (this.pEnv.getTypeUtils().isAssignable(type, this.arrayTypeElement)) {
            return Optional.of(this.arrayTypeElement);
        }
        if (this.pEnv.getTypeUtils().isAssignable(type, this.listTypeElement)) {
            return Optional.of(this.listTypeElement);
        }
        if (this.pEnv.getTypeUtils().isAssignable(type, this.setTypeElement)) {
            return Optional.of(this.setTypeElement);
        }
        StringBuilder sb = new StringBuilder("Unsupported collection type: ").append(type.toString());
        sb.append("\nOnly the following collection types are supported at the moment:");
        sb.append("\n\t").append(this.arrayTypeElement.toString());
        sb.append("\n\t").append(this.listTypeElement.toString());
        sb.append("\n\t").append(this.setTypeElement.toString());
        throw new CoatProcessorException(sb.toString());
    }

    public EnclosedType toEnclosedType(TypeMirror type) {
        switch (type.getKind()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                return EnclosedType.of(this.arrayTypeElement, arrayType.getComponentType());
            }
            case DECLARED: {
                if (this.isOptionalPrimitive(type)) {
                    TypeMirror primitiveType = this.getNonOptionalPrimitiveType(type);
                    return EnclosedType.of(this.optionalType, primitiveType);
                }
                DeclaredType declaredType = (DeclaredType)type;
                TypeMirror erasure = this.pEnv.getTypeUtils().erasure(type);
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                TypeMirror enclosedType = this.assertZeroOrOne(typeArguments);
                if (enclosedType != null) {
                    return EnclosedType.of(erasure, enclosedType);
                }
                return EnclosedType.of(null, type);
            }
        }
        return EnclosedType.of(null, type);
    }

    @Nullable
    private TypeMirror assertZeroOrOne(List<? extends TypeMirror> typeArguments) {
        switch (typeArguments.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return typeArguments.get(0);
            }
        }
        throw new CoatProcessorException("Only single type arguments are supported");
    }

    private TypeMirror getNonOptionalPrimitiveType(TypeMirror optionalPrimitiveType) {
        if (this.pEnv.getTypeUtils().isAssignable(optionalPrimitiveType, this.optionalIntType)) {
            return this.intType;
        }
        if (this.pEnv.getTypeUtils().isAssignable(optionalPrimitiveType, this.optionalLongType)) {
            return this.longType;
        }
        if (this.pEnv.getTypeUtils().isAssignable(optionalPrimitiveType, this.optionalDoubleType)) {
            return this.doubleType;
        }
        return optionalPrimitiveType;
    }

    public boolean isSupportedPrimitive(TypeMirror type) {
        return this.supportedTypes.contains((Object)type.getKind());
    }
}

