/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.utils;

import de.poiu.coat.annotation.Coat;
import de.poiu.coat.casing.CasingStrategy;
import de.poiu.coat.processor.specs.AccessorSpec;
import de.poiu.coat.processor.specs.ClassSpec;
import de.poiu.coat.processor.specs.EmbeddedTypeSpec;
import de.poiu.coat.processor.specs.ImmutableAccessorSpec;
import de.poiu.coat.processor.utils.ElementHelper;
import de.poiu.coat.processor.utils.NameUtils;
import de.poiu.coat.processor.utils.TypeHelper;
import de.poiu.coat.processor.visitors.TypeNameVisitor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class SpecHelper {
    private final ProcessingEnvironment pEnv;
    private final ElementHelper elementHelper;
    private final TypeHelper typeHelper;

    public SpecHelper(ProcessingEnvironment pEnv) {
        this.pEnv = pEnv;
        this.elementHelper = new ElementHelper(pEnv);
        this.typeHelper = new TypeHelper(pEnv);
    }

    public static List<AccessorSpec> getAccessorSpecsRecursively(ClassSpec classSpec) {
        ArrayList<AccessorSpec> result = new ArrayList<AccessorSpec>();
        result.addAll(classSpec.accessors());
        for (EmbeddedTypeSpec eps : classSpec.embeddedTypes()) {
            ClassSpec embeddedClassSpec = eps.classSpec();
            List<AccessorSpec> embeddedAccessors = SpecHelper.getAccessorSpecsRecursively(embeddedClassSpec);
            embeddedAccessors.stream().map(ImmutableAccessorSpec::copyOf).map(s -> s.withKey(eps.key() + eps.keySeparator() + s.key())).forEachOrdered(result::add);
        }
        return result;
    }

    public String getOrInferKey(ExecutableElement annotatedMethod) {
        AnnotationMirror coatEmbeddedAnnotationMirror;
        AnnotationMirror coatParamAnnotationMirror = this.elementHelper.getAnnotation(this.typeHelper.coatParamType, annotatedMethod);
        String specifiedKey = this.getKeyFromAnnotation(coatParamAnnotationMirror, coatEmbeddedAnnotationMirror = this.elementHelper.getAnnotation(this.typeHelper.coatEmbeddedType, annotatedMethod));
        if (specifiedKey != null && !specifiedKey.isEmpty()) {
            return specifiedKey;
        }
        return SpecHelper.inferKey(annotatedMethod);
    }

    public Optional<String> getCollectionTypeName(AccessorSpec accessorSpec) {
        if (accessorSpec.collectionType().isEmpty()) {
            return Optional.empty();
        }
        TypeMirror collectionType = accessorSpec.collectionType().get();
        if (collectionType.getKind() == TypeKind.DECLARED) {
            return Optional.of(this.pEnv.getTypeUtils().erasure(collectionType).toString());
        }
        return Optional.of(collectionType.toString());
    }

    public String getSuperGetterName(AccessorSpec accessorSpec) {
        boolean hasDefaultValue;
        StringBuilder sb = new StringBuilder("get");
        TypeMirror type = accessorSpec.type();
        TypeNameVisitor visitor = new TypeNameVisitor();
        String typeName = type.accept(visitor, null);
        Optional<TypeMirror> collectionType = accessorSpec.collectionType();
        if (collectionType.isPresent()) {
            if (collectionType.get().toString().equals(Array.class.getCanonicalName())) {
                sb.append("Array");
            } else if (this.pEnv.getTypeUtils().isAssignable(collectionType.get(), this.typeHelper.listTypeElement)) {
                sb.append("List");
            } else if (this.pEnv.getTypeUtils().isAssignable(collectionType.get(), this.typeHelper.setTypeElement)) {
                sb.append("Set");
            }
        } else if (!accessorSpec.mandatory()) {
            sb.append("Optional");
        }
        if (this.typeHelper.isPrimitive(type)) {
            String simpleTypeName = typeName.substring(typeName.lastIndexOf(".") + 1);
            sb.append(NameUtils.upperFirstChar(simpleTypeName));
        }
        boolean bl = hasDefaultValue = !accessorSpec.defaultValue().isBlank();
        if (hasDefaultValue) {
            sb.append("OrDefault");
        }
        return sb.toString();
    }

    private static String inferKey(ExecutableElement annotatedMethod) {
        Element enclosingElement = annotatedMethod.getEnclosingElement();
        if (enclosingElement == null) {
            throw new RuntimeException("No enclosing element for annotatedMethod \u201d" + annotatedMethod.toString() + "\u201d");
        }
        if (!(enclosingElement instanceof TypeElement)) {
            throw new RuntimeException("Enclosing element of annotatedMethod \u201c" + annotatedMethod.toString() + "\u201d of unexpected type: " + String.valueOf(enclosingElement));
        }
        TypeElement type = (TypeElement)enclosingElement;
        Coat.Config coatConfigAnnotation = type.getAnnotation(Coat.Config.class);
        if (coatConfigAnnotation == null) {
            throw new RuntimeException("Enclosing element of annotatedMethod \u201c" + annotatedMethod.toString() + "\u201d does not have a @Coat.Config annotation: " + String.valueOf(enclosingElement));
        }
        boolean stripGetPrefix = coatConfigAnnotation.stripGetPrefix();
        CasingStrategy casingStrategy = coatConfigAnnotation.casing();
        String accessorName = annotatedMethod.getSimpleName().toString();
        if (stripGetPrefix) {
            accessorName = SpecHelper.stripGetPrefix(accessorName);
        }
        return casingStrategy.convert(accessorName);
    }

    private static String stripGetPrefix(String accessorName) {
        Pattern PATTERN_ACCESSOR_NAME = Pattern.compile("^(get)(\\p{Lu})(.*)");
        Matcher matcher = PATTERN_ACCESSOR_NAME.matcher(accessorName);
        if (matcher.matches()) {
            return matcher.group(2).toLowerCase() + matcher.group(3);
        }
        return accessorName;
    }

    @Nullable
    private String getKeyFromAnnotation(AnnotationMirror coatParamAnnotation, AnnotationMirror coatEmbeddedAnnotation) {
        if (coatParamAnnotation == null && coatEmbeddedAnnotation == null) {
            return null;
        }
        if (coatParamAnnotation != null) {
            return this.elementHelper.getAnnotationValueAsString("key", coatParamAnnotation, ElementHelper.Defaults.LOAD_DEFAULT);
        }
        if (coatEmbeddedAnnotation != null) {
            return this.elementHelper.getAnnotationValueAsString("key", coatEmbeddedAnnotation, ElementHelper.Defaults.LOAD_DEFAULT);
        }
        return null;
    }
}

