/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.utils;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class JavadocHelper {
    public static final String JAVADOC_ON_FROM_FILE = "Create a new $T from the given config file.\n\n@param file the config file to read\n@return the $T created with the entries from the given file\n@throws IOException if reading the given file failed";
    public static final String JAVADOC_ON_FROM_MAP = "Create a new $T from the given config entries.\n\n@param props the config entries\n@return the $T created with the given entries";
    public static final String JAVADOC_ON_FROM_PROPERTIES = "Create a new $T from the given config entries.\n\n@param jup the config entries\n@return the $T created with the given entries";
    public static final String JAVADOC_ON_FROM_ENV_VARS = "Create a new $T from the current environment variables.\n<p>\nSince the allowed characters for environment variables are much more restricted than Coat config keys,\na relaxed mapping is applied.\n<p>Dots and hyphens are treated as underscores. Also uppercase\ncharacters in config keys are preceded by an underscore (to convert camelCase to UPPER_CASE).\nComparison between the environment variables and the config keys is done case insensitively.<p>\nFor example the environment variable\n<code>SERVER_MQTT_HOST</code> will match the config key <code>server.mqttHost</code>.\n\n@return the $T created with the entries in the current environment variables";
    public static final String JAVADOC_ON_ADD_FILE = "Add the config entries in the given config file to this $T.\nAlready existing entries will be overwritten.\n\n@param file the config file to read\n@return this $T\n@throws IOException if reading the given file failed";
    public static final String JAVADOC_ON_ADD_MAP = "Add the given config entries to this $T.\nAlready existing entries will be overwritten.\n\n@param props the config entries\n@return this $T";
    public static final String JAVADOC_ON_ADD_PROPERTIES = "Add the given config entries to this $T.\nAlready existing entries will be overwritten.\n\n@param jup the config entries\n@return this $T";
    public static final String JAVADOC_ON_ADD_ENV_VARS = "Add the config entries from the current environment variables to this $T.\nAlready existing entries will be overwritten.\n<p>\nSince the allowed characters for environment variables are much more restricted than Coat config keys,\na relaxed mapping is applied. For example the environment variable\n<code>SERVER_MQTT_HOST</code> will match the config key <code>server.mqttHost</code>.\n\n@return this $T";
    public static final String JAVADOC_ON_WRITE_EXAMPLE_CONFIG = "Write an example config file to the given Writer.\n\n@param writer the Writer to write to\n@throws IOException if writing the example config file fails";
    private static final Pattern PATTERN_JAVADOC_BLOCK_TAG = Pattern.compile("^\\s*@.*");

    public static String stripBlockTagsFromJavadoc(@Nullable String javadoc) {
        if (javadoc == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        javadoc.lines().takeWhile(Predicate.not(PATTERN_JAVADOC_BLOCK_TAG.asMatchPredicate())).map(s -> s + "\n").forEachOrdered(sb::append);
        return sb.toString();
    }
}

