/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.utils;

import de.poiu.coat.processor.utils.TypeHelper;
import de.poiu.coat.processor.visitors.ClassTypeArrayVisitor;
import de.poiu.coat.processor.visitors.ClassTypeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class ElementHelper {
    private final ProcessingEnvironment pEnv;
    private final TypeHelper typeHelper;

    public ElementHelper(ProcessingEnvironment pEnv) {
        this.pEnv = pEnv;
        this.typeHelper = new TypeHelper(pEnv);
    }

    @Nullable
    public AnnotationValue getAnnotationValueOf(String key, @Nullable AnnotationMirror annotation, Defaults defaults) {
        if (annotation == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> annotationParams = defaults == Defaults.LOAD_DEFAULT ? this.pEnv.getElementUtils().getElementValuesWithDefaults(annotation) : annotation.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationParams.entrySet()) {
            ExecutableElement k = entry.getKey();
            AnnotationValue v = entry.getValue();
            if (!k.getSimpleName().contentEquals(key)) continue;
            return v;
        }
        return null;
    }

    public List<TypeMirror> getAnnotationValueAsTypeMirrorList(String key, @Nullable AnnotationMirror annotation, Defaults defaults) {
        AnnotationValue annotationValue = this.getAnnotationValueOf(key, annotation, defaults);
        if (annotationValue == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TypeMirror> converters = new ArrayList<TypeMirror>();
        ClassTypeArrayVisitor visitor = new ClassTypeArrayVisitor((List<TypeMirror>)converters);
        annotationValue.accept(visitor, null);
        return converters;
    }

    @Nullable
    public TypeMirror getAnnotationValueAsTypeMirror(String key, @Nullable AnnotationMirror annotation, Defaults defaults) {
        AnnotationValue annotationValue = this.getAnnotationValueOf(key, annotation, defaults);
        if (annotationValue == null) {
            return null;
        }
        ClassTypeVisitor visitor = new ClassTypeVisitor();
        return annotationValue.accept(visitor, null);
    }

    public String getAnnotationValueAsString(String key, @Nullable AnnotationMirror annotation, Defaults defaults) {
        AnnotationValue annotationValue = this.getAnnotationValueOf(key, annotation, defaults);
        if (annotationValue == null) {
            return "";
        }
        return (String)annotationValue.getValue();
    }

    @Nullable
    public AnnotationValue getDefaultValue(String key, @Nullable AnnotationMirror annotation) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> annotationParams = annotation.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationParams.entrySet()) {
            ExecutableElement k = entry.getKey();
            if (!k.getSimpleName().contentEquals(key)) continue;
            return k.getDefaultValue();
        }
        return null;
    }

    @Nullable
    public AnnotationMirror getAnnotation(TypeMirror annotationType, Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            if (!this.pEnv.getTypeUtils().isAssignable(declaredType, annotationType)) continue;
            return annotationMirror;
        }
        return null;
    }

    @Nullable
    private ExecutableElement getAnnotationParam(String key, @Nullable AnnotationMirror annotation) {
        if (annotation == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> annotationParams = annotation.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationParams.entrySet()) {
            ExecutableElement k = entry.getKey();
            AnnotationValue v = entry.getValue();
            if (!k.getSimpleName().contentEquals(key)) continue;
            return k;
        }
        return null;
    }

    public static enum Defaults {
        LOAD_DEFAULT,
        IGNORE_DEFAULT;

    }
}

