/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.utils;

import de.poiu.coat.annotation.Coat;
import de.poiu.coat.processor.specs.AccessorSpec;
import de.poiu.coat.processor.specs.EmbeddedTypeSpec;
import de.poiu.coat.processor.utils.ElementHelper;
import de.poiu.coat.processor.utils.TypeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class Assertions {
    private final ProcessingEnvironment pEnv;
    private final ElementHelper elementHelper;
    private final TypeHelper typeHelper;

    public Assertions(ProcessingEnvironment pEnv) {
        this.pEnv = pEnv;
        this.elementHelper = new ElementHelper(pEnv);
        this.typeHelper = new TypeHelper(pEnv);
    }

    public void assertReturnType(List<AccessorSpec> accessors) {
        accessors.stream().map(AccessorSpec::accessor).filter(this::hasVoidReturnType).forEachOrdered(accessor -> this.pEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Accessors must have a return type", (Element)accessor));
    }

    public void assertIsInterface(TypeElement annotatedType) {
        if (annotatedType.getKind() != ElementKind.INTERFACE) {
            this.pEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@Coat.Config is only supported on interfaces at the moment", annotatedType);
        }
    }

    public void assertEmbeddedTypesAreAnnotated(List<EmbeddedTypeSpec> embeddedTypeSpecs) {
        embeddedTypeSpecs.stream().forEachOrdered(this::assertEmbeddedTypeIsAnnotated);
    }

    public void assertEmbeddedTypeIsAnnotated(EmbeddedTypeSpec embeddedTypeSpec) {
        if (this.hasEmbeddedAnnotation(embeddedTypeSpec) && this.hasEmbeddedTypeWithoutAnnotation(embeddedTypeSpec)) {
            this.pEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@Coat.Embedded annotation can only be applied to types that are annotated with @Coat.Config.", embeddedTypeSpec.accessor());
        }
    }

    public void assertEmbeddedTypesAreNotInCollection(List<EmbeddedTypeSpec> embeddedTypeSpecs) {
        embeddedTypeSpecs.stream().forEachOrdered(this::assertEmbeddedTypeIsNotInCollection);
    }

    public void assertEmbeddedTypeIsNotInCollection(EmbeddedTypeSpec embeddedTypeSpec) {
        if (this.hasEmbeddedAnnotation(embeddedTypeSpec) && this.hasCollectionType(embeddedTypeSpec)) {
            this.pEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Collection types are not supported for EmbeddedConfigs", embeddedTypeSpec.accessor());
        }
    }

    public void assertNoParameters(List<AccessorSpec> aceessors) {
        aceessors.stream().map(AccessorSpec::accessor).filter(this::hasParameters).forEachOrdered(accessor -> this.pEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Accessors must not have parameters", (Element)accessor));
    }

    public void assertUniqueKeys(List<AccessorSpec> accessors) {
        HashMap existingKeys = new HashMap();
        HashSet duplicateKeys = new HashSet();
        for (AccessorSpec accessor2 : accessors) {
            if (!existingKeys.containsKey(accessor2.key())) {
                existingKeys.put(accessor2.key(), new ArrayList());
            }
            ((List)existingKeys.get(accessor2.key())).add(accessor2);
        }
        existingKeys.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).forEach(e -> duplicateKeys.addAll((Collection)e.getValue()));
        duplicateKeys.stream().map(AccessorSpec::accessor).forEach(accessor -> this.pEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate key", (Element)accessor));
    }

    public void assertUniqueMethodNames(List<AccessorSpec> accessors) {
        HashMap existingMethodNames = new HashMap();
        HashSet duplicateMethodNames = new HashSet();
        for (AccessorSpec accessor2 : accessors) {
            if (!existingMethodNames.containsKey(accessor2.methodName())) {
                existingMethodNames.put(accessor2.methodName(), new ArrayList());
            }
            ((List)existingMethodNames.get(accessor2.methodName())).add(accessor2);
        }
        existingMethodNames.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).forEach(e -> duplicateMethodNames.addAll((Collection)e.getValue()));
        duplicateMethodNames.stream().map(AccessorSpec::accessor).forEach(accessor -> this.pEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Conflicting accessor methods", (Element)accessor));
    }

    public void assertOnlyEitherEmbeddedOrParamAnnotation(List<EmbeddedTypeSpec> accessors) {
        accessors.stream().filter(this::hasParamAnnotation).forEachOrdered(accessorSpec -> this.pEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@Param or @Embedded annotations are mutually exclusive", accessorSpec.accessor()));
    }

    public void assertNoPrimitiveArrays(List<AccessorSpec> accessors) {
        accessors.stream().filter(this::hasPrimitiveArray).forEachOrdered(accessorSpec -> this.pEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Arrays of primitives are not supported. Use Lists instead.", accessorSpec.accessor()));
    }

    public void assertOnlySupportedPrimitives(List<AccessorSpec> accessors) {
        accessors.stream().filter(this::isUnsupportedPrimitive).forEachOrdered(accessorSpec -> this.pEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Only the primitive types boolean, int, long and double are supported. Please use one of those or the corresponding object types.", accessorSpec.accessor()));
    }

    private boolean hasVoidReturnType(ExecutableElement elm) {
        return elm.getReturnType().getKind() == TypeKind.VOID;
    }

    private boolean hasParameters(ExecutableElement elm) {
        return !elm.getParameters().isEmpty();
    }

    private boolean hasEmbeddedAnnotation(EmbeddedTypeSpec embeddedSpec) {
        Coat.Embedded[] embeddedAnnotations = (Coat.Embedded[])embeddedSpec.accessor().getAnnotationsByType(Coat.Embedded.class);
        return embeddedAnnotations.length > 0;
    }

    private boolean hasParamAnnotation(EmbeddedTypeSpec embeddedSpec) {
        Coat.Param[] embeddedAnnotations = (Coat.Param[])embeddedSpec.accessor().getAnnotationsByType(Coat.Param.class);
        return embeddedAnnotations.length > 0;
    }

    private boolean hasEmbeddedTypeWithoutAnnotation(EmbeddedTypeSpec embeddedSpec) {
        Coat.Config[] coatConfigAnnotations = (Coat.Config[])embeddedSpec.classSpec().annotatedType().getAnnotationsByType(Coat.Config.class);
        return coatConfigAnnotations.length == 0;
    }

    private boolean hasCollectionType(EmbeddedTypeSpec embeddedTypeSpec) {
        if (embeddedTypeSpec.enclosure().isEmpty()) {
            return false;
        }
        return !this.pEnv.getTypeUtils().isAssignable(embeddedTypeSpec.enclosure().get(), this.typeHelper.optionalType);
    }

    private boolean hasPrimitiveArray(AccessorSpec accessorSpec) {
        if (accessorSpec.collectionType().isEmpty()) {
            return false;
        }
        TypeMirror collectionType = accessorSpec.collectionType().get();
        boolean isArray = this.pEnv.getTypeUtils().isAssignable(collectionType, this.typeHelper.arrayTypeElement);
        boolean isPrimitive = accessorSpec.type().getKind().isPrimitive();
        return isArray && isPrimitive;
    }

    private boolean isUnsupportedPrimitive(AccessorSpec accessorSpec) {
        TypeKind returnTypeKind = accessorSpec.type().getKind();
        if (!returnTypeKind.isPrimitive()) {
            return false;
        }
        return !this.typeHelper.supportedTypes.contains((Object)returnTypeKind);
    }
}

