/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.specs;

import de.poiu.coat.annotation.Coat;
import de.poiu.coat.processor.specs.AccessorSpec;
import de.poiu.coat.processor.specs.ClassSpec;
import de.poiu.coat.processor.specs.EmbeddedTypeSpec;
import de.poiu.coat.processor.specs.EnclosedType;
import de.poiu.coat.processor.specs.ImmutableAccessorSpec;
import de.poiu.coat.processor.specs.ImmutableClassSpec;
import de.poiu.coat.processor.specs.ImmutableEmbeddedTypeSpec;
import de.poiu.coat.processor.specs.SimplifiedAccessorSpec;
import de.poiu.coat.processor.utils.ElementHelper;
import de.poiu.coat.processor.utils.NameUtils;
import de.poiu.coat.processor.utils.SpecHelper;
import de.poiu.coat.processor.utils.TypeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class SpecHandler {
    private final Map<Name, ClassSpec> GENERATED_CLASS_SPECS = new HashMap<Name, ClassSpec>();
    private final ProcessingEnvironment pEnv;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final TypeHelper typeHelper;
    private final ElementHelper elementHelper;
    private final SpecHelper specHelper;

    public SpecHandler(ProcessingEnvironment pEnv) {
        this.pEnv = pEnv;
        this.typeUtils = pEnv.getTypeUtils();
        this.elementUtils = pEnv.getElementUtils();
        this.typeHelper = new TypeHelper(pEnv);
        this.elementHelper = new ElementHelper(pEnv);
        this.specHelper = new SpecHelper(pEnv);
    }

    public ClassSpec classSpecFrom(TypeElement annotatedType) {
        if (!this.GENERATED_CLASS_SPECS.containsKey(annotatedType.getQualifiedName())) {
            AnnotationMirror coatConfigAnnotation = this.elementHelper.getAnnotation(this.typeHelper.coatConfigType, annotatedType);
            List<AccessorSpec> accessorSpecs = this.createAccessorSpecsRecursively(annotatedType);
            List<EmbeddedTypeSpec> embeddedSpecs = this.createEmbeddedTypeSpecs(annotatedType);
            String targetPackage = this.pEnv.getElementUtils().getPackageOf(annotatedType).getQualifiedName().toString();
            String enumName = NameUtils.deriveGeneratedEnumName(annotatedType);
            String className = NameUtils.deriveGeneratedClassName(annotatedType);
            List<TypeMirror> converter = this.elementHelper.getAnnotationValueAsTypeMirrorList("converters", coatConfigAnnotation, ElementHelper.Defaults.IGNORE_DEFAULT);
            Optional<TypeMirror> listParser = Optional.ofNullable(this.elementHelper.getAnnotationValueAsTypeMirror("listParser", coatConfigAnnotation, ElementHelper.Defaults.IGNORE_DEFAULT));
            ImmutableClassSpec generatedClassSpec = ImmutableClassSpec.builder().annotatedType(annotatedType).accessors(accessorSpecs).embeddedTypes(embeddedSpecs).targetPackage(targetPackage).enumName(enumName).className(className).converters(converter).listParser(listParser).build();
            this.GENERATED_CLASS_SPECS.put(annotatedType.getQualifiedName(), generatedClassSpec);
        }
        return this.GENERATED_CLASS_SPECS.get(annotatedType.getQualifiedName());
    }

    public AccessorSpec accessorSpecFrom(ExecutableElement accessor) {
        AnnotationMirror coatParamAnnotation = this.elementHelper.getAnnotation(this.typeHelper.coatParamType, accessor);
        EnclosedType returnType = this.typeHelper.toEnclosedType(accessor.getReturnType());
        String key = this.specHelper.getOrInferKey(accessor);
        String defaultValue = this.elementHelper.getAnnotationValueAsString("defaultValue", coatParamAnnotation, ElementHelper.Defaults.LOAD_DEFAULT);
        boolean mandatory = !this.typeHelper.isOptional(accessor.getReturnType());
        Optional<TypeMirror> converter = Optional.ofNullable(this.elementHelper.getAnnotationValueAsTypeMirror("converter", coatParamAnnotation, ElementHelper.Defaults.IGNORE_DEFAULT));
        Optional<TypeMirror> listParser = Optional.ofNullable(this.elementHelper.getAnnotationValueAsTypeMirror("listParser", coatParamAnnotation, ElementHelper.Defaults.IGNORE_DEFAULT));
        String methodName = accessor.getSimpleName().toString();
        TypeMirror type = returnType.type();
        Optional<TypeMirror> collectionType = this.typeHelper.getCollectionType(returnType.enclosure().orElse(null));
        return ImmutableAccessorSpec.builder().accessor(accessor).key(key).defaultValue(defaultValue).mandatory(mandatory).converter(converter).listParser(listParser).methodName(methodName).type(type).collectionType(collectionType).build();
    }

    public EmbeddedTypeSpec embeddedTypeSpecFrom(ExecutableElement accessor) {
        AnnotationMirror coatEmbeddedAnnotation = this.elementHelper.getAnnotation(this.typeHelper.coatEmbeddedType, accessor);
        EnclosedType returnType = this.typeHelper.toEnclosedType(accessor.getReturnType());
        EnclosedType fullEmbeddedType = this.typeHelper.toEnclosedType(accessor.getReturnType());
        TypeElement fullEmbeddedTypeElement = (TypeElement)this.typeUtils.asElement(fullEmbeddedType.type());
        ClassSpec embeddedClassSpec = this.classSpecFrom(fullEmbeddedTypeElement);
        String key = this.specHelper.getOrInferKey(accessor);
        String keySeparator = this.elementHelper.getAnnotationValueAsString("keySeparator", coatEmbeddedAnnotation, ElementHelper.Defaults.LOAD_DEFAULT);
        boolean mandatory = !this.typeHelper.isOptional(accessor.getReturnType());
        String methodName = accessor.getSimpleName().toString();
        TypeMirror type = returnType.type();
        return ImmutableEmbeddedTypeSpec.builder().accessor(accessor).classSpec(embeddedClassSpec).enclosure(fullEmbeddedType.enclosure()).key(key).keySeparator(keySeparator).mandatory(mandatory).type(type).build();
    }

    private List<AccessorSpec> createAccessorSpecs(TypeElement annotatedType) {
        return annotatedType.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).filter(e -> e.getAnnotation(Coat.Embedded.class) == null).map(ExecutableElement.class::cast).map(this::accessorSpecFrom).collect(Collectors.toList());
    }

    private List<AccessorSpec> createAccessorSpecsRecursively(TypeElement annotatedType) {
        ArrayList<AccessorSpec> accessors = new ArrayList<AccessorSpec>();
        List directAccessors = annotatedType.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).filter(e -> e.getAnnotation(Coat.Embedded.class) == null).map(ExecutableElement.class::cast).map(this::accessorSpecFrom).collect(Collectors.toList());
        accessors.addAll(directAccessors);
        List inheritedAccessors = annotatedType.getInterfaces().stream().map(this.typeUtils::asElement).map(TypeElement.class::cast).map(this::createAccessorSpecsRecursively).flatMap(Collection::stream).collect(Collectors.toList());
        accessors.addAll(inheritedAccessors);
        this.removeDuplicteAccessors(accessors);
        return accessors;
    }

    private List<EmbeddedTypeSpec> createEmbeddedTypeSpecs(TypeElement annotatedType) {
        return annotatedType.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).filter(e -> e.getAnnotation(Coat.Embedded.class) != null).map(ExecutableElement.class::cast).map(this::embeddedTypeSpecFrom).collect(Collectors.toList());
    }

    private void removeDuplicteAccessors(Collection<AccessorSpec> accessors) {
        HashSet<SimplifiedAccessorSpec> uniqueAccessors = new HashSet<SimplifiedAccessorSpec>();
        Iterator<AccessorSpec> it = accessors.iterator();
        while (it.hasNext()) {
            AccessorSpec accessor = it.next();
            SimplifiedAccessorSpec simplifiedAccessor = SimplifiedAccessorSpec.from(accessor);
            if (uniqueAccessors.contains(simplifiedAccessor)) {
                it.remove();
                continue;
            }
            uniqueAccessors.add(simplifiedAccessor);
        }
    }

    private ClassSpec unsupported(TypeElement typeElement) {
        return ImmutableClassSpec.builder().annotatedType(typeElement).accessors(Collections.EMPTY_LIST).embeddedTypes(Collections.EMPTY_LIST).targetPackage("unsupportedpackage").enumName("UnsupportedEnum" + typeElement.getSimpleName().toString()).className("UnsupportedClass" + typeElement.getSimpleName().toString()).build();
    }
}

