/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.specs;

import de.poiu.coat.processor.specs.AccessorSpec;
import de.poiu.coat.processor.specs.SimplifiedAccessorSpec;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SimplifiedAccessorSpec", generator="Immutables")
@Immutable
public final class ImmutableSimplifiedAccessorSpec
extends SimplifiedAccessorSpec {
    private final AccessorSpec accessor;
    private final String methodName;
    private final String key;
    private final String defaultValue;
    private final TypeMirror type;
    private final boolean mandatory;

    private ImmutableSimplifiedAccessorSpec(AccessorSpec accessor, String methodName, String key, String defaultValue, TypeMirror type, boolean mandatory) {
        this.accessor = accessor;
        this.methodName = methodName;
        this.key = key;
        this.defaultValue = defaultValue;
        this.type = type;
        this.mandatory = mandatory;
    }

    @Override
    public AccessorSpec accessor() {
        return this.accessor;
    }

    @Override
    public String methodName() {
        return this.methodName;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String defaultValue() {
        return this.defaultValue;
    }

    @Override
    public TypeMirror type() {
        return this.type;
    }

    @Override
    public boolean mandatory() {
        return this.mandatory;
    }

    public final ImmutableSimplifiedAccessorSpec withAccessor(AccessorSpec value) {
        if (this.accessor == value) {
            return this;
        }
        AccessorSpec newValue = Objects.requireNonNull(value, "accessor");
        return new ImmutableSimplifiedAccessorSpec(newValue, this.methodName, this.key, this.defaultValue, this.type, this.mandatory);
    }

    public final ImmutableSimplifiedAccessorSpec withMethodName(String value) {
        String newValue = Objects.requireNonNull(value, "methodName");
        if (this.methodName.equals(newValue)) {
            return this;
        }
        return new ImmutableSimplifiedAccessorSpec(this.accessor, newValue, this.key, this.defaultValue, this.type, this.mandatory);
    }

    public final ImmutableSimplifiedAccessorSpec withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableSimplifiedAccessorSpec(this.accessor, this.methodName, newValue, this.defaultValue, this.type, this.mandatory);
    }

    public final ImmutableSimplifiedAccessorSpec withDefaultValue(String value) {
        String newValue = Objects.requireNonNull(value, "defaultValue");
        if (this.defaultValue.equals(newValue)) {
            return this;
        }
        return new ImmutableSimplifiedAccessorSpec(this.accessor, this.methodName, this.key, newValue, this.type, this.mandatory);
    }

    public final ImmutableSimplifiedAccessorSpec withType(TypeMirror value) {
        if (this.type == value) {
            return this;
        }
        TypeMirror newValue = Objects.requireNonNull(value, "type");
        return new ImmutableSimplifiedAccessorSpec(this.accessor, this.methodName, this.key, this.defaultValue, newValue, this.mandatory);
    }

    public final ImmutableSimplifiedAccessorSpec withMandatory(boolean value) {
        if (this.mandatory == value) {
            return this;
        }
        return new ImmutableSimplifiedAccessorSpec(this.accessor, this.methodName, this.key, this.defaultValue, this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSimplifiedAccessorSpec && this.equalTo(0, (ImmutableSimplifiedAccessorSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableSimplifiedAccessorSpec another) {
        return this.methodName.equals(another.methodName) && this.key.equals(another.key) && this.defaultValue.equals(another.defaultValue) && this.type.equals(another.type) && this.mandatory == another.mandatory;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.methodName.hashCode();
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.defaultValue.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Boolean.hashCode(this.mandatory);
        return h;
    }

    public String toString() {
        return "SimplifiedAccessorSpec{methodName=" + this.methodName + ", key=" + this.key + ", defaultValue=" + this.defaultValue + ", type=" + String.valueOf(this.type) + ", mandatory=" + this.mandatory + "}";
    }

    public static ImmutableSimplifiedAccessorSpec copyOf(SimplifiedAccessorSpec instance) {
        if (instance instanceof ImmutableSimplifiedAccessorSpec) {
            return (ImmutableSimplifiedAccessorSpec)instance;
        }
        return ImmutableSimplifiedAccessorSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SimplifiedAccessorSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCESSOR = 1L;
        private static final long INIT_BIT_METHOD_NAME = 2L;
        private static final long INIT_BIT_KEY = 4L;
        private static final long INIT_BIT_DEFAULT_VALUE = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private static final long INIT_BIT_MANDATORY = 32L;
        private long initBits = 63L;
        @Nullable
        private AccessorSpec accessor;
        @Nullable
        private String methodName;
        @Nullable
        private String key;
        @Nullable
        private String defaultValue;
        @Nullable
        private TypeMirror type;
        private boolean mandatory;

        private Builder() {
        }

        public final Builder from(SimplifiedAccessorSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.accessor(instance.accessor());
            this.methodName(instance.methodName());
            this.key(instance.key());
            this.defaultValue(instance.defaultValue());
            this.type(instance.type());
            this.mandatory(instance.mandatory());
            return this;
        }

        public final Builder accessor(AccessorSpec accessor) {
            this.accessor = Objects.requireNonNull(accessor, "accessor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder methodName(String methodName) {
            this.methodName = Objects.requireNonNull(methodName, "methodName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder type(TypeMirror type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder mandatory(boolean mandatory) {
            this.mandatory = mandatory;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableSimplifiedAccessorSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSimplifiedAccessorSpec(this.accessor, this.methodName, this.key, this.defaultValue, this.type, this.mandatory);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accessor");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("methodName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("defaultValue");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("mandatory");
            }
            return "Cannot build SimplifiedAccessorSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

