/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.specs;

import de.poiu.coat.processor.specs.ClassSpec;
import de.poiu.coat.processor.specs.EmbeddedTypeSpec;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="EmbeddedTypeSpec", generator="Immutables")
@Immutable
public final class ImmutableEmbeddedTypeSpec
extends EmbeddedTypeSpec {
    private final ExecutableElement accessor;
    private final ClassSpec classSpec;
    @Nullable
    private final TypeMirror enclosure;
    private final String key;
    private final String keySeparator;
    private final boolean mandatory;
    private final TypeMirror type;

    private ImmutableEmbeddedTypeSpec(ExecutableElement accessor, ClassSpec classSpec, @Nullable TypeMirror enclosure, String key, String keySeparator, boolean mandatory, TypeMirror type) {
        this.accessor = accessor;
        this.classSpec = classSpec;
        this.enclosure = enclosure;
        this.key = key;
        this.keySeparator = keySeparator;
        this.mandatory = mandatory;
        this.type = type;
    }

    @Override
    public ExecutableElement accessor() {
        return this.accessor;
    }

    @Override
    public ClassSpec classSpec() {
        return this.classSpec;
    }

    @Override
    public Optional<TypeMirror> enclosure() {
        return Optional.ofNullable(this.enclosure);
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String keySeparator() {
        return this.keySeparator;
    }

    @Override
    public boolean mandatory() {
        return this.mandatory;
    }

    @Override
    public TypeMirror type() {
        return this.type;
    }

    public final ImmutableEmbeddedTypeSpec withAccessor(ExecutableElement value) {
        if (this.accessor == value) {
            return this;
        }
        ExecutableElement newValue = Objects.requireNonNull(value, "accessor");
        return new ImmutableEmbeddedTypeSpec(newValue, this.classSpec, this.enclosure, this.key, this.keySeparator, this.mandatory, this.type);
    }

    public final ImmutableEmbeddedTypeSpec withClassSpec(ClassSpec value) {
        if (this.classSpec == value) {
            return this;
        }
        ClassSpec newValue = Objects.requireNonNull(value, "classSpec");
        return new ImmutableEmbeddedTypeSpec(this.accessor, newValue, this.enclosure, this.key, this.keySeparator, this.mandatory, this.type);
    }

    public final ImmutableEmbeddedTypeSpec withEnclosure(TypeMirror value) {
        TypeMirror newValue = Objects.requireNonNull(value, "enclosure");
        if (this.enclosure == newValue) {
            return this;
        }
        return new ImmutableEmbeddedTypeSpec(this.accessor, this.classSpec, newValue, this.key, this.keySeparator, this.mandatory, this.type);
    }

    public final ImmutableEmbeddedTypeSpec withEnclosure(Optional<? extends TypeMirror> optional) {
        TypeMirror value = optional.orElse(null);
        if (this.enclosure == value) {
            return this;
        }
        return new ImmutableEmbeddedTypeSpec(this.accessor, this.classSpec, value, this.key, this.keySeparator, this.mandatory, this.type);
    }

    public final ImmutableEmbeddedTypeSpec withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableEmbeddedTypeSpec(this.accessor, this.classSpec, this.enclosure, newValue, this.keySeparator, this.mandatory, this.type);
    }

    public final ImmutableEmbeddedTypeSpec withKeySeparator(String value) {
        String newValue = Objects.requireNonNull(value, "keySeparator");
        if (this.keySeparator.equals(newValue)) {
            return this;
        }
        return new ImmutableEmbeddedTypeSpec(this.accessor, this.classSpec, this.enclosure, this.key, newValue, this.mandatory, this.type);
    }

    public final ImmutableEmbeddedTypeSpec withMandatory(boolean value) {
        if (this.mandatory == value) {
            return this;
        }
        return new ImmutableEmbeddedTypeSpec(this.accessor, this.classSpec, this.enclosure, this.key, this.keySeparator, value, this.type);
    }

    public final ImmutableEmbeddedTypeSpec withType(TypeMirror value) {
        if (this.type == value) {
            return this;
        }
        TypeMirror newValue = Objects.requireNonNull(value, "type");
        return new ImmutableEmbeddedTypeSpec(this.accessor, this.classSpec, this.enclosure, this.key, this.keySeparator, this.mandatory, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEmbeddedTypeSpec && this.equalTo(0, (ImmutableEmbeddedTypeSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableEmbeddedTypeSpec another) {
        return this.accessor.equals(another.accessor) && this.classSpec.equals(another.classSpec) && Objects.equals(this.enclosure, another.enclosure) && this.key.equals(another.key) && this.keySeparator.equals(another.keySeparator) && this.mandatory == another.mandatory && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.accessor.hashCode();
        h += (h << 5) + this.classSpec.hashCode();
        h += (h << 5) + Objects.hashCode(this.enclosure);
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.keySeparator.hashCode();
        h += (h << 5) + Boolean.hashCode(this.mandatory);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("EmbeddedTypeSpec{");
        builder.append("accessor=").append(this.accessor);
        builder.append(", ");
        builder.append("classSpec=").append(this.classSpec);
        if (this.enclosure != null) {
            builder.append(", ");
            builder.append("enclosure=").append(this.enclosure);
        }
        builder.append(", ");
        builder.append("key=").append(this.key);
        builder.append(", ");
        builder.append("keySeparator=").append(this.keySeparator);
        builder.append(", ");
        builder.append("mandatory=").append(this.mandatory);
        builder.append(", ");
        builder.append("type=").append(this.type);
        return builder.append("}").toString();
    }

    public static ImmutableEmbeddedTypeSpec copyOf(EmbeddedTypeSpec instance) {
        if (instance instanceof ImmutableEmbeddedTypeSpec) {
            return (ImmutableEmbeddedTypeSpec)instance;
        }
        return ImmutableEmbeddedTypeSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EmbeddedTypeSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCESSOR = 1L;
        private static final long INIT_BIT_CLASS_SPEC = 2L;
        private static final long INIT_BIT_KEY = 4L;
        private static final long INIT_BIT_KEY_SEPARATOR = 8L;
        private static final long INIT_BIT_MANDATORY = 16L;
        private static final long INIT_BIT_TYPE = 32L;
        private long initBits = 63L;
        @Nullable
        private ExecutableElement accessor;
        @Nullable
        private ClassSpec classSpec;
        @Nullable
        private TypeMirror enclosure;
        @Nullable
        private String key;
        @Nullable
        private String keySeparator;
        private boolean mandatory;
        @Nullable
        private TypeMirror type;

        private Builder() {
        }

        public final Builder from(EmbeddedTypeSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.accessor(instance.accessor());
            this.classSpec(instance.classSpec());
            Optional<TypeMirror> enclosureOptional = instance.enclosure();
            if (enclosureOptional.isPresent()) {
                this.enclosure(enclosureOptional);
            }
            this.key(instance.key());
            this.keySeparator(instance.keySeparator());
            this.mandatory(instance.mandatory());
            this.type(instance.type());
            return this;
        }

        public final Builder accessor(ExecutableElement accessor) {
            this.accessor = Objects.requireNonNull(accessor, "accessor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder classSpec(ClassSpec classSpec) {
            this.classSpec = Objects.requireNonNull(classSpec, "classSpec");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder enclosure(TypeMirror enclosure) {
            this.enclosure = Objects.requireNonNull(enclosure, "enclosure");
            return this;
        }

        public final Builder enclosure(Optional<? extends TypeMirror> enclosure) {
            this.enclosure = enclosure.orElse(null);
            return this;
        }

        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder keySeparator(String keySeparator) {
            this.keySeparator = Objects.requireNonNull(keySeparator, "keySeparator");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder mandatory(boolean mandatory) {
            this.mandatory = mandatory;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder type(TypeMirror type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableEmbeddedTypeSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEmbeddedTypeSpec(this.accessor, this.classSpec, this.enclosure, this.key, this.keySeparator, this.mandatory, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accessor");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("classSpec");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("keySeparator");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("mandatory");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build EmbeddedTypeSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

