/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.specs;

import de.poiu.coat.processor.specs.AccessorSpec;
import de.poiu.coat.processor.specs.ClassSpec;
import de.poiu.coat.processor.specs.EmbeddedTypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ClassSpec", generator="Immutables")
@Immutable
public final class ImmutableClassSpec
extends ClassSpec {
    private final TypeElement annotatedType;
    private final List<AccessorSpec> accessors;
    private final List<EmbeddedTypeSpec> embeddedTypes;
    private final String targetPackage;
    private final String enumName;
    private final String className;
    private final List<TypeMirror> converters;
    @Nullable
    private final TypeMirror listParser;

    private ImmutableClassSpec(TypeElement annotatedType, List<AccessorSpec> accessors, List<EmbeddedTypeSpec> embeddedTypes, String targetPackage, String enumName, String className, List<TypeMirror> converters, @Nullable TypeMirror listParser) {
        this.annotatedType = annotatedType;
        this.accessors = accessors;
        this.embeddedTypes = embeddedTypes;
        this.targetPackage = targetPackage;
        this.enumName = enumName;
        this.className = className;
        this.converters = converters;
        this.listParser = listParser;
    }

    @Override
    public TypeElement annotatedType() {
        return this.annotatedType;
    }

    @Override
    public List<AccessorSpec> accessors() {
        return this.accessors;
    }

    @Override
    public List<EmbeddedTypeSpec> embeddedTypes() {
        return this.embeddedTypes;
    }

    @Override
    public String targetPackage() {
        return this.targetPackage;
    }

    @Override
    public String enumName() {
        return this.enumName;
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public List<TypeMirror> converters() {
        return this.converters;
    }

    @Override
    public Optional<TypeMirror> listParser() {
        return Optional.ofNullable(this.listParser);
    }

    public final ImmutableClassSpec withAnnotatedType(TypeElement value) {
        if (this.annotatedType == value) {
            return this;
        }
        TypeElement newValue = Objects.requireNonNull(value, "annotatedType");
        return new ImmutableClassSpec(newValue, this.accessors, this.embeddedTypes, this.targetPackage, this.enumName, this.className, this.converters, this.listParser);
    }

    public final ImmutableClassSpec withAccessors(AccessorSpec ... elements) {
        List<AccessorSpec> newValue = ImmutableClassSpec.createUnmodifiableList(false, ImmutableClassSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableClassSpec(this.annotatedType, newValue, this.embeddedTypes, this.targetPackage, this.enumName, this.className, this.converters, this.listParser);
    }

    public final ImmutableClassSpec withAccessors(Iterable<? extends AccessorSpec> elements) {
        if (this.accessors == elements) {
            return this;
        }
        List<AccessorSpec> newValue = ImmutableClassSpec.createUnmodifiableList(false, ImmutableClassSpec.createSafeList(elements, true, false));
        return new ImmutableClassSpec(this.annotatedType, newValue, this.embeddedTypes, this.targetPackage, this.enumName, this.className, this.converters, this.listParser);
    }

    public final ImmutableClassSpec withEmbeddedTypes(EmbeddedTypeSpec ... elements) {
        List<EmbeddedTypeSpec> newValue = ImmutableClassSpec.createUnmodifiableList(false, ImmutableClassSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableClassSpec(this.annotatedType, this.accessors, newValue, this.targetPackage, this.enumName, this.className, this.converters, this.listParser);
    }

    public final ImmutableClassSpec withEmbeddedTypes(Iterable<? extends EmbeddedTypeSpec> elements) {
        if (this.embeddedTypes == elements) {
            return this;
        }
        List<EmbeddedTypeSpec> newValue = ImmutableClassSpec.createUnmodifiableList(false, ImmutableClassSpec.createSafeList(elements, true, false));
        return new ImmutableClassSpec(this.annotatedType, this.accessors, newValue, this.targetPackage, this.enumName, this.className, this.converters, this.listParser);
    }

    public final ImmutableClassSpec withTargetPackage(String value) {
        String newValue = Objects.requireNonNull(value, "targetPackage");
        if (this.targetPackage.equals(newValue)) {
            return this;
        }
        return new ImmutableClassSpec(this.annotatedType, this.accessors, this.embeddedTypes, newValue, this.enumName, this.className, this.converters, this.listParser);
    }

    public final ImmutableClassSpec withEnumName(String value) {
        String newValue = Objects.requireNonNull(value, "enumName");
        if (this.enumName.equals(newValue)) {
            return this;
        }
        return new ImmutableClassSpec(this.annotatedType, this.accessors, this.embeddedTypes, this.targetPackage, newValue, this.className, this.converters, this.listParser);
    }

    public final ImmutableClassSpec withClassName(String value) {
        String newValue = Objects.requireNonNull(value, "className");
        if (this.className.equals(newValue)) {
            return this;
        }
        return new ImmutableClassSpec(this.annotatedType, this.accessors, this.embeddedTypes, this.targetPackage, this.enumName, newValue, this.converters, this.listParser);
    }

    public final ImmutableClassSpec withConverters(TypeMirror ... elements) {
        List<TypeMirror> newValue = ImmutableClassSpec.createUnmodifiableList(false, ImmutableClassSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableClassSpec(this.annotatedType, this.accessors, this.embeddedTypes, this.targetPackage, this.enumName, this.className, newValue, this.listParser);
    }

    public final ImmutableClassSpec withConverters(Iterable<? extends TypeMirror> elements) {
        if (this.converters == elements) {
            return this;
        }
        List<TypeMirror> newValue = ImmutableClassSpec.createUnmodifiableList(false, ImmutableClassSpec.createSafeList(elements, true, false));
        return new ImmutableClassSpec(this.annotatedType, this.accessors, this.embeddedTypes, this.targetPackage, this.enumName, this.className, newValue, this.listParser);
    }

    public final ImmutableClassSpec withListParser(TypeMirror value) {
        TypeMirror newValue = Objects.requireNonNull(value, "listParser");
        if (this.listParser == newValue) {
            return this;
        }
        return new ImmutableClassSpec(this.annotatedType, this.accessors, this.embeddedTypes, this.targetPackage, this.enumName, this.className, this.converters, newValue);
    }

    public final ImmutableClassSpec withListParser(Optional<? extends TypeMirror> optional) {
        TypeMirror value = optional.orElse(null);
        if (this.listParser == value) {
            return this;
        }
        return new ImmutableClassSpec(this.annotatedType, this.accessors, this.embeddedTypes, this.targetPackage, this.enumName, this.className, this.converters, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClassSpec && this.equalTo(0, (ImmutableClassSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableClassSpec another) {
        return this.annotatedType.equals(another.annotatedType) && this.accessors.equals(another.accessors) && this.embeddedTypes.equals(another.embeddedTypes) && this.targetPackage.equals(another.targetPackage) && this.enumName.equals(another.enumName) && this.className.equals(another.className) && this.converters.equals(another.converters) && Objects.equals(this.listParser, another.listParser);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.annotatedType.hashCode();
        h += (h << 5) + this.accessors.hashCode();
        h += (h << 5) + this.embeddedTypes.hashCode();
        h += (h << 5) + this.targetPackage.hashCode();
        h += (h << 5) + this.enumName.hashCode();
        h += (h << 5) + this.className.hashCode();
        h += (h << 5) + this.converters.hashCode();
        h += (h << 5) + Objects.hashCode(this.listParser);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ClassSpec{");
        builder.append("annotatedType=").append(this.annotatedType);
        builder.append(", ");
        builder.append("accessors=").append(this.accessors);
        builder.append(", ");
        builder.append("embeddedTypes=").append(this.embeddedTypes);
        builder.append(", ");
        builder.append("targetPackage=").append(this.targetPackage);
        builder.append(", ");
        builder.append("enumName=").append(this.enumName);
        builder.append(", ");
        builder.append("className=").append(this.className);
        builder.append(", ");
        builder.append("converters=").append(this.converters);
        if (this.listParser != null) {
            builder.append(", ");
            builder.append("listParser=").append(this.listParser);
        }
        return builder.append("}").toString();
    }

    public static ImmutableClassSpec copyOf(ClassSpec instance) {
        if (instance instanceof ImmutableClassSpec) {
            return (ImmutableClassSpec)instance;
        }
        return ImmutableClassSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ClassSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ANNOTATED_TYPE = 1L;
        private static final long INIT_BIT_TARGET_PACKAGE = 2L;
        private static final long INIT_BIT_ENUM_NAME = 4L;
        private static final long INIT_BIT_CLASS_NAME = 8L;
        private long initBits = 15L;
        @Nullable
        private TypeElement annotatedType;
        private List<AccessorSpec> accessors = new ArrayList<AccessorSpec>();
        private List<EmbeddedTypeSpec> embeddedTypes = new ArrayList<EmbeddedTypeSpec>();
        @Nullable
        private String targetPackage;
        @Nullable
        private String enumName;
        @Nullable
        private String className;
        private List<TypeMirror> converters = new ArrayList<TypeMirror>();
        @Nullable
        private TypeMirror listParser;

        private Builder() {
        }

        public final Builder from(ClassSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.annotatedType(instance.annotatedType());
            this.addAllAccessors(instance.accessors());
            this.addAllEmbeddedTypes(instance.embeddedTypes());
            this.targetPackage(instance.targetPackage());
            this.enumName(instance.enumName());
            this.className(instance.className());
            this.addAllConverters(instance.converters());
            Optional<TypeMirror> listParserOptional = instance.listParser();
            if (listParserOptional.isPresent()) {
                this.listParser(listParserOptional);
            }
            return this;
        }

        public final Builder annotatedType(TypeElement annotatedType) {
            this.annotatedType = Objects.requireNonNull(annotatedType, "annotatedType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addAccessors(AccessorSpec element) {
            this.accessors.add(Objects.requireNonNull(element, "accessors element"));
            return this;
        }

        public final Builder addAccessors(AccessorSpec ... elements) {
            for (AccessorSpec element : elements) {
                this.accessors.add(Objects.requireNonNull(element, "accessors element"));
            }
            return this;
        }

        public final Builder accessors(Iterable<? extends AccessorSpec> elements) {
            this.accessors.clear();
            return this.addAllAccessors(elements);
        }

        public final Builder addAllAccessors(Iterable<? extends AccessorSpec> elements) {
            for (AccessorSpec accessorSpec : elements) {
                this.accessors.add(Objects.requireNonNull(accessorSpec, "accessors element"));
            }
            return this;
        }

        public final Builder addEmbeddedTypes(EmbeddedTypeSpec element) {
            this.embeddedTypes.add(Objects.requireNonNull(element, "embeddedTypes element"));
            return this;
        }

        public final Builder addEmbeddedTypes(EmbeddedTypeSpec ... elements) {
            for (EmbeddedTypeSpec element : elements) {
                this.embeddedTypes.add(Objects.requireNonNull(element, "embeddedTypes element"));
            }
            return this;
        }

        public final Builder embeddedTypes(Iterable<? extends EmbeddedTypeSpec> elements) {
            this.embeddedTypes.clear();
            return this.addAllEmbeddedTypes(elements);
        }

        public final Builder addAllEmbeddedTypes(Iterable<? extends EmbeddedTypeSpec> elements) {
            for (EmbeddedTypeSpec embeddedTypeSpec : elements) {
                this.embeddedTypes.add(Objects.requireNonNull(embeddedTypeSpec, "embeddedTypes element"));
            }
            return this;
        }

        public final Builder targetPackage(String targetPackage) {
            this.targetPackage = Objects.requireNonNull(targetPackage, "targetPackage");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder enumName(String enumName) {
            this.enumName = Objects.requireNonNull(enumName, "enumName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder className(String className) {
            this.className = Objects.requireNonNull(className, "className");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder addConverters(TypeMirror element) {
            this.converters.add(Objects.requireNonNull(element, "converters element"));
            return this;
        }

        public final Builder addConverters(TypeMirror ... elements) {
            for (TypeMirror element : elements) {
                this.converters.add(Objects.requireNonNull(element, "converters element"));
            }
            return this;
        }

        public final Builder converters(Iterable<? extends TypeMirror> elements) {
            this.converters.clear();
            return this.addAllConverters(elements);
        }

        public final Builder addAllConverters(Iterable<? extends TypeMirror> elements) {
            for (TypeMirror typeMirror : elements) {
                this.converters.add(Objects.requireNonNull(typeMirror, "converters element"));
            }
            return this;
        }

        public final Builder listParser(TypeMirror listParser) {
            this.listParser = Objects.requireNonNull(listParser, "listParser");
            return this;
        }

        public final Builder listParser(Optional<? extends TypeMirror> listParser) {
            this.listParser = listParser.orElse(null);
            return this;
        }

        public ImmutableClassSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableClassSpec(this.annotatedType, ImmutableClassSpec.createUnmodifiableList(true, this.accessors), ImmutableClassSpec.createUnmodifiableList(true, this.embeddedTypes), this.targetPackage, this.enumName, this.className, ImmutableClassSpec.createUnmodifiableList(true, this.converters), this.listParser);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("annotatedType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetPackage");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("enumName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("className");
            }
            return "Cannot build ClassSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

