/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.specs;

import de.poiu.coat.processor.specs.AccessorSpec;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AccessorSpec", generator="Immutables")
@Immutable
public final class ImmutableAccessorSpec
extends AccessorSpec {
    private final ExecutableElement accessor;
    private final String key;
    private final String defaultValue;
    private final boolean mandatory;
    @Nullable
    private final TypeMirror converter;
    @Nullable
    private final TypeMirror listParser;
    private final String methodName;
    private final TypeMirror type;
    @Nullable
    private final TypeMirror collectionType;

    private ImmutableAccessorSpec(ExecutableElement accessor, String key, String defaultValue, boolean mandatory, @Nullable TypeMirror converter, @Nullable TypeMirror listParser, String methodName, TypeMirror type, @Nullable TypeMirror collectionType) {
        this.accessor = accessor;
        this.key = key;
        this.defaultValue = defaultValue;
        this.mandatory = mandatory;
        this.converter = converter;
        this.listParser = listParser;
        this.methodName = methodName;
        this.type = type;
        this.collectionType = collectionType;
    }

    @Override
    public ExecutableElement accessor() {
        return this.accessor;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String defaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean mandatory() {
        return this.mandatory;
    }

    @Override
    public Optional<TypeMirror> converter() {
        return Optional.ofNullable(this.converter);
    }

    @Override
    public Optional<TypeMirror> listParser() {
        return Optional.ofNullable(this.listParser);
    }

    @Override
    public String methodName() {
        return this.methodName;
    }

    @Override
    public TypeMirror type() {
        return this.type;
    }

    @Override
    public Optional<TypeMirror> collectionType() {
        return Optional.ofNullable(this.collectionType);
    }

    public final ImmutableAccessorSpec withAccessor(ExecutableElement value) {
        if (this.accessor == value) {
            return this;
        }
        ExecutableElement newValue = Objects.requireNonNull(value, "accessor");
        return new ImmutableAccessorSpec(newValue, this.key, this.defaultValue, this.mandatory, this.converter, this.listParser, this.methodName, this.type, this.collectionType);
    }

    public final ImmutableAccessorSpec withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableAccessorSpec(this.accessor, newValue, this.defaultValue, this.mandatory, this.converter, this.listParser, this.methodName, this.type, this.collectionType);
    }

    public final ImmutableAccessorSpec withDefaultValue(String value) {
        String newValue = Objects.requireNonNull(value, "defaultValue");
        if (this.defaultValue.equals(newValue)) {
            return this;
        }
        return new ImmutableAccessorSpec(this.accessor, this.key, newValue, this.mandatory, this.converter, this.listParser, this.methodName, this.type, this.collectionType);
    }

    public final ImmutableAccessorSpec withMandatory(boolean value) {
        if (this.mandatory == value) {
            return this;
        }
        return new ImmutableAccessorSpec(this.accessor, this.key, this.defaultValue, value, this.converter, this.listParser, this.methodName, this.type, this.collectionType);
    }

    public final ImmutableAccessorSpec withConverter(TypeMirror value) {
        TypeMirror newValue = Objects.requireNonNull(value, "converter");
        if (this.converter == newValue) {
            return this;
        }
        return new ImmutableAccessorSpec(this.accessor, this.key, this.defaultValue, this.mandatory, newValue, this.listParser, this.methodName, this.type, this.collectionType);
    }

    public final ImmutableAccessorSpec withConverter(Optional<? extends TypeMirror> optional) {
        TypeMirror value = optional.orElse(null);
        if (this.converter == value) {
            return this;
        }
        return new ImmutableAccessorSpec(this.accessor, this.key, this.defaultValue, this.mandatory, value, this.listParser, this.methodName, this.type, this.collectionType);
    }

    public final ImmutableAccessorSpec withListParser(TypeMirror value) {
        TypeMirror newValue = Objects.requireNonNull(value, "listParser");
        if (this.listParser == newValue) {
            return this;
        }
        return new ImmutableAccessorSpec(this.accessor, this.key, this.defaultValue, this.mandatory, this.converter, newValue, this.methodName, this.type, this.collectionType);
    }

    public final ImmutableAccessorSpec withListParser(Optional<? extends TypeMirror> optional) {
        TypeMirror value = optional.orElse(null);
        if (this.listParser == value) {
            return this;
        }
        return new ImmutableAccessorSpec(this.accessor, this.key, this.defaultValue, this.mandatory, this.converter, value, this.methodName, this.type, this.collectionType);
    }

    public final ImmutableAccessorSpec withMethodName(String value) {
        String newValue = Objects.requireNonNull(value, "methodName");
        if (this.methodName.equals(newValue)) {
            return this;
        }
        return new ImmutableAccessorSpec(this.accessor, this.key, this.defaultValue, this.mandatory, this.converter, this.listParser, newValue, this.type, this.collectionType);
    }

    public final ImmutableAccessorSpec withType(TypeMirror value) {
        if (this.type == value) {
            return this;
        }
        TypeMirror newValue = Objects.requireNonNull(value, "type");
        return new ImmutableAccessorSpec(this.accessor, this.key, this.defaultValue, this.mandatory, this.converter, this.listParser, this.methodName, newValue, this.collectionType);
    }

    public final ImmutableAccessorSpec withCollectionType(TypeMirror value) {
        TypeMirror newValue = Objects.requireNonNull(value, "collectionType");
        if (this.collectionType == newValue) {
            return this;
        }
        return new ImmutableAccessorSpec(this.accessor, this.key, this.defaultValue, this.mandatory, this.converter, this.listParser, this.methodName, this.type, newValue);
    }

    public final ImmutableAccessorSpec withCollectionType(Optional<? extends TypeMirror> optional) {
        TypeMirror value = optional.orElse(null);
        if (this.collectionType == value) {
            return this;
        }
        return new ImmutableAccessorSpec(this.accessor, this.key, this.defaultValue, this.mandatory, this.converter, this.listParser, this.methodName, this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccessorSpec && this.equalTo(0, (ImmutableAccessorSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccessorSpec another) {
        return this.accessor.equals(another.accessor) && this.key.equals(another.key) && this.defaultValue.equals(another.defaultValue) && this.mandatory == another.mandatory && Objects.equals(this.converter, another.converter) && Objects.equals(this.listParser, another.listParser) && this.methodName.equals(another.methodName) && this.type.equals(another.type) && Objects.equals(this.collectionType, another.collectionType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.accessor.hashCode();
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.defaultValue.hashCode();
        h += (h << 5) + Boolean.hashCode(this.mandatory);
        h += (h << 5) + Objects.hashCode(this.converter);
        h += (h << 5) + Objects.hashCode(this.listParser);
        h += (h << 5) + this.methodName.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.collectionType);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AccessorSpec{");
        builder.append("accessor=").append(this.accessor);
        builder.append(", ");
        builder.append("key=").append(this.key);
        builder.append(", ");
        builder.append("defaultValue=").append(this.defaultValue);
        builder.append(", ");
        builder.append("mandatory=").append(this.mandatory);
        if (this.converter != null) {
            builder.append(", ");
            builder.append("converter=").append(this.converter);
        }
        if (this.listParser != null) {
            builder.append(", ");
            builder.append("listParser=").append(this.listParser);
        }
        builder.append(", ");
        builder.append("methodName=").append(this.methodName);
        builder.append(", ");
        builder.append("type=").append(this.type);
        if (this.collectionType != null) {
            builder.append(", ");
            builder.append("collectionType=").append(this.collectionType);
        }
        return builder.append("}").toString();
    }

    public static ImmutableAccessorSpec copyOf(AccessorSpec instance) {
        if (instance instanceof ImmutableAccessorSpec) {
            return (ImmutableAccessorSpec)instance;
        }
        return ImmutableAccessorSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccessorSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCESSOR = 1L;
        private static final long INIT_BIT_KEY = 2L;
        private static final long INIT_BIT_DEFAULT_VALUE = 4L;
        private static final long INIT_BIT_MANDATORY = 8L;
        private static final long INIT_BIT_METHOD_NAME = 16L;
        private static final long INIT_BIT_TYPE = 32L;
        private long initBits = 63L;
        @Nullable
        private ExecutableElement accessor;
        @Nullable
        private String key;
        @Nullable
        private String defaultValue;
        private boolean mandatory;
        @Nullable
        private TypeMirror converter;
        @Nullable
        private TypeMirror listParser;
        @Nullable
        private String methodName;
        @Nullable
        private TypeMirror type;
        @Nullable
        private TypeMirror collectionType;

        private Builder() {
        }

        public final Builder from(AccessorSpec instance) {
            Optional<TypeMirror> listParserOptional;
            Objects.requireNonNull(instance, "instance");
            this.accessor(instance.accessor());
            this.key(instance.key());
            this.defaultValue(instance.defaultValue());
            this.mandatory(instance.mandatory());
            Optional<TypeMirror> converterOptional = instance.converter();
            if (converterOptional.isPresent()) {
                this.converter(converterOptional);
            }
            if ((listParserOptional = instance.listParser()).isPresent()) {
                this.listParser(listParserOptional);
            }
            this.methodName(instance.methodName());
            this.type(instance.type());
            Optional<TypeMirror> collectionTypeOptional = instance.collectionType();
            if (collectionTypeOptional.isPresent()) {
                this.collectionType(collectionTypeOptional);
            }
            return this;
        }

        public final Builder accessor(ExecutableElement accessor) {
            this.accessor = Objects.requireNonNull(accessor, "accessor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder mandatory(boolean mandatory) {
            this.mandatory = mandatory;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder converter(TypeMirror converter) {
            this.converter = Objects.requireNonNull(converter, "converter");
            return this;
        }

        public final Builder converter(Optional<? extends TypeMirror> converter) {
            this.converter = converter.orElse(null);
            return this;
        }

        public final Builder listParser(TypeMirror listParser) {
            this.listParser = Objects.requireNonNull(listParser, "listParser");
            return this;
        }

        public final Builder listParser(Optional<? extends TypeMirror> listParser) {
            this.listParser = listParser.orElse(null);
            return this;
        }

        public final Builder methodName(String methodName) {
            this.methodName = Objects.requireNonNull(methodName, "methodName");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder type(TypeMirror type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder collectionType(TypeMirror collectionType) {
            this.collectionType = Objects.requireNonNull(collectionType, "collectionType");
            return this;
        }

        public final Builder collectionType(Optional<? extends TypeMirror> collectionType) {
            this.collectionType = collectionType.orElse(null);
            return this;
        }

        public ImmutableAccessorSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccessorSpec(this.accessor, this.key, this.defaultValue, this.mandatory, this.converter, this.listParser, this.methodName, this.type, this.collectionType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accessor");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("defaultValue");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("mandatory");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("methodName");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build AccessorSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

