/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.specs;

import de.poiu.coat.processor.specs.ClassSpec;
import de.poiu.coat.processor.specs.EmbeddedTypeSpec;
import java.util.Comparator;

public class ClassSpecComparator
implements Comparator<ClassSpec> {
    public static final ClassSpecComparator INSTANCE = new ClassSpecComparator();

    @Override
    public int compare(ClassSpec o1, ClassSpec o2) {
        int embDepth2;
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int emb1 = o1.embeddedTypes().size();
        int emb2 = o2.embeddedTypes().size();
        if (emb1 == 0 && emb2 == 0) {
            return 0;
        }
        if (emb1 == 0) {
            return -1;
        }
        if (emb2 == 0) {
            return 1;
        }
        int embDepth1 = ClassSpecComparator.calcEmbeddedDepth(o1);
        if (embDepth1 != (embDepth2 = ClassSpecComparator.calcEmbeddedDepth(o2))) {
            return embDepth1 - embDepth2;
        }
        return o1.className().compareTo(o2.className());
    }

    protected static int calcEmbeddedDepth(ClassSpec cs) {
        int deepestSubDepth = 1;
        for (EmbeddedTypeSpec embeddedType : cs.embeddedTypes()) {
            deepestSubDepth = Math.max(deepestSubDepth, ClassSpecComparator.calcEmbeddedDepth(embeddedType.classSpec()) + 1);
        }
        return deepestSubDepth;
    }
}

