/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.examplecontent;

import de.poiu.coat.processor.specs.AccessorSpec;
import de.poiu.coat.processor.specs.ClassSpec;
import de.poiu.coat.processor.utils.JavadocHelper;
import de.poiu.coat.processor.utils.SpecHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class ExampleContentHelper {
    private final ProcessingEnvironment pEnv;

    public ExampleContentHelper(ProcessingEnvironment pEnv) {
        this.pEnv = pEnv;
    }

    public String createExampleContent(ClassSpec classSpec) {
        List<AccessorSpec> accessorSpecs = SpecHelper.getAccessorSpecsRecursively(classSpec);
        return this.createExampleContent(accessorSpecs);
    }

    public void generateExampleFile(ClassSpec classSpec, Filer filer) throws IOException {
        String exampleFileName = classSpec.annotatedType().getSimpleName().toString() + ".properties";
        List<AccessorSpec> accessorSpecs = SpecHelper.getAccessorSpecsRecursively(classSpec);
        FileObject resource = filer.createResource(StandardLocation.CLASS_OUTPUT, "examples", exampleFileName, classSpec.annotatedType());
        try (Writer w = resource.openWriter();){
            w.write(this.createExampleContent(accessorSpecs));
        }
    }

    private String createExampleContent(List<? extends AccessorSpec> accessorSpecs) {
        StringBuilder sb = new StringBuilder();
        for (AccessorSpec accessorSpec : accessorSpecs) {
            String javadoc = this.pEnv.getElementUtils().getDocComment(accessorSpec.accessor());
            JavadocHelper.stripBlockTagsFromJavadoc(javadoc).lines().map(s -> "## " + s + "\n").forEachOrdered(sb::append);
            if (!accessorSpec.mandatory() || accessorSpec.defaultValue() != null && !accessorSpec.defaultValue().trim().isEmpty()) {
                sb.append("# ");
            }
            sb.append(accessorSpec.key()).append(" = ");
            sb.append(accessorSpec.defaultValue() != null ? accessorSpec.defaultValue() : "");
            sb.append("\n\n");
        }
        return sb.toString();
    }
}

