/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.codegeneration;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import de.poiu.coat.CoatConfig;
import de.poiu.coat.ConfigParam;
import de.poiu.coat.processor.CoatProcessorException;
import de.poiu.coat.processor.codegeneration.CoatBuilderGenerator;
import de.poiu.coat.processor.examplecontent.ExampleContentHelper;
import de.poiu.coat.processor.specs.AccessorSpec;
import de.poiu.coat.processor.specs.ClassSpec;
import de.poiu.coat.processor.specs.EmbeddedTypeSpec;
import de.poiu.coat.processor.utils.ElementHelper;
import de.poiu.coat.processor.utils.JavadocHelper;
import de.poiu.coat.processor.utils.NameUtils;
import de.poiu.coat.processor.utils.SpecHelper;
import de.poiu.coat.processor.utils.TypeHelper;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class CodeGenerator {
    private final ProcessingEnvironment pEnv;
    private final SpecHelper specHelper;
    private final TypeHelper typeHelper;
    private final ElementHelper elementHelper;
    private final ExampleContentHelper exampleContentHelper;

    public CodeGenerator(ProcessingEnvironment pEnv) {
        this.pEnv = pEnv;
        this.specHelper = new SpecHelper(pEnv);
        this.typeHelper = new TypeHelper(pEnv);
        this.elementHelper = new ElementHelper(pEnv);
        this.exampleContentHelper = new ExampleContentHelper(pEnv);
    }

    public void generateEnumCode(ClassSpec classSpec) throws IOException {
        this.pEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("Generating enum %s for %s.", classSpec.fqEnumName(), classSpec.annotatedType()));
        ClassName enumName = ClassName.get((String)classSpec.targetPackage(), (String)classSpec.enumName(), (String[])new String[0]);
        TypeSpec.Builder typeSpecBuilder = TypeSpec.enumBuilder((ClassName)enumName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get(ConfigParam.class)).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(String.class, "key", new Modifier[]{Modifier.FINAL}).addParameter(Class.class, "type", new Modifier[]{Modifier.FINAL}).addParameter(Class.class, "collectionType", new Modifier[]{Modifier.FINAL}).addParameter(String.class, "defaultValue", new Modifier[]{Modifier.FINAL}).addParameter(TypeName.BOOLEAN, "mandatory", new Modifier[]{Modifier.FINAL}).addParameter(Class.class, "converter", new Modifier[]{Modifier.FINAL}).addParameter(Class.class, "listParser", new Modifier[]{Modifier.FINAL}).addStatement("this.$N = $N", new Object[]{"key", "key"}).addStatement("this.$N = $N", new Object[]{"type", "type"}).addStatement("this.$N = $N", new Object[]{"collectionType", "collectionType"}).addStatement("this.$N = $N", new Object[]{"defaultValue", "defaultValue"}).addStatement("this.$N = $N", new Object[]{"mandatory", "mandatory"}).addStatement("this.$N = $N", new Object[]{"converter", "converter"}).addStatement("this.$N = $N", new Object[]{"listParser", "listParser"}).build());
        this.addGeneratedAnnotation(typeSpecBuilder);
        this.addFieldAndAccessor(typeSpecBuilder, String.class, "key");
        this.addFieldAndAccessor(typeSpecBuilder, Class.class, "type");
        this.addFieldAndAccessor(typeSpecBuilder, Class.class, "collectionType");
        this.addFieldAndAccessor(typeSpecBuilder, String.class, "defaultValue");
        this.addFieldAndAccessor(typeSpecBuilder, TypeName.BOOLEAN, "mandatory");
        this.addFieldAndAccessor(typeSpecBuilder, Class.class, "converter");
        this.addFieldAndAccessor(typeSpecBuilder, Class.class, "listParser");
        if (classSpec.accessors().isEmpty()) {
            return;
        }
        for (AccessorSpec accessorSpec : classSpec.accessors()) {
            this.addEnumConstant(typeSpecBuilder, accessorSpec);
        }
        JavaFile.builder((String)enumName.packageName(), (TypeSpec)typeSpecBuilder.build()).build().writeTo(this.pEnv.getFiler());
    }

    public void generateClassCode(ClassSpec classSpec) throws IOException {
        this.pEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("Generating config class %s for %s.", classSpec.fqEnumName(), classSpec.annotatedType()));
        ClassName fqEnumName = ClassName.get((String)classSpec.targetPackage(), (String)classSpec.enumName(), (String[])new String[0]);
        ClassName fqClassName = ClassName.get((String)classSpec.targetPackage(), (String)classSpec.className(), (String[])new String[0]);
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((ClassName)fqClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ClassName.get(CoatConfig.class)).addSuperinterface((TypeName)ClassName.get((TypeElement)classSpec.annotatedType()));
        this.addGeneratedAnnotation(typeSpecBuilder);
        this.addPrivateStaticFinalLogger(typeSpecBuilder, fqClassName);
        this.addStaticFactoryMethods(typeSpecBuilder, fqClassName);
        this.addAccessorMethods(typeSpecBuilder, classSpec, fqEnumName);
        this.addEmbeddedAccessorMethods(typeSpecBuilder, classSpec, fqEnumName);
        this.addPrivateConstructor(typeSpecBuilder, classSpec, fqEnumName);
        List<ExecutableElement> allAnnotatedMethods = this.getAllAnnotatedMethodsAsElements(classSpec);
        this.addEqualsMethod(typeSpecBuilder, allAnnotatedMethods, fqClassName);
        this.addHashCodeMethod(typeSpecBuilder, allAnnotatedMethods);
        this.addWriteExampleConfigMethod(typeSpecBuilder, classSpec);
        this.addBuilder(typeSpecBuilder, classSpec, fqClassName);
        JavaFile.builder((String)fqClassName.packageName(), (TypeSpec)typeSpecBuilder.build()).build().writeTo(this.pEnv.getFiler());
    }

    private void addAccessorMethods(TypeSpec.Builder typeSpecBuilder, ClassSpec classSpec, ClassName fqEnumName) {
        for (AccessorSpec accessorSpec : classSpec.accessors()) {
            this.addAccessorMethod(typeSpecBuilder, accessorSpec, fqEnumName);
        }
    }

    private void addEmbeddedAccessorMethods(TypeSpec.Builder typeSpecBuilder, ClassSpec classSpec, ClassName fqEnumName) {
        for (EmbeddedTypeSpec embeddedAccessorSpec : classSpec.embeddedTypes()) {
            this.addEmbeddedAccessorMethod(typeSpecBuilder, embeddedAccessorSpec, fqEnumName);
        }
    }

    private void addPrivateConstructor(TypeSpec.Builder typeSpecBuilder, ClassSpec classSpec, ClassName fqEnumName) {
        MethodSpec.Builder mainConstructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), "props", new Modifier[]{Modifier.FINAL});
        if (classSpec.accessors().isEmpty()) {
            mainConstructorBuilder.addStatement("super(new $T[]{})", new Object[]{ConfigParam.class});
        } else {
            mainConstructorBuilder.addStatement("super($T.values())", new Object[]{fqEnumName});
        }
        List<CodeBlock> initCodeBlocks = this.prepareInitCodeBlocks(classSpec);
        for (CodeBlock initEmbeddedConfig : initCodeBlocks) {
            mainConstructorBuilder.addCode(initEmbeddedConfig);
        }
        mainConstructorBuilder.addCode("\n", new Object[0]);
        mainConstructorBuilder.addStatement("this.add(props)", new Object[0]);
        typeSpecBuilder.addMethod(mainConstructorBuilder.build());
    }

    private void addEmbeddedAccessorMethod(TypeSpec.Builder typeSpecBuilder, EmbeddedTypeSpec embeddedTypeSpec, ClassName fqEnumName) {
        ExecutableElement accessor = embeddedTypeSpec.accessor();
        boolean isOptional = !embeddedTypeSpec.mandatory();
        TypeElement returnTypeElement = (TypeElement)this.pEnv.getTypeUtils().asElement(embeddedTypeSpec.type());
        String generatedTypeName = NameUtils.deriveGeneratedClassName(returnTypeElement);
        typeSpecBuilder.addField(FieldSpec.builder((TypeName)ClassName.get((String)fqEnumName.packageName(), (String)generatedTypeName, (String[])new String[0]), (String)embeddedTypeSpec.key(), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        MethodSpec.Builder methodSpecBuilder = MethodSpec.overriding((ExecutableElement)accessor);
        if (isOptional) {
            methodSpecBuilder.addStatement("return $T.ofNullable(this.$L)", new Object[]{Optional.class, embeddedTypeSpec.key()});
        } else {
            methodSpecBuilder.addStatement("return this.$L", new Object[]{embeddedTypeSpec.key()});
        }
        String javadoc = this.pEnv.getElementUtils().getDocComment(accessor);
        if (javadoc != null) {
            methodSpecBuilder.addJavadoc(javadoc, new Object[0]);
        }
        typeSpecBuilder.addMethod(methodSpecBuilder.build());
    }

    private void addWriteExampleConfigMethod(TypeSpec.Builder typeSpecBuilder, ClassSpec classSpec) {
        String exampleContent = this.exampleContentHelper.createExampleContent(classSpec);
        typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"writeExampleConfig").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(TypeName.get(Writer.class), "writer", new Modifier[]{Modifier.FINAL}).addStatement("writer.append($S)", new Object[]{exampleContent}).addStatement("writer.flush()", new Object[0]).addException(IOException.class).addJavadoc("Write an example config file to the given Writer.\n\n@param writer the Writer to write to\n@throws IOException if writing the example config file fails", new Object[0]).build());
    }

    private void addBuilder(TypeSpec.Builder typeSpecBuilder, ClassSpec classSpec, ClassName fqClassName) {
        CoatBuilderGenerator builderGenerator = CoatBuilderGenerator.forType(classSpec, fqClassName, this.pEnv);
        typeSpecBuilder.addMethod(builderGenerator.generateBuilderMethod());
        typeSpecBuilder.addType(builderGenerator.generateBuilderClass());
    }

    private void addPrivateStaticFinalLogger(TypeSpec.Builder typeSpecBuilder, ClassName fqClassName) {
        typeSpecBuilder.addField(FieldSpec.builder(System.Logger.class, (String)"LOGGER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("System.getLogger($L.class.getName())", new Object[]{fqClassName}).build());
    }

    private void addStaticFactoryMethods(TypeSpec.Builder typeSpecBuilder, ClassName fqClassName) {
        typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"from").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)fqClassName).addParameter((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), "props", new Modifier[]{Modifier.FINAL}).addStatement("return new $T(props)", new Object[]{fqClassName}).addJavadoc("Create a new $T from the given config entries.\n\n@param props the config entries\n@return the $T created with the given entries", new Object[]{fqClassName, fqClassName}).build());
        typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"from").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)fqClassName).addParameter(File.class, "file", new Modifier[]{Modifier.FINAL}).addStatement("return new $T(toMap(file))", new Object[]{fqClassName}).addException(IOException.class).addJavadoc("Create a new $T from the given config file.\n\n@param file the config file to read\n@return the $T created with the entries from the given file\n@throws IOException if reading the given file failed", new Object[]{fqClassName, fqClassName}).build());
        typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"from").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)fqClassName).addParameter(Properties.class, "jup", new Modifier[]{Modifier.FINAL}).addStatement("return new $T(toMap(jup))", new Object[]{fqClassName}).addJavadoc("Create a new $T from the given config entries.\n\n@param jup the config entries\n@return the $T created with the given entries", new Object[]{fqClassName, fqClassName}).build());
        typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"fromEnvVars").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)fqClassName).addStatement("return builder().addEnvVars().build()", new Object[0]).addJavadoc("Create a new $T from the current environment variables.\n<p>\nSince the allowed characters for environment variables are much more restricted than Coat config keys,\na relaxed mapping is applied.\n<p>Dots and hyphens are treated as underscores. Also uppercase\ncharacters in config keys are preceded by an underscore (to convert camelCase to UPPER_CASE).\nComparison between the environment variables and the config keys is done case insensitively.<p>\nFor example the environment variable\n<code>SERVER_MQTT_HOST</code> will match the config key <code>server.mqttHost</code>.\n\n@return the $T created with the entries in the current environment variables", new Object[]{fqClassName, fqClassName}).build());
    }

    private void addGeneratedAnnotation(TypeSpec.Builder typeSpecBuilder) {
        Class<?> generatedAnnotationClass = this.identifyGeneratedAnnotation();
        if (generatedAnnotationClass != null) {
            typeSpecBuilder.addAnnotation(AnnotationSpec.builder(generatedAnnotationClass).addMember("value", "$S", new Object[]{this.getClass().getName()}).addMember("date", "$S", new Object[]{ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)}).build());
        }
    }

    private void addFieldAndAccessor(TypeSpec.Builder enumBuilder, Class fieldType, String fieldName) {
        enumBuilder.addField((Type)fieldType, fieldName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.methodBuilder((String)fieldName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((Type)fieldType).addStatement("return this.$N", new Object[]{fieldName}).build());
    }

    private void addFieldAndAccessor(TypeSpec.Builder enumBuilder, TypeName fieldType, String fieldName) {
        enumBuilder.addField(fieldType, fieldName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.methodBuilder((String)fieldName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(fieldType).addStatement("return this.$N", new Object[]{fieldName}).build());
    }

    private void addEnumConstant(TypeSpec.Builder typeSpecBuilder, AccessorSpec accessorSpec) {
        ExecutableElement accessor = accessorSpec.accessor();
        String constName = NameUtils.toConstName(accessorSpec.methodName());
        TypeSpec.Builder enumConstBuilder = TypeSpec.anonymousClassBuilder((String)"$S, $L.class, $L, $S, $L, $L, $L", (Object[])new Object[]{accessorSpec.key(), this.toBaseType(accessorSpec), this.specHelper.getCollectionTypeName(accessorSpec).map(c -> c + ".class").orElse(null), accessorSpec.defaultValue() != null && !accessorSpec.defaultValue().trim().isEmpty() ? accessorSpec.defaultValue() : null, accessorSpec.mandatory(), accessorSpec.converter().map(TypeMirror::toString).map(s -> s + ".class").orElse("null"), accessorSpec.listParser().map(TypeMirror::toString).map(s -> s + ".class").orElse("null")});
        String javadoc = this.pEnv.getElementUtils().getDocComment(accessor);
        if (javadoc != null) {
            enumConstBuilder.addJavadoc(JavadocHelper.stripBlockTagsFromJavadoc(javadoc), new Object[0]);
        }
        typeSpecBuilder.addEnumConstant(constName, enumConstBuilder.build());
    }

    private void addAccessorMethod(TypeSpec.Builder typeSpecBuilder, AccessorSpec accessorSpec, ClassName fqEnumName) {
        String defaultValue;
        ExecutableElement accessor = accessorSpec.accessor();
        String constName = NameUtils.toConstName(accessorSpec.methodName());
        ClassName constClass = ClassName.get((String)fqEnumName.packageName(), (String)fqEnumName.simpleName(), (String[])new String[]{constName});
        String string = defaultValue = accessorSpec.defaultValue() != null && !accessorSpec.defaultValue().trim().isEmpty() ? accessorSpec.defaultValue() : "";
        if (!accessorSpec.mandatory() && !defaultValue.trim().isEmpty()) {
            this.pEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Optional and default value don't make much sense together. The Optional will never be empty.", accessor);
        }
        String getter = this.specHelper.getSuperGetterName(accessorSpec);
        MethodSpec.Builder methodSpecBuilder = MethodSpec.overriding((ExecutableElement)accessor).addStatement("return super.$L($T)", new Object[]{getter, constClass});
        String javadoc = this.pEnv.getElementUtils().getDocComment(accessor);
        if (javadoc != null) {
            methodSpecBuilder.addJavadoc(javadoc, new Object[0]);
        }
        typeSpecBuilder.addMethod(methodSpecBuilder.build());
    }

    private void addEqualsMethod(TypeSpec.Builder typeSpecBuilder, List<? extends ExecutableElement> annotatedMethods, ClassName className) {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Object.class, "obj", new Modifier[]{Modifier.FINAL}).returns(Boolean.TYPE).addCode("if (this == obj) {\n  return true;\n}\n\nif (obj == null) {\n  return false;\n}\n\nif (this.getClass() != obj.getClass()) {\n  return false;\n}\n\n", new Object[0]).addStatement("final $T other = ($T) obj", new Object[]{className, className}).addCode("\n", new Object[0]);
        for (Element element : annotatedMethods) {
            Name methodName = element.getSimpleName();
            methodSpecBuilder.beginControlFlow("if (!$T.equals(this.$L(), other.$L()))", new Object[]{Objects.class, methodName, methodName}).addStatement("return false", new Object[0]).endControlFlow().addCode("\n", new Object[0]);
        }
        methodSpecBuilder.addStatement("return true", new Object[0]);
        typeSpecBuilder.addMethod(methodSpecBuilder.build()).build();
    }

    private void addHashCodeMethod(TypeSpec.Builder typeSpecBuilder, List<? extends ExecutableElement> annotatedMethods) {
        typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement(CodeBlock.of((String)annotatedMethods.stream().map(Element::getSimpleName).map(n -> String.valueOf(n) + "()").collect(Collectors.joining(",\n", "return java.util.Objects.hash(\n", ")")), (Object[])new Object[0])).build());
    }

    private List<CodeBlock> prepareInitCodeBlocks(ClassSpec classSpec) {
        ArrayList<CodeBlock> initCodeBlocks = new ArrayList<CodeBlock>();
        for (EmbeddedTypeSpec embeddedSpec : classSpec.embeddedTypes()) {
            CodeBlock initEmbeddedCodeBlock = this.createEmbeddedTypeInitializationCode(embeddedSpec);
            initCodeBlocks.add(initEmbeddedCodeBlock);
        }
        Optional<CodeBlock> registerCustomConverters = this.createRegisterCustomConverters(classSpec);
        registerCustomConverters.ifPresent(initCodeBlocks::add);
        Optional<CodeBlock> registerCustomListParser = this.createRegisterCustomListParser(classSpec);
        registerCustomListParser.ifPresent(initCodeBlocks::add);
        return initCodeBlocks;
    }

    private CodeBlock createEmbeddedTypeInitializationCode(EmbeddedTypeSpec embeddedTypeSpec) {
        boolean isOptional = !embeddedTypeSpec.mandatory();
        TypeElement returnTypeElement = (TypeElement)this.pEnv.getTypeUtils().asElement(embeddedTypeSpec.type());
        String generatedTypeName = NameUtils.deriveGeneratedClassName(returnTypeElement);
        CodeBlock.Builder initCodeBlockBuilder = CodeBlock.builder();
        initCodeBlockBuilder.add("\n", new Object[0]);
        if (isOptional) {
            initCodeBlockBuilder.beginControlFlow("if (hasPrefix(props, $S))", new Object[]{embeddedTypeSpec.key() + embeddedTypeSpec.keySeparator()});
        }
        initCodeBlockBuilder.addStatement("this.$N= $L.from(\nfilterByAndStripPrefix(props, $S))", new Object[]{embeddedTypeSpec.key(), generatedTypeName, embeddedTypeSpec.key() + embeddedTypeSpec.keySeparator()});
        if (isOptional) {
            initCodeBlockBuilder.nextControlFlow("else", new Object[0]).addStatement("this.$N= null", new Object[]{embeddedTypeSpec.key()}).endControlFlow();
        }
        initCodeBlockBuilder.addStatement("super.registerEmbeddedConfig($S, this.$N, $L)", new Object[]{embeddedTypeSpec.key() + embeddedTypeSpec.keySeparator(), embeddedTypeSpec.key(), isOptional});
        return initCodeBlockBuilder.build();
    }

    private Optional<CodeBlock> createRegisterCustomConverters(ClassSpec annotatedInterface) {
        if (annotatedInterface.converters().isEmpty()) {
            return Optional.empty();
        }
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        codeBlockBuilder.add("\n", new Object[0]);
        annotatedInterface.converters().forEach(c -> codeBlockBuilder.addStatement("super.registerCustomConverter(new $L())", new Object[]{c.toString()}));
        return Optional.of(codeBlockBuilder.build());
    }

    private Optional<CodeBlock> createRegisterCustomListParser(ClassSpec annotatedInterface) {
        if (annotatedInterface.listParser().isEmpty()) {
            return Optional.empty();
        }
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        codeBlockBuilder.add("\n", new Object[0]);
        codeBlockBuilder.addStatement("super.registerListParser(new $T())", new Object[]{annotatedInterface.listParser().get()});
        return Optional.of(codeBlockBuilder.build());
    }

    private List<ExecutableElement> getAllAnnotatedMethodsAsElements(ClassSpec classSpec) {
        return Stream.concat(classSpec.accessors().stream().map(AccessorSpec::accessor), classSpec.embeddedTypes().stream().map(EmbeddedTypeSpec::accessor)).distinct().collect(Collectors.toList());
    }

    @Nullable
    private Class<?> identifyGeneratedAnnotation() {
        try {
            SourceVersion sourceVersion = this.pEnv.getSourceVersion();
            return sourceVersion.compareTo(SourceVersion.RELEASE_8) > 0 ? Class.forName("javax.annotation.processing.Generated") : Class.forName("javax.annotation.Generated");
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private String toBaseType(AccessorSpec accessorSpec) {
        TypeMirror type = accessorSpec.type();
        if (type.getKind() == TypeKind.INT || this.pEnv.getTypeUtils().isSameType(type, this.typeHelper.optionalIntType)) {
            return Integer.TYPE.getName();
        }
        if (type.getKind() == TypeKind.LONG || this.pEnv.getTypeUtils().isSameType(type, this.typeHelper.optionalLongType)) {
            return Long.TYPE.getName();
        }
        if (type.getKind() == TypeKind.DOUBLE || this.pEnv.getTypeUtils().isSameType(type, this.typeHelper.optionalDoubleType)) {
            return Double.TYPE.getName();
        }
        if (type.getKind() == TypeKind.BOOLEAN) {
            return Boolean.TYPE.getName();
        }
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            TypeMirror erasure = this.pEnv.getTypeUtils().erasure(type);
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (this.pEnv.getTypeUtils().isAssignable(erasure, this.typeHelper.optionalType)) {
                if (typeArguments.size() < 1) {
                    throw new CoatProcessorException("Optionals without type argument are not supported.", accessorSpec.accessor());
                }
                if (typeArguments.size() > 1) {
                    throw new CoatProcessorException("Optionals with multiple type arguments are not expected.", accessorSpec.accessor());
                }
                TypeMirror typeArg = typeArguments.get(0);
                if (typeArg.getKind() == TypeKind.DECLARED) {
                    DeclaredType dc = (DeclaredType)typeArg;
                    return dc.asElement().toString();
                }
                return typeArg.toString();
            }
            return declaredType.asElement().toString();
        }
        if (type.getKind() == TypeKind.ARRAY) {
            ArrayType arraysType = (ArrayType)type;
            TypeMirror componentType = arraysType.getComponentType();
            return this.pEnv.getTypeUtils().asElement(componentType).toString();
        }
        return type.toString();
    }
}

