/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor.codegeneration;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import de.poiu.coat.c14n.KeyC14n;
import de.poiu.coat.processor.specs.AccessorSpec;
import de.poiu.coat.processor.specs.ClassSpec;
import de.poiu.coat.processor.utils.SpecHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

public class CoatBuilderGenerator {
    private final ProcessingEnvironment pEnv;
    private final SpecHelper specHelper;
    private final ClassSpec annotatedInterface;
    private final ClassName coatConfigClassName;
    private final ClassName builderClassName;

    private CoatBuilderGenerator(ClassSpec annotatedInterface, ClassName fqClassName, ProcessingEnvironment processingEnv) {
        this.pEnv = processingEnv;
        this.specHelper = new SpecHelper(this.pEnv);
        this.annotatedInterface = annotatedInterface;
        this.coatConfigClassName = fqClassName;
        this.builderClassName = fqClassName.nestedClass("Builder");
    }

    public static CoatBuilderGenerator forType(ClassSpec annotatedInterface, ClassName coatConfigClassName, ProcessingEnvironment processingEnv) {
        return new CoatBuilderGenerator(annotatedInterface, coatConfigClassName, processingEnv);
    }

    public MethodSpec generateBuilderMethod() {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.builderClassName).addStatement("return new Builder()", new Object[0]).addJavadoc("Create a builder for {@link $T} instances.\n<p>\nCall the <code>add</code> and/or <code>addEnvVars</code> methods for specifying the config\nsources (and the order in which they are applied), then call {@link Builder#build()} to create the\n$T\n\n@return an new $T builder", new Object[]{this.coatConfigClassName, this.coatConfigClassName, this.coatConfigClassName});
        return methodSpecBuilder.build();
    }

    public TypeSpec generateBuilderClass() {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((ClassName)this.builderClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("Builder class for creating new {@link $T} instances.\n<p>\nCall the <code>add</code> and/or <code>addEnvVars</code> methods for specifying the config\nsources (and the order in which they are applied), then call {@link Builder#build()} to create the\n$T", new Object[]{this.coatConfigClassName, this.coatConfigClassName}).addField(this.generateFieldProps()).addMethod(this.generateMethodAddMap()).addMethod(this.generateMethodAddFile()).addMethod(this.generateMethodAddProperties()).addMethod(this.generateMethodAddEnvVars()).addMethod(this.generateMethodBuild());
        return typeSpecBuilder.build();
    }

    private FieldSpec generateFieldProps() {
        return FieldSpec.builder((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), (String)"props", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T<>()", new Object[]{TypeName.get(HashMap.class)}).build();
    }

    private MethodSpec generateMethodAddMap() {
        return MethodSpec.methodBuilder((String)"add").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), "map", new Modifier[]{Modifier.FINAL}).returns((TypeName)this.builderClassName).addStatement("this.props.putAll(map)", new Object[0]).addStatement("return this", new Object[0]).addJavadoc("Add the config entries from the given Map to the built $T.\nAlready existing config entries with the same keys will be overwritten.\n\n@param map the config entries to add\n@return this Builder", new Object[]{this.coatConfigClassName}).build();
    }

    private MethodSpec generateMethodAddFile() {
        return MethodSpec.methodBuilder((String)"add").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.get(File.class), "file", new Modifier[]{Modifier.FINAL}).returns((TypeName)this.builderClassName).addException(TypeName.get(IOException.class)).addStatement("this.props.putAll(toMap(file))", new Object[0]).addStatement("return this", new Object[0]).addJavadoc("Add the config entries from the given file to the built $T.\nAlready existing config entries with the same keys will be overwritten.\n\n@param file the file with the config entries to add\n@return this Builder\n@throws java.io.IOException if reading the config file failed", new Object[]{this.coatConfigClassName}).build();
    }

    private MethodSpec generateMethodAddProperties() {
        return MethodSpec.methodBuilder((String)"add").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.get(Properties.class), "jup", new Modifier[]{Modifier.FINAL}).returns((TypeName)this.builderClassName).addStatement("this.props.putAll(toMap(jup))", new Object[0]).addStatement("return this", new Object[0]).addJavadoc("Add the config entries from the given Properties to the built $T.\nAlready existing config entries with the same keys will be overwritten.\n\n@param jup the config entries to add\n@return this Builder", new Object[]{this.coatConfigClassName}).build();
    }

    private MethodSpec generateMethodAddEnvVars() {
        return MethodSpec.methodBuilder((String)"addEnvVars").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.builderClassName).addStatement("final Map<String, String> envVars= System.getenv()", new Object[0]).addStatement("final String[] configKeys= {\n$L\n}", new Object[]{this.getParamNamesString()}).addCode("\n", new Object[0]).beginControlFlow("for (final String envVar : envVars.keySet())", new Object[0]).beginControlFlow("for (final String configKey : configKeys)", new Object[0]).beginControlFlow("if (envVar.toUpperCase().equals($T.c14n(configKey)))", new Object[]{KeyC14n.class}).addStatement("LOGGER.log($T.INFO, \"Using environment variable {0} as config key {1}\", new Object[]{envVar, configKey})", new Object[]{System.Logger.Level.class}).addStatement("this.props.put(configKey, envVars.get(envVar))", new Object[0]).endControlFlow().endControlFlow().endControlFlow().addCode("\n", new Object[0]).addStatement("return this", new Object[0]).addJavadoc("Add the config entries from the current environment variables to the built $T.\nAlready existing config entries with the same keys will be overwritten.\n<p>\nSince the allowed characters for environment variables are much more restricted than Coat config keys,\na relaxed mapping is applied.\n<p>Dots and hyphens are treated as underscores. Also uppercase\ncharacters in config keys are preceded by an underscore (to convert camelCase to UPPER_CASE).\nComparison between the environment variables and the config keys is done case insensitively.<p>\nFor example the environment variable\n<code>SERVER_MQTT_HOST</code> will match the config key <code>server.mqttHost</code>.\n@return this Builder", new Object[]{this.coatConfigClassName}).build();
    }

    private MethodSpec generateMethodBuild() {
        return MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.coatConfigClassName).addStatement("return new $T(this.props)", new Object[]{this.coatConfigClassName}).addJavadoc("Build a new {@link $T} with the config keys from this Builder.\n\n@return a new $T", new Object[]{this.coatConfigClassName, this.coatConfigClassName}).build();
    }

    private String getParamNamesString() {
        return SpecHelper.getAccessorSpecsRecursively(this.annotatedInterface).stream().map(AccessorSpec::key).collect(Collectors.joining("\",\n\"", "\"", "\""));
    }
}

