/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.processor;

import de.poiu.coat.processor.CoatProcessorException;
import de.poiu.coat.processor.codegeneration.CodeGenerator;
import de.poiu.coat.processor.examplecontent.ExampleContentHelper;
import de.poiu.coat.processor.specs.ClassSpec;
import de.poiu.coat.processor.specs.ClassSpecComparator;
import de.poiu.coat.processor.specs.SpecHandler;
import de.poiu.coat.processor.utils.Assertions;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"de.poiu.coat.annotation.Coat.Config"})
public class CoatProcessor
extends AbstractProcessor {
    private SpecHandler specHandler = null;
    private Assertions assertions = null;
    private CodeGenerator codeGenerator = null;
    private ExampleContentHelper exampleContentHelper = null;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.specHandler = new SpecHandler(this.processingEnv);
        this.assertions = new Assertions(this.processingEnv);
        this.codeGenerator = new CodeGenerator(this.processingEnv);
        this.exampleContentHelper = new ExampleContentHelper(this.processingEnv);
        annotations.stream().filter(a -> a.getQualifiedName().contentEquals("de.poiu.coat.annotation.Coat.Config")).flatMap(a -> roundEnv.getElementsAnnotatedWith((TypeElement)a).stream()).map(e -> (TypeElement)e).map(this.specHandler::classSpecFrom).sorted(ClassSpecComparator.INSTANCE).forEachOrdered(this::generateCode);
        return true;
    }

    private void generateCode(ClassSpec coatClassSpec) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("Generating code for %s.", coatClassSpec.annotatedType()));
        this.assertions.assertIsInterface(coatClassSpec.annotatedType());
        this.assertions.assertReturnType(coatClassSpec.accessors());
        this.assertions.assertOnlySupportedPrimitives(coatClassSpec.accessors());
        this.assertions.assertNoPrimitiveArrays(coatClassSpec.accessors());
        this.assertions.assertNoParameters(coatClassSpec.accessors());
        this.assertions.assertUniqueKeys(coatClassSpec.accessors());
        this.assertions.assertUniqueMethodNames(coatClassSpec.accessors());
        this.assertions.assertEmbeddedTypesAreAnnotated(coatClassSpec.embeddedTypes());
        this.assertions.assertEmbeddedTypesAreNotInCollection(coatClassSpec.embeddedTypes());
        this.assertions.assertOnlyEitherEmbeddedOrParamAnnotation(coatClassSpec.embeddedTypes());
        TypeElement annotatedInterface = coatClassSpec.annotatedType();
        try {
            this.codeGenerator.generateEnumCode(coatClassSpec);
            this.codeGenerator.generateClassCode(coatClassSpec);
            this.exampleContentHelper.generateExampleFile(coatClassSpec, this.processingEnv.getFiler());
        }
        catch (CoatProcessorException ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getMsg(), ex.getElement() != null ? ex.getElement() : annotatedInterface);
        }
        catch (Exception ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Error generating code for %s: %s", annotatedInterface, ex.getMessage()), annotatedInterface);
            ex.printStackTrace();
        }
    }
}

