package de.poiu.coat.processor.specs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SimplifiedAccessorSpec}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSimplifiedAccessorSpec.builder()}.
 */
@Generated(from = "SimplifiedAccessorSpec", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSimplifiedAccessorSpec extends SimplifiedAccessorSpec {
  private final AccessorSpec accessor;
  private final String methodName;
  private final String key;
  private final String defaultValue;
  private final TypeMirror type;
  private final boolean mandatory;

  private ImmutableSimplifiedAccessorSpec(
      AccessorSpec accessor,
      String methodName,
      String key,
      String defaultValue,
      TypeMirror type,
      boolean mandatory) {
    this.accessor = accessor;
    this.methodName = methodName;
    this.key = key;
    this.defaultValue = defaultValue;
    this.type = type;
    this.mandatory = mandatory;
  }

  /**
   * @return The value of the {@code accessor} attribute
   */
  @Override
  public AccessorSpec accessor() {
    return accessor;
  }

  /**
   * @return The value of the {@code methodName} attribute
   */
  @Override
  public String methodName() {
    return methodName;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public String key() {
    return key;
  }

  /**
   * @return The value of the {@code defaultValue} attribute
   */
  @Override
  public String defaultValue() {
    return defaultValue;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public TypeMirror type() {
    return type;
  }

  /**
   * @return The value of the {@code mandatory} attribute
   */
  @Override
  public boolean mandatory() {
    return mandatory;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SimplifiedAccessorSpec#accessor() accessor} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for accessor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSimplifiedAccessorSpec withAccessor(AccessorSpec value) {
    if (this.accessor == value) return this;
    AccessorSpec newValue = Objects.requireNonNull(value, "accessor");
    return new ImmutableSimplifiedAccessorSpec(newValue, this.methodName, this.key, this.defaultValue, this.type, this.mandatory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SimplifiedAccessorSpec#methodName() methodName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for methodName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSimplifiedAccessorSpec withMethodName(String value) {
    String newValue = Objects.requireNonNull(value, "methodName");
    if (this.methodName.equals(newValue)) return this;
    return new ImmutableSimplifiedAccessorSpec(this.accessor, newValue, this.key, this.defaultValue, this.type, this.mandatory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SimplifiedAccessorSpec#key() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSimplifiedAccessorSpec withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (this.key.equals(newValue)) return this;
    return new ImmutableSimplifiedAccessorSpec(this.accessor, this.methodName, newValue, this.defaultValue, this.type, this.mandatory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SimplifiedAccessorSpec#defaultValue() defaultValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSimplifiedAccessorSpec withDefaultValue(String value) {
    String newValue = Objects.requireNonNull(value, "defaultValue");
    if (this.defaultValue.equals(newValue)) return this;
    return new ImmutableSimplifiedAccessorSpec(this.accessor, this.methodName, this.key, newValue, this.type, this.mandatory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SimplifiedAccessorSpec#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSimplifiedAccessorSpec withType(TypeMirror value) {
    if (this.type == value) return this;
    TypeMirror newValue = Objects.requireNonNull(value, "type");
    return new ImmutableSimplifiedAccessorSpec(this.accessor, this.methodName, this.key, this.defaultValue, newValue, this.mandatory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SimplifiedAccessorSpec#mandatory() mandatory} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mandatory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSimplifiedAccessorSpec withMandatory(boolean value) {
    if (this.mandatory == value) return this;
    return new ImmutableSimplifiedAccessorSpec(this.accessor, this.methodName, this.key, this.defaultValue, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSimplifiedAccessorSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSimplifiedAccessorSpec
        && equalTo(0, (ImmutableSimplifiedAccessorSpec) another);
  }

  private boolean equalTo(int synthetic, ImmutableSimplifiedAccessorSpec another) {
    return methodName.equals(another.methodName)
        && key.equals(another.key)
        && defaultValue.equals(another.defaultValue)
        && type.equals(another.type)
        && mandatory == another.mandatory;
  }

  /**
   * Computes a hash code from attributes: {@code methodName}, {@code key}, {@code defaultValue}, {@code type}, {@code mandatory}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + methodName.hashCode();
    h += (h << 5) + key.hashCode();
    h += (h << 5) + defaultValue.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Boolean.hashCode(mandatory);
    return h;
  }

  /**
   * Prints the immutable value {@code SimplifiedAccessorSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SimplifiedAccessorSpec{"
        + "methodName=" + methodName
        + ", key=" + key
        + ", defaultValue=" + defaultValue
        + ", type=" + type
        + ", mandatory=" + mandatory
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SimplifiedAccessorSpec} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SimplifiedAccessorSpec instance
   */
  public static ImmutableSimplifiedAccessorSpec copyOf(SimplifiedAccessorSpec instance) {
    if (instance instanceof ImmutableSimplifiedAccessorSpec) {
      return (ImmutableSimplifiedAccessorSpec) instance;
    }
    return ImmutableSimplifiedAccessorSpec.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSimplifiedAccessorSpec ImmutableSimplifiedAccessorSpec}.
   * <pre>
   * ImmutableSimplifiedAccessorSpec.builder()
   *    .accessor(de.poiu.coat.processor.specs.AccessorSpec) // required {@link SimplifiedAccessorSpec#accessor() accessor}
   *    .methodName(String) // required {@link SimplifiedAccessorSpec#methodName() methodName}
   *    .key(String) // required {@link SimplifiedAccessorSpec#key() key}
   *    .defaultValue(String) // required {@link SimplifiedAccessorSpec#defaultValue() defaultValue}
   *    .type(javax.lang.model.type.TypeMirror) // required {@link SimplifiedAccessorSpec#type() type}
   *    .mandatory(boolean) // required {@link SimplifiedAccessorSpec#mandatory() mandatory}
   *    .build();
   * </pre>
   * @return A new ImmutableSimplifiedAccessorSpec builder
   */
  public static ImmutableSimplifiedAccessorSpec.Builder builder() {
    return new ImmutableSimplifiedAccessorSpec.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSimplifiedAccessorSpec ImmutableSimplifiedAccessorSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SimplifiedAccessorSpec", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ACCESSOR = 0x1L;
    private static final long INIT_BIT_METHOD_NAME = 0x2L;
    private static final long INIT_BIT_KEY = 0x4L;
    private static final long INIT_BIT_DEFAULT_VALUE = 0x8L;
    private static final long INIT_BIT_TYPE = 0x10L;
    private static final long INIT_BIT_MANDATORY = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable AccessorSpec accessor;
    private @Nullable String methodName;
    private @Nullable String key;
    private @Nullable String defaultValue;
    private @Nullable TypeMirror type;
    private boolean mandatory;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SimplifiedAccessorSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SimplifiedAccessorSpec instance) {
      Objects.requireNonNull(instance, "instance");
      this.accessor(instance.accessor());
      this.methodName(instance.methodName());
      this.key(instance.key());
      this.defaultValue(instance.defaultValue());
      this.type(instance.type());
      this.mandatory(instance.mandatory());
      return this;
    }

    /**
     * Initializes the value for the {@link SimplifiedAccessorSpec#accessor() accessor} attribute.
     * @param accessor The value for accessor 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder accessor(AccessorSpec accessor) {
      this.accessor = Objects.requireNonNull(accessor, "accessor");
      initBits &= ~INIT_BIT_ACCESSOR;
      return this;
    }

    /**
     * Initializes the value for the {@link SimplifiedAccessorSpec#methodName() methodName} attribute.
     * @param methodName The value for methodName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder methodName(String methodName) {
      this.methodName = Objects.requireNonNull(methodName, "methodName");
      initBits &= ~INIT_BIT_METHOD_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SimplifiedAccessorSpec#key() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link SimplifiedAccessorSpec#defaultValue() defaultValue} attribute.
     * @param defaultValue The value for defaultValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultValue(String defaultValue) {
      this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
      initBits &= ~INIT_BIT_DEFAULT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link SimplifiedAccessorSpec#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(TypeMirror type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link SimplifiedAccessorSpec#mandatory() mandatory} attribute.
     * @param mandatory The value for mandatory 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mandatory(boolean mandatory) {
      this.mandatory = mandatory;
      initBits &= ~INIT_BIT_MANDATORY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSimplifiedAccessorSpec ImmutableSimplifiedAccessorSpec}.
     * @return An immutable instance of SimplifiedAccessorSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSimplifiedAccessorSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSimplifiedAccessorSpec(accessor, methodName, key, defaultValue, type, mandatory);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ACCESSOR) != 0) attributes.add("accessor");
      if ((initBits & INIT_BIT_METHOD_NAME) != 0) attributes.add("methodName");
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_DEFAULT_VALUE) != 0) attributes.add("defaultValue");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_MANDATORY) != 0) attributes.add("mandatory");
      return "Cannot build SimplifiedAccessorSpec, some of required attributes are not set " + attributes;
    }
  }
}
