package de.poiu.coat.processor.specs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EnclosedType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEnclosedType.builder()}.
 */
@Generated(from = "EnclosedType", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableEnclosedType extends EnclosedType {
  private final @Nullable TypeMirror enclosure;
  private final TypeMirror type;

  private ImmutableEnclosedType(
      @Nullable TypeMirror enclosure,
      TypeMirror type) {
    this.enclosure = enclosure;
    this.type = type;
  }

  /**
   *The container class 
   */
  @Override
  public Optional<TypeMirror> enclosure() {
    return Optional.ofNullable(enclosure);
  }

  /**
   *The actual type 
   */
  @Override
  public TypeMirror type() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link EnclosedType#enclosure() enclosure} attribute.
   * @param value The value for enclosure
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEnclosedType withEnclosure(TypeMirror value) {
    TypeMirror newValue = Objects.requireNonNull(value, "enclosure");
    if (this.enclosure == newValue) return this;
    return new ImmutableEnclosedType(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link EnclosedType#enclosure() enclosure} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for enclosure
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableEnclosedType withEnclosure(Optional<? extends TypeMirror> optional) {
    @Nullable TypeMirror value = optional.orElse(null);
    if (this.enclosure == value) return this;
    return new ImmutableEnclosedType(value, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnclosedType#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnclosedType withType(TypeMirror value) {
    if (this.type == value) return this;
    TypeMirror newValue = Objects.requireNonNull(value, "type");
    return new ImmutableEnclosedType(this.enclosure, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEnclosedType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEnclosedType
        && equalTo(0, (ImmutableEnclosedType) another);
  }

  private boolean equalTo(int synthetic, ImmutableEnclosedType another) {
    return Objects.equals(enclosure, another.enclosure)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code enclosure}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(enclosure);
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EnclosedType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("EnclosedType{");
    if (enclosure != null) {
      builder.append("enclosure=").append(enclosure);
    }
    if (builder.length() > 13) builder.append(", ");
    builder.append("type=").append(type);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link EnclosedType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EnclosedType instance
   */
  public static ImmutableEnclosedType copyOf(EnclosedType instance) {
    if (instance instanceof ImmutableEnclosedType) {
      return (ImmutableEnclosedType) instance;
    }
    return ImmutableEnclosedType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEnclosedType ImmutableEnclosedType}.
   * <pre>
   * ImmutableEnclosedType.builder()
   *    .enclosure(javax.lang.model.type.TypeMirror) // optional {@link EnclosedType#enclosure() enclosure}
   *    .type(javax.lang.model.type.TypeMirror) // required {@link EnclosedType#type() type}
   *    .build();
   * </pre>
   * @return A new ImmutableEnclosedType builder
   */
  public static ImmutableEnclosedType.Builder builder() {
    return new ImmutableEnclosedType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEnclosedType ImmutableEnclosedType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EnclosedType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable TypeMirror enclosure;
    private @Nullable TypeMirror type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EnclosedType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EnclosedType instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<TypeMirror> enclosureOptional = instance.enclosure();
      if (enclosureOptional.isPresent()) {
        enclosure(enclosureOptional);
      }
      this.type(instance.type());
      return this;
    }

    /**
     * Initializes the optional value {@link EnclosedType#enclosure() enclosure} to enclosure.
     * @param enclosure The value for enclosure
     * @return {@code this} builder for chained invocation
     */
    public final Builder enclosure(TypeMirror enclosure) {
      this.enclosure = Objects.requireNonNull(enclosure, "enclosure");
      return this;
    }

    /**
     * Initializes the optional value {@link EnclosedType#enclosure() enclosure} to enclosure.
     * @param enclosure The value for enclosure
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enclosure(Optional<? extends TypeMirror> enclosure) {
      this.enclosure = enclosure.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link EnclosedType#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(TypeMirror type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEnclosedType ImmutableEnclosedType}.
     * @return An immutable instance of EnclosedType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEnclosedType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEnclosedType(enclosure, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build EnclosedType, some of required attributes are not set " + attributes;
    }
  }
}
