package de.poiu.coat.processor.specs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EmbeddedTypeSpec}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEmbeddedTypeSpec.builder()}.
 */
@Generated(from = "EmbeddedTypeSpec", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableEmbeddedTypeSpec extends EmbeddedTypeSpec {
  private final ExecutableElement accessor;
  private final ClassSpec classSpec;
  private final @Nullable TypeMirror enclosure;
  private final String key;
  private final String keySeparator;
  private final boolean mandatory;
  private final TypeMirror type;

  private ImmutableEmbeddedTypeSpec(
      ExecutableElement accessor,
      ClassSpec classSpec,
      @Nullable TypeMirror enclosure,
      String key,
      String keySeparator,
      boolean mandatory,
      TypeMirror type) {
    this.accessor = accessor;
    this.classSpec = classSpec;
    this.enclosure = enclosure;
    this.key = key;
    this.keySeparator = keySeparator;
    this.mandatory = mandatory;
    this.type = type;
  }

  /**
   * @return The value of the {@code accessor} attribute
   */
  @Override
  public ExecutableElement accessor() {
    return accessor;
  }

  /**
   * @return The value of the {@code classSpec} attribute
   */
  @Override
  public ClassSpec classSpec() {
    return classSpec;
  }

  /**
   * @return The value of the {@code enclosure} attribute
   */
  @Override
  public Optional<TypeMirror> enclosure() {
    return Optional.ofNullable(enclosure);
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public String key() {
    return key;
  }

  /**
   * @return The value of the {@code keySeparator} attribute
   */
  @Override
  public String keySeparator() {
    return keySeparator;
  }

  /**
   * @return The value of the {@code mandatory} attribute
   */
  @Override
  public boolean mandatory() {
    return mandatory;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public TypeMirror type() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmbeddedTypeSpec#accessor() accessor} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for accessor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEmbeddedTypeSpec withAccessor(ExecutableElement value) {
    if (this.accessor == value) return this;
    ExecutableElement newValue = Objects.requireNonNull(value, "accessor");
    return new ImmutableEmbeddedTypeSpec(
        newValue,
        this.classSpec,
        this.enclosure,
        this.key,
        this.keySeparator,
        this.mandatory,
        this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmbeddedTypeSpec#classSpec() classSpec} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for classSpec
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEmbeddedTypeSpec withClassSpec(ClassSpec value) {
    if (this.classSpec == value) return this;
    ClassSpec newValue = Objects.requireNonNull(value, "classSpec");
    return new ImmutableEmbeddedTypeSpec(this.accessor, newValue, this.enclosure, this.key, this.keySeparator, this.mandatory, this.type);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link EmbeddedTypeSpec#enclosure() enclosure} attribute.
   * @param value The value for enclosure
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEmbeddedTypeSpec withEnclosure(TypeMirror value) {
    TypeMirror newValue = Objects.requireNonNull(value, "enclosure");
    if (this.enclosure == newValue) return this;
    return new ImmutableEmbeddedTypeSpec(this.accessor, this.classSpec, newValue, this.key, this.keySeparator, this.mandatory, this.type);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link EmbeddedTypeSpec#enclosure() enclosure} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for enclosure
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableEmbeddedTypeSpec withEnclosure(Optional<? extends TypeMirror> optional) {
    @Nullable TypeMirror value = optional.orElse(null);
    if (this.enclosure == value) return this;
    return new ImmutableEmbeddedTypeSpec(this.accessor, this.classSpec, value, this.key, this.keySeparator, this.mandatory, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmbeddedTypeSpec#key() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEmbeddedTypeSpec withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (this.key.equals(newValue)) return this;
    return new ImmutableEmbeddedTypeSpec(
        this.accessor,
        this.classSpec,
        this.enclosure,
        newValue,
        this.keySeparator,
        this.mandatory,
        this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmbeddedTypeSpec#keySeparator() keySeparator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keySeparator
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEmbeddedTypeSpec withKeySeparator(String value) {
    String newValue = Objects.requireNonNull(value, "keySeparator");
    if (this.keySeparator.equals(newValue)) return this;
    return new ImmutableEmbeddedTypeSpec(this.accessor, this.classSpec, this.enclosure, this.key, newValue, this.mandatory, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmbeddedTypeSpec#mandatory() mandatory} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mandatory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEmbeddedTypeSpec withMandatory(boolean value) {
    if (this.mandatory == value) return this;
    return new ImmutableEmbeddedTypeSpec(this.accessor, this.classSpec, this.enclosure, this.key, this.keySeparator, value, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmbeddedTypeSpec#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEmbeddedTypeSpec withType(TypeMirror value) {
    if (this.type == value) return this;
    TypeMirror newValue = Objects.requireNonNull(value, "type");
    return new ImmutableEmbeddedTypeSpec(
        this.accessor,
        this.classSpec,
        this.enclosure,
        this.key,
        this.keySeparator,
        this.mandatory,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEmbeddedTypeSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEmbeddedTypeSpec
        && equalTo(0, (ImmutableEmbeddedTypeSpec) another);
  }

  private boolean equalTo(int synthetic, ImmutableEmbeddedTypeSpec another) {
    return accessor.equals(another.accessor)
        && classSpec.equals(another.classSpec)
        && Objects.equals(enclosure, another.enclosure)
        && key.equals(another.key)
        && keySeparator.equals(another.keySeparator)
        && mandatory == another.mandatory
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code accessor}, {@code classSpec}, {@code enclosure}, {@code key}, {@code keySeparator}, {@code mandatory}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + accessor.hashCode();
    h += (h << 5) + classSpec.hashCode();
    h += (h << 5) + Objects.hashCode(enclosure);
    h += (h << 5) + key.hashCode();
    h += (h << 5) + keySeparator.hashCode();
    h += (h << 5) + Boolean.hashCode(mandatory);
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EmbeddedTypeSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("EmbeddedTypeSpec{");
    builder.append("accessor=").append(accessor);
    builder.append(", ");
    builder.append("classSpec=").append(classSpec);
    if (enclosure != null) {
      builder.append(", ");
      builder.append("enclosure=").append(enclosure);
    }
    builder.append(", ");
    builder.append("key=").append(key);
    builder.append(", ");
    builder.append("keySeparator=").append(keySeparator);
    builder.append(", ");
    builder.append("mandatory=").append(mandatory);
    builder.append(", ");
    builder.append("type=").append(type);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link EmbeddedTypeSpec} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EmbeddedTypeSpec instance
   */
  public static ImmutableEmbeddedTypeSpec copyOf(EmbeddedTypeSpec instance) {
    if (instance instanceof ImmutableEmbeddedTypeSpec) {
      return (ImmutableEmbeddedTypeSpec) instance;
    }
    return ImmutableEmbeddedTypeSpec.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEmbeddedTypeSpec ImmutableEmbeddedTypeSpec}.
   * <pre>
   * ImmutableEmbeddedTypeSpec.builder()
   *    .accessor(javax.lang.model.element.ExecutableElement) // required {@link EmbeddedTypeSpec#accessor() accessor}
   *    .classSpec(de.poiu.coat.processor.specs.ClassSpec) // required {@link EmbeddedTypeSpec#classSpec() classSpec}
   *    .enclosure(javax.lang.model.type.TypeMirror) // optional {@link EmbeddedTypeSpec#enclosure() enclosure}
   *    .key(String) // required {@link EmbeddedTypeSpec#key() key}
   *    .keySeparator(String) // required {@link EmbeddedTypeSpec#keySeparator() keySeparator}
   *    .mandatory(boolean) // required {@link EmbeddedTypeSpec#mandatory() mandatory}
   *    .type(javax.lang.model.type.TypeMirror) // required {@link EmbeddedTypeSpec#type() type}
   *    .build();
   * </pre>
   * @return A new ImmutableEmbeddedTypeSpec builder
   */
  public static ImmutableEmbeddedTypeSpec.Builder builder() {
    return new ImmutableEmbeddedTypeSpec.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEmbeddedTypeSpec ImmutableEmbeddedTypeSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EmbeddedTypeSpec", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ACCESSOR = 0x1L;
    private static final long INIT_BIT_CLASS_SPEC = 0x2L;
    private static final long INIT_BIT_KEY = 0x4L;
    private static final long INIT_BIT_KEY_SEPARATOR = 0x8L;
    private static final long INIT_BIT_MANDATORY = 0x10L;
    private static final long INIT_BIT_TYPE = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable ExecutableElement accessor;
    private @Nullable ClassSpec classSpec;
    private @Nullable TypeMirror enclosure;
    private @Nullable String key;
    private @Nullable String keySeparator;
    private boolean mandatory;
    private @Nullable TypeMirror type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EmbeddedTypeSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EmbeddedTypeSpec instance) {
      Objects.requireNonNull(instance, "instance");
      this.accessor(instance.accessor());
      this.classSpec(instance.classSpec());
      Optional<TypeMirror> enclosureOptional = instance.enclosure();
      if (enclosureOptional.isPresent()) {
        enclosure(enclosureOptional);
      }
      this.key(instance.key());
      this.keySeparator(instance.keySeparator());
      this.mandatory(instance.mandatory());
      this.type(instance.type());
      return this;
    }

    /**
     * Initializes the value for the {@link EmbeddedTypeSpec#accessor() accessor} attribute.
     * @param accessor The value for accessor 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder accessor(ExecutableElement accessor) {
      this.accessor = Objects.requireNonNull(accessor, "accessor");
      initBits &= ~INIT_BIT_ACCESSOR;
      return this;
    }

    /**
     * Initializes the value for the {@link EmbeddedTypeSpec#classSpec() classSpec} attribute.
     * @param classSpec The value for classSpec 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder classSpec(ClassSpec classSpec) {
      this.classSpec = Objects.requireNonNull(classSpec, "classSpec");
      initBits &= ~INIT_BIT_CLASS_SPEC;
      return this;
    }

    /**
     * Initializes the optional value {@link EmbeddedTypeSpec#enclosure() enclosure} to enclosure.
     * @param enclosure The value for enclosure
     * @return {@code this} builder for chained invocation
     */
    public final Builder enclosure(TypeMirror enclosure) {
      this.enclosure = Objects.requireNonNull(enclosure, "enclosure");
      return this;
    }

    /**
     * Initializes the optional value {@link EmbeddedTypeSpec#enclosure() enclosure} to enclosure.
     * @param enclosure The value for enclosure
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enclosure(Optional<? extends TypeMirror> enclosure) {
      this.enclosure = enclosure.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link EmbeddedTypeSpec#key() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link EmbeddedTypeSpec#keySeparator() keySeparator} attribute.
     * @param keySeparator The value for keySeparator 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder keySeparator(String keySeparator) {
      this.keySeparator = Objects.requireNonNull(keySeparator, "keySeparator");
      initBits &= ~INIT_BIT_KEY_SEPARATOR;
      return this;
    }

    /**
     * Initializes the value for the {@link EmbeddedTypeSpec#mandatory() mandatory} attribute.
     * @param mandatory The value for mandatory 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mandatory(boolean mandatory) {
      this.mandatory = mandatory;
      initBits &= ~INIT_BIT_MANDATORY;
      return this;
    }

    /**
     * Initializes the value for the {@link EmbeddedTypeSpec#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(TypeMirror type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEmbeddedTypeSpec ImmutableEmbeddedTypeSpec}.
     * @return An immutable instance of EmbeddedTypeSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEmbeddedTypeSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEmbeddedTypeSpec(accessor, classSpec, enclosure, key, keySeparator, mandatory, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ACCESSOR) != 0) attributes.add("accessor");
      if ((initBits & INIT_BIT_CLASS_SPEC) != 0) attributes.add("classSpec");
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_KEY_SEPARATOR) != 0) attributes.add("keySeparator");
      if ((initBits & INIT_BIT_MANDATORY) != 0) attributes.add("mandatory");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build EmbeddedTypeSpec, some of required attributes are not set " + attributes;
    }
  }
}
