package de.poiu.coat.processor.specs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ClassSpec}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableClassSpec.builder()}.
 */
@Generated(from = "ClassSpec", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableClassSpec extends ClassSpec {
  private final TypeElement annotatedType;
  private final List<AccessorSpec> accessors;
  private final List<EmbeddedTypeSpec> embeddedTypes;
  private final String targetPackage;
  private final String enumName;
  private final String className;
  private final List<TypeMirror> converters;
  private final @Nullable TypeMirror listParser;

  private ImmutableClassSpec(
      TypeElement annotatedType,
      List<AccessorSpec> accessors,
      List<EmbeddedTypeSpec> embeddedTypes,
      String targetPackage,
      String enumName,
      String className,
      List<TypeMirror> converters,
      @Nullable TypeMirror listParser) {
    this.annotatedType = annotatedType;
    this.accessors = accessors;
    this.embeddedTypes = embeddedTypes;
    this.targetPackage = targetPackage;
    this.enumName = enumName;
    this.className = className;
    this.converters = converters;
    this.listParser = listParser;
  }

  /**
   * @return The value of the {@code annotatedType} attribute
   */
  @Override
  public TypeElement annotatedType() {
    return annotatedType;
  }

  /**
   * @return The value of the {@code accessors} attribute
   */
  @Override
  public List<AccessorSpec> accessors() {
    return accessors;
  }

  /**
   * @return The value of the {@code embeddedTypes} attribute
   */
  @Override
  public List<EmbeddedTypeSpec> embeddedTypes() {
    return embeddedTypes;
  }

  /**
   * @return The value of the {@code targetPackage} attribute
   */
  @Override
  public String targetPackage() {
    return targetPackage;
  }

  /**
   * @return The value of the {@code enumName} attribute
   */
  @Override
  public String enumName() {
    return enumName;
  }

  /**
   * @return The value of the {@code className} attribute
   */
  @Override
  public String className() {
    return className;
  }

  /**
   * @return The value of the {@code converters} attribute
   */
  @Override
  public List<TypeMirror> converters() {
    return converters;
  }

  /**
   * @return The value of the {@code listParser} attribute
   */
  @Override
  public Optional<TypeMirror> listParser() {
    return Optional.ofNullable(listParser);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClassSpec#annotatedType() annotatedType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for annotatedType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClassSpec withAnnotatedType(TypeElement value) {
    if (this.annotatedType == value) return this;
    TypeElement newValue = Objects.requireNonNull(value, "annotatedType");
    return new ImmutableClassSpec(
        newValue,
        this.accessors,
        this.embeddedTypes,
        this.targetPackage,
        this.enumName,
        this.className,
        this.converters,
        this.listParser);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassSpec#accessors() accessors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableClassSpec withAccessors(AccessorSpec... elements) {
    List<AccessorSpec> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableClassSpec(
        this.annotatedType,
        newValue,
        this.embeddedTypes,
        this.targetPackage,
        this.enumName,
        this.className,
        this.converters,
        this.listParser);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassSpec#accessors() accessors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of accessors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableClassSpec withAccessors(Iterable<? extends AccessorSpec> elements) {
    if (this.accessors == elements) return this;
    List<AccessorSpec> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableClassSpec(
        this.annotatedType,
        newValue,
        this.embeddedTypes,
        this.targetPackage,
        this.enumName,
        this.className,
        this.converters,
        this.listParser);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassSpec#embeddedTypes() embeddedTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableClassSpec withEmbeddedTypes(EmbeddedTypeSpec... elements) {
    List<EmbeddedTypeSpec> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableClassSpec(
        this.annotatedType,
        this.accessors,
        newValue,
        this.targetPackage,
        this.enumName,
        this.className,
        this.converters,
        this.listParser);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassSpec#embeddedTypes() embeddedTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of embeddedTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableClassSpec withEmbeddedTypes(Iterable<? extends EmbeddedTypeSpec> elements) {
    if (this.embeddedTypes == elements) return this;
    List<EmbeddedTypeSpec> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableClassSpec(
        this.annotatedType,
        this.accessors,
        newValue,
        this.targetPackage,
        this.enumName,
        this.className,
        this.converters,
        this.listParser);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClassSpec#targetPackage() targetPackage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetPackage
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClassSpec withTargetPackage(String value) {
    String newValue = Objects.requireNonNull(value, "targetPackage");
    if (this.targetPackage.equals(newValue)) return this;
    return new ImmutableClassSpec(
        this.annotatedType,
        this.accessors,
        this.embeddedTypes,
        newValue,
        this.enumName,
        this.className,
        this.converters,
        this.listParser);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClassSpec#enumName() enumName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enumName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClassSpec withEnumName(String value) {
    String newValue = Objects.requireNonNull(value, "enumName");
    if (this.enumName.equals(newValue)) return this;
    return new ImmutableClassSpec(
        this.annotatedType,
        this.accessors,
        this.embeddedTypes,
        this.targetPackage,
        newValue,
        this.className,
        this.converters,
        this.listParser);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClassSpec#className() className} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for className
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClassSpec withClassName(String value) {
    String newValue = Objects.requireNonNull(value, "className");
    if (this.className.equals(newValue)) return this;
    return new ImmutableClassSpec(
        this.annotatedType,
        this.accessors,
        this.embeddedTypes,
        this.targetPackage,
        this.enumName,
        newValue,
        this.converters,
        this.listParser);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassSpec#converters() converters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableClassSpec withConverters(TypeMirror... elements) {
    List<TypeMirror> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableClassSpec(
        this.annotatedType,
        this.accessors,
        this.embeddedTypes,
        this.targetPackage,
        this.enumName,
        this.className,
        newValue,
        this.listParser);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassSpec#converters() converters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of converters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableClassSpec withConverters(Iterable<? extends TypeMirror> elements) {
    if (this.converters == elements) return this;
    List<TypeMirror> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableClassSpec(
        this.annotatedType,
        this.accessors,
        this.embeddedTypes,
        this.targetPackage,
        this.enumName,
        this.className,
        newValue,
        this.listParser);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ClassSpec#listParser() listParser} attribute.
   * @param value The value for listParser
   * @return A modified copy of {@code this} object
   */
  public final ImmutableClassSpec withListParser(TypeMirror value) {
    TypeMirror newValue = Objects.requireNonNull(value, "listParser");
    if (this.listParser == newValue) return this;
    return new ImmutableClassSpec(
        this.annotatedType,
        this.accessors,
        this.embeddedTypes,
        this.targetPackage,
        this.enumName,
        this.className,
        this.converters,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ClassSpec#listParser() listParser} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for listParser
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableClassSpec withListParser(Optional<? extends TypeMirror> optional) {
    @Nullable TypeMirror value = optional.orElse(null);
    if (this.listParser == value) return this;
    return new ImmutableClassSpec(
        this.annotatedType,
        this.accessors,
        this.embeddedTypes,
        this.targetPackage,
        this.enumName,
        this.className,
        this.converters,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableClassSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableClassSpec
        && equalTo(0, (ImmutableClassSpec) another);
  }

  private boolean equalTo(int synthetic, ImmutableClassSpec another) {
    return annotatedType.equals(another.annotatedType)
        && accessors.equals(another.accessors)
        && embeddedTypes.equals(another.embeddedTypes)
        && targetPackage.equals(another.targetPackage)
        && enumName.equals(another.enumName)
        && className.equals(another.className)
        && converters.equals(another.converters)
        && Objects.equals(listParser, another.listParser);
  }

  /**
   * Computes a hash code from attributes: {@code annotatedType}, {@code accessors}, {@code embeddedTypes}, {@code targetPackage}, {@code enumName}, {@code className}, {@code converters}, {@code listParser}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + annotatedType.hashCode();
    h += (h << 5) + accessors.hashCode();
    h += (h << 5) + embeddedTypes.hashCode();
    h += (h << 5) + targetPackage.hashCode();
    h += (h << 5) + enumName.hashCode();
    h += (h << 5) + className.hashCode();
    h += (h << 5) + converters.hashCode();
    h += (h << 5) + Objects.hashCode(listParser);
    return h;
  }

  /**
   * Prints the immutable value {@code ClassSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ClassSpec{");
    builder.append("annotatedType=").append(annotatedType);
    builder.append(", ");
    builder.append("accessors=").append(accessors);
    builder.append(", ");
    builder.append("embeddedTypes=").append(embeddedTypes);
    builder.append(", ");
    builder.append("targetPackage=").append(targetPackage);
    builder.append(", ");
    builder.append("enumName=").append(enumName);
    builder.append(", ");
    builder.append("className=").append(className);
    builder.append(", ");
    builder.append("converters=").append(converters);
    if (listParser != null) {
      builder.append(", ");
      builder.append("listParser=").append(listParser);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link ClassSpec} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ClassSpec instance
   */
  public static ImmutableClassSpec copyOf(ClassSpec instance) {
    if (instance instanceof ImmutableClassSpec) {
      return (ImmutableClassSpec) instance;
    }
    return ImmutableClassSpec.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableClassSpec ImmutableClassSpec}.
   * <pre>
   * ImmutableClassSpec.builder()
   *    .annotatedType(javax.lang.model.element.TypeElement) // required {@link ClassSpec#annotatedType() annotatedType}
   *    .addAccessors|addAllAccessors(de.poiu.coat.processor.specs.AccessorSpec) // {@link ClassSpec#accessors() accessors} elements
   *    .addEmbeddedTypes|addAllEmbeddedTypes(de.poiu.coat.processor.specs.EmbeddedTypeSpec) // {@link ClassSpec#embeddedTypes() embeddedTypes} elements
   *    .targetPackage(String) // required {@link ClassSpec#targetPackage() targetPackage}
   *    .enumName(String) // required {@link ClassSpec#enumName() enumName}
   *    .className(String) // required {@link ClassSpec#className() className}
   *    .addConverters|addAllConverters(javax.lang.model.type.TypeMirror) // {@link ClassSpec#converters() converters} elements
   *    .listParser(javax.lang.model.type.TypeMirror) // optional {@link ClassSpec#listParser() listParser}
   *    .build();
   * </pre>
   * @return A new ImmutableClassSpec builder
   */
  public static ImmutableClassSpec.Builder builder() {
    return new ImmutableClassSpec.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableClassSpec ImmutableClassSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClassSpec", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ANNOTATED_TYPE = 0x1L;
    private static final long INIT_BIT_TARGET_PACKAGE = 0x2L;
    private static final long INIT_BIT_ENUM_NAME = 0x4L;
    private static final long INIT_BIT_CLASS_NAME = 0x8L;
    private long initBits = 0xfL;

    private @Nullable TypeElement annotatedType;
    private List<AccessorSpec> accessors = new ArrayList<AccessorSpec>();
    private List<EmbeddedTypeSpec> embeddedTypes = new ArrayList<EmbeddedTypeSpec>();
    private @Nullable String targetPackage;
    private @Nullable String enumName;
    private @Nullable String className;
    private List<TypeMirror> converters = new ArrayList<TypeMirror>();
    private @Nullable TypeMirror listParser;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ClassSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ClassSpec instance) {
      Objects.requireNonNull(instance, "instance");
      this.annotatedType(instance.annotatedType());
      addAllAccessors(instance.accessors());
      addAllEmbeddedTypes(instance.embeddedTypes());
      this.targetPackage(instance.targetPackage());
      this.enumName(instance.enumName());
      this.className(instance.className());
      addAllConverters(instance.converters());
      Optional<TypeMirror> listParserOptional = instance.listParser();
      if (listParserOptional.isPresent()) {
        listParser(listParserOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ClassSpec#annotatedType() annotatedType} attribute.
     * @param annotatedType The value for annotatedType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder annotatedType(TypeElement annotatedType) {
      this.annotatedType = Objects.requireNonNull(annotatedType, "annotatedType");
      initBits &= ~INIT_BIT_ANNOTATED_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link ClassSpec#accessors() accessors} list.
     * @param element A accessors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAccessors(AccessorSpec element) {
      this.accessors.add(Objects.requireNonNull(element, "accessors element"));
      return this;
    }

    /**
     * Adds elements to {@link ClassSpec#accessors() accessors} list.
     * @param elements An array of accessors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAccessors(AccessorSpec... elements) {
      for (AccessorSpec element : elements) {
        this.accessors.add(Objects.requireNonNull(element, "accessors element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ClassSpec#accessors() accessors} list.
     * @param elements An iterable of accessors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder accessors(Iterable<? extends AccessorSpec> elements) {
      this.accessors.clear();
      return addAllAccessors(elements);
    }

    /**
     * Adds elements to {@link ClassSpec#accessors() accessors} list.
     * @param elements An iterable of accessors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAccessors(Iterable<? extends AccessorSpec> elements) {
      for (AccessorSpec element : elements) {
        this.accessors.add(Objects.requireNonNull(element, "accessors element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ClassSpec#embeddedTypes() embeddedTypes} list.
     * @param element A embeddedTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEmbeddedTypes(EmbeddedTypeSpec element) {
      this.embeddedTypes.add(Objects.requireNonNull(element, "embeddedTypes element"));
      return this;
    }

    /**
     * Adds elements to {@link ClassSpec#embeddedTypes() embeddedTypes} list.
     * @param elements An array of embeddedTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEmbeddedTypes(EmbeddedTypeSpec... elements) {
      for (EmbeddedTypeSpec element : elements) {
        this.embeddedTypes.add(Objects.requireNonNull(element, "embeddedTypes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ClassSpec#embeddedTypes() embeddedTypes} list.
     * @param elements An iterable of embeddedTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder embeddedTypes(Iterable<? extends EmbeddedTypeSpec> elements) {
      this.embeddedTypes.clear();
      return addAllEmbeddedTypes(elements);
    }

    /**
     * Adds elements to {@link ClassSpec#embeddedTypes() embeddedTypes} list.
     * @param elements An iterable of embeddedTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmbeddedTypes(Iterable<? extends EmbeddedTypeSpec> elements) {
      for (EmbeddedTypeSpec element : elements) {
        this.embeddedTypes.add(Objects.requireNonNull(element, "embeddedTypes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ClassSpec#targetPackage() targetPackage} attribute.
     * @param targetPackage The value for targetPackage 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder targetPackage(String targetPackage) {
      this.targetPackage = Objects.requireNonNull(targetPackage, "targetPackage");
      initBits &= ~INIT_BIT_TARGET_PACKAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link ClassSpec#enumName() enumName} attribute.
     * @param enumName The value for enumName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enumName(String enumName) {
      this.enumName = Objects.requireNonNull(enumName, "enumName");
      initBits &= ~INIT_BIT_ENUM_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ClassSpec#className() className} attribute.
     * @param className The value for className 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder className(String className) {
      this.className = Objects.requireNonNull(className, "className");
      initBits &= ~INIT_BIT_CLASS_NAME;
      return this;
    }

    /**
     * Adds one element to {@link ClassSpec#converters() converters} list.
     * @param element A converters element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addConverters(TypeMirror element) {
      this.converters.add(Objects.requireNonNull(element, "converters element"));
      return this;
    }

    /**
     * Adds elements to {@link ClassSpec#converters() converters} list.
     * @param elements An array of converters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addConverters(TypeMirror... elements) {
      for (TypeMirror element : elements) {
        this.converters.add(Objects.requireNonNull(element, "converters element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ClassSpec#converters() converters} list.
     * @param elements An iterable of converters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder converters(Iterable<? extends TypeMirror> elements) {
      this.converters.clear();
      return addAllConverters(elements);
    }

    /**
     * Adds elements to {@link ClassSpec#converters() converters} list.
     * @param elements An iterable of converters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllConverters(Iterable<? extends TypeMirror> elements) {
      for (TypeMirror element : elements) {
        this.converters.add(Objects.requireNonNull(element, "converters element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link ClassSpec#listParser() listParser} to listParser.
     * @param listParser The value for listParser
     * @return {@code this} builder for chained invocation
     */
    public final Builder listParser(TypeMirror listParser) {
      this.listParser = Objects.requireNonNull(listParser, "listParser");
      return this;
    }

    /**
     * Initializes the optional value {@link ClassSpec#listParser() listParser} to listParser.
     * @param listParser The value for listParser
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder listParser(Optional<? extends TypeMirror> listParser) {
      this.listParser = listParser.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableClassSpec ImmutableClassSpec}.
     * @return An immutable instance of ClassSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableClassSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableClassSpec(
          annotatedType,
          createUnmodifiableList(true, accessors),
          createUnmodifiableList(true, embeddedTypes),
          targetPackage,
          enumName,
          className,
          createUnmodifiableList(true, converters),
          listParser);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ANNOTATED_TYPE) != 0) attributes.add("annotatedType");
      if ((initBits & INIT_BIT_TARGET_PACKAGE) != 0) attributes.add("targetPackage");
      if ((initBits & INIT_BIT_ENUM_NAME) != 0) attributes.add("enumName");
      if ((initBits & INIT_BIT_CLASS_NAME) != 0) attributes.add("className");
      return "Cannot build ClassSpec, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
