package de.poiu.coat.processor.specs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AccessorSpec}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAccessorSpec.builder()}.
 */
@Generated(from = "AccessorSpec", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAccessorSpec extends AccessorSpec {
  private final ExecutableElement accessor;
  private final String key;
  private final String defaultValue;
  private final boolean mandatory;
  private final @Nullable TypeMirror converter;
  private final @Nullable TypeMirror listParser;
  private final String methodName;
  private final TypeMirror type;
  private final @Nullable TypeMirror collectionType;

  private ImmutableAccessorSpec(
      ExecutableElement accessor,
      String key,
      String defaultValue,
      boolean mandatory,
      @Nullable TypeMirror converter,
      @Nullable TypeMirror listParser,
      String methodName,
      TypeMirror type,
      @Nullable TypeMirror collectionType) {
    this.accessor = accessor;
    this.key = key;
    this.defaultValue = defaultValue;
    this.mandatory = mandatory;
    this.converter = converter;
    this.listParser = listParser;
    this.methodName = methodName;
    this.type = type;
    this.collectionType = collectionType;
  }

  /**
   * @return The value of the {@code accessor} attribute
   */
  @Override
  public ExecutableElement accessor() {
    return accessor;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public String key() {
    return key;
  }

  /**
   * @return The value of the {@code defaultValue} attribute
   */
  @Override
  public String defaultValue() {
    return defaultValue;
  }

  /**
   * @return The value of the {@code mandatory} attribute
   */
  @Override
  public boolean mandatory() {
    return mandatory;
  }

  /**
   * @return The value of the {@code converter} attribute
   */
  @Override
  public Optional<TypeMirror> converter() {
    return Optional.ofNullable(converter);
  }

  /**
   * @return The value of the {@code listParser} attribute
   */
  @Override
  public Optional<TypeMirror> listParser() {
    return Optional.ofNullable(listParser);
  }

  /**
   * @return The value of the {@code methodName} attribute
   */
  @Override
  public String methodName() {
    return methodName;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public TypeMirror type() {
    return type;
  }

  /**
   * @return The value of the {@code collectionType} attribute
   */
  @Override
  public Optional<TypeMirror> collectionType() {
    return Optional.ofNullable(collectionType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessorSpec#accessor() accessor} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for accessor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessorSpec withAccessor(ExecutableElement value) {
    if (this.accessor == value) return this;
    ExecutableElement newValue = Objects.requireNonNull(value, "accessor");
    return new ImmutableAccessorSpec(
        newValue,
        this.key,
        this.defaultValue,
        this.mandatory,
        this.converter,
        this.listParser,
        this.methodName,
        this.type,
        this.collectionType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessorSpec#key() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessorSpec withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (this.key.equals(newValue)) return this;
    return new ImmutableAccessorSpec(
        this.accessor,
        newValue,
        this.defaultValue,
        this.mandatory,
        this.converter,
        this.listParser,
        this.methodName,
        this.type,
        this.collectionType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessorSpec#defaultValue() defaultValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessorSpec withDefaultValue(String value) {
    String newValue = Objects.requireNonNull(value, "defaultValue");
    if (this.defaultValue.equals(newValue)) return this;
    return new ImmutableAccessorSpec(
        this.accessor,
        this.key,
        newValue,
        this.mandatory,
        this.converter,
        this.listParser,
        this.methodName,
        this.type,
        this.collectionType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessorSpec#mandatory() mandatory} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mandatory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessorSpec withMandatory(boolean value) {
    if (this.mandatory == value) return this;
    return new ImmutableAccessorSpec(
        this.accessor,
        this.key,
        this.defaultValue,
        value,
        this.converter,
        this.listParser,
        this.methodName,
        this.type,
        this.collectionType);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AccessorSpec#converter() converter} attribute.
   * @param value The value for converter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccessorSpec withConverter(TypeMirror value) {
    TypeMirror newValue = Objects.requireNonNull(value, "converter");
    if (this.converter == newValue) return this;
    return new ImmutableAccessorSpec(
        this.accessor,
        this.key,
        this.defaultValue,
        this.mandatory,
        newValue,
        this.listParser,
        this.methodName,
        this.type,
        this.collectionType);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AccessorSpec#converter() converter} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for converter
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableAccessorSpec withConverter(Optional<? extends TypeMirror> optional) {
    @Nullable TypeMirror value = optional.orElse(null);
    if (this.converter == value) return this;
    return new ImmutableAccessorSpec(
        this.accessor,
        this.key,
        this.defaultValue,
        this.mandatory,
        value,
        this.listParser,
        this.methodName,
        this.type,
        this.collectionType);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AccessorSpec#listParser() listParser} attribute.
   * @param value The value for listParser
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccessorSpec withListParser(TypeMirror value) {
    TypeMirror newValue = Objects.requireNonNull(value, "listParser");
    if (this.listParser == newValue) return this;
    return new ImmutableAccessorSpec(
        this.accessor,
        this.key,
        this.defaultValue,
        this.mandatory,
        this.converter,
        newValue,
        this.methodName,
        this.type,
        this.collectionType);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AccessorSpec#listParser() listParser} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for listParser
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableAccessorSpec withListParser(Optional<? extends TypeMirror> optional) {
    @Nullable TypeMirror value = optional.orElse(null);
    if (this.listParser == value) return this;
    return new ImmutableAccessorSpec(
        this.accessor,
        this.key,
        this.defaultValue,
        this.mandatory,
        this.converter,
        value,
        this.methodName,
        this.type,
        this.collectionType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessorSpec#methodName() methodName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for methodName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessorSpec withMethodName(String value) {
    String newValue = Objects.requireNonNull(value, "methodName");
    if (this.methodName.equals(newValue)) return this;
    return new ImmutableAccessorSpec(
        this.accessor,
        this.key,
        this.defaultValue,
        this.mandatory,
        this.converter,
        this.listParser,
        newValue,
        this.type,
        this.collectionType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessorSpec#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessorSpec withType(TypeMirror value) {
    if (this.type == value) return this;
    TypeMirror newValue = Objects.requireNonNull(value, "type");
    return new ImmutableAccessorSpec(
        this.accessor,
        this.key,
        this.defaultValue,
        this.mandatory,
        this.converter,
        this.listParser,
        this.methodName,
        newValue,
        this.collectionType);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AccessorSpec#collectionType() collectionType} attribute.
   * @param value The value for collectionType
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccessorSpec withCollectionType(TypeMirror value) {
    TypeMirror newValue = Objects.requireNonNull(value, "collectionType");
    if (this.collectionType == newValue) return this;
    return new ImmutableAccessorSpec(
        this.accessor,
        this.key,
        this.defaultValue,
        this.mandatory,
        this.converter,
        this.listParser,
        this.methodName,
        this.type,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AccessorSpec#collectionType() collectionType} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for collectionType
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableAccessorSpec withCollectionType(Optional<? extends TypeMirror> optional) {
    @Nullable TypeMirror value = optional.orElse(null);
    if (this.collectionType == value) return this;
    return new ImmutableAccessorSpec(
        this.accessor,
        this.key,
        this.defaultValue,
        this.mandatory,
        this.converter,
        this.listParser,
        this.methodName,
        this.type,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAccessorSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAccessorSpec
        && equalTo(0, (ImmutableAccessorSpec) another);
  }

  private boolean equalTo(int synthetic, ImmutableAccessorSpec another) {
    return accessor.equals(another.accessor)
        && key.equals(another.key)
        && defaultValue.equals(another.defaultValue)
        && mandatory == another.mandatory
        && Objects.equals(converter, another.converter)
        && Objects.equals(listParser, another.listParser)
        && methodName.equals(another.methodName)
        && type.equals(another.type)
        && Objects.equals(collectionType, another.collectionType);
  }

  /**
   * Computes a hash code from attributes: {@code accessor}, {@code key}, {@code defaultValue}, {@code mandatory}, {@code converter}, {@code listParser}, {@code methodName}, {@code type}, {@code collectionType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + accessor.hashCode();
    h += (h << 5) + key.hashCode();
    h += (h << 5) + defaultValue.hashCode();
    h += (h << 5) + Boolean.hashCode(mandatory);
    h += (h << 5) + Objects.hashCode(converter);
    h += (h << 5) + Objects.hashCode(listParser);
    h += (h << 5) + methodName.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(collectionType);
    return h;
  }

  /**
   * Prints the immutable value {@code AccessorSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("AccessorSpec{");
    builder.append("accessor=").append(accessor);
    builder.append(", ");
    builder.append("key=").append(key);
    builder.append(", ");
    builder.append("defaultValue=").append(defaultValue);
    builder.append(", ");
    builder.append("mandatory=").append(mandatory);
    if (converter != null) {
      builder.append(", ");
      builder.append("converter=").append(converter);
    }
    if (listParser != null) {
      builder.append(", ");
      builder.append("listParser=").append(listParser);
    }
    builder.append(", ");
    builder.append("methodName=").append(methodName);
    builder.append(", ");
    builder.append("type=").append(type);
    if (collectionType != null) {
      builder.append(", ");
      builder.append("collectionType=").append(collectionType);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link AccessorSpec} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AccessorSpec instance
   */
  public static ImmutableAccessorSpec copyOf(AccessorSpec instance) {
    if (instance instanceof ImmutableAccessorSpec) {
      return (ImmutableAccessorSpec) instance;
    }
    return ImmutableAccessorSpec.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAccessorSpec ImmutableAccessorSpec}.
   * <pre>
   * ImmutableAccessorSpec.builder()
   *    .accessor(javax.lang.model.element.ExecutableElement) // required {@link AccessorSpec#accessor() accessor}
   *    .key(String) // required {@link AccessorSpec#key() key}
   *    .defaultValue(String) // required {@link AccessorSpec#defaultValue() defaultValue}
   *    .mandatory(boolean) // required {@link AccessorSpec#mandatory() mandatory}
   *    .converter(javax.lang.model.type.TypeMirror) // optional {@link AccessorSpec#converter() converter}
   *    .listParser(javax.lang.model.type.TypeMirror) // optional {@link AccessorSpec#listParser() listParser}
   *    .methodName(String) // required {@link AccessorSpec#methodName() methodName}
   *    .type(javax.lang.model.type.TypeMirror) // required {@link AccessorSpec#type() type}
   *    .collectionType(javax.lang.model.type.TypeMirror) // optional {@link AccessorSpec#collectionType() collectionType}
   *    .build();
   * </pre>
   * @return A new ImmutableAccessorSpec builder
   */
  public static ImmutableAccessorSpec.Builder builder() {
    return new ImmutableAccessorSpec.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAccessorSpec ImmutableAccessorSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AccessorSpec", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ACCESSOR = 0x1L;
    private static final long INIT_BIT_KEY = 0x2L;
    private static final long INIT_BIT_DEFAULT_VALUE = 0x4L;
    private static final long INIT_BIT_MANDATORY = 0x8L;
    private static final long INIT_BIT_METHOD_NAME = 0x10L;
    private static final long INIT_BIT_TYPE = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable ExecutableElement accessor;
    private @Nullable String key;
    private @Nullable String defaultValue;
    private boolean mandatory;
    private @Nullable TypeMirror converter;
    private @Nullable TypeMirror listParser;
    private @Nullable String methodName;
    private @Nullable TypeMirror type;
    private @Nullable TypeMirror collectionType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AccessorSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AccessorSpec instance) {
      Objects.requireNonNull(instance, "instance");
      this.accessor(instance.accessor());
      this.key(instance.key());
      this.defaultValue(instance.defaultValue());
      this.mandatory(instance.mandatory());
      Optional<TypeMirror> converterOptional = instance.converter();
      if (converterOptional.isPresent()) {
        converter(converterOptional);
      }
      Optional<TypeMirror> listParserOptional = instance.listParser();
      if (listParserOptional.isPresent()) {
        listParser(listParserOptional);
      }
      this.methodName(instance.methodName());
      this.type(instance.type());
      Optional<TypeMirror> collectionTypeOptional = instance.collectionType();
      if (collectionTypeOptional.isPresent()) {
        collectionType(collectionTypeOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AccessorSpec#accessor() accessor} attribute.
     * @param accessor The value for accessor 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder accessor(ExecutableElement accessor) {
      this.accessor = Objects.requireNonNull(accessor, "accessor");
      initBits &= ~INIT_BIT_ACCESSOR;
      return this;
    }

    /**
     * Initializes the value for the {@link AccessorSpec#key() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link AccessorSpec#defaultValue() defaultValue} attribute.
     * @param defaultValue The value for defaultValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultValue(String defaultValue) {
      this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
      initBits &= ~INIT_BIT_DEFAULT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link AccessorSpec#mandatory() mandatory} attribute.
     * @param mandatory The value for mandatory 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mandatory(boolean mandatory) {
      this.mandatory = mandatory;
      initBits &= ~INIT_BIT_MANDATORY;
      return this;
    }

    /**
     * Initializes the optional value {@link AccessorSpec#converter() converter} to converter.
     * @param converter The value for converter
     * @return {@code this} builder for chained invocation
     */
    public final Builder converter(TypeMirror converter) {
      this.converter = Objects.requireNonNull(converter, "converter");
      return this;
    }

    /**
     * Initializes the optional value {@link AccessorSpec#converter() converter} to converter.
     * @param converter The value for converter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder converter(Optional<? extends TypeMirror> converter) {
      this.converter = converter.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AccessorSpec#listParser() listParser} to listParser.
     * @param listParser The value for listParser
     * @return {@code this} builder for chained invocation
     */
    public final Builder listParser(TypeMirror listParser) {
      this.listParser = Objects.requireNonNull(listParser, "listParser");
      return this;
    }

    /**
     * Initializes the optional value {@link AccessorSpec#listParser() listParser} to listParser.
     * @param listParser The value for listParser
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder listParser(Optional<? extends TypeMirror> listParser) {
      this.listParser = listParser.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AccessorSpec#methodName() methodName} attribute.
     * @param methodName The value for methodName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder methodName(String methodName) {
      this.methodName = Objects.requireNonNull(methodName, "methodName");
      initBits &= ~INIT_BIT_METHOD_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link AccessorSpec#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(TypeMirror type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the optional value {@link AccessorSpec#collectionType() collectionType} to collectionType.
     * @param collectionType The value for collectionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder collectionType(TypeMirror collectionType) {
      this.collectionType = Objects.requireNonNull(collectionType, "collectionType");
      return this;
    }

    /**
     * Initializes the optional value {@link AccessorSpec#collectionType() collectionType} to collectionType.
     * @param collectionType The value for collectionType
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder collectionType(Optional<? extends TypeMirror> collectionType) {
      this.collectionType = collectionType.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableAccessorSpec ImmutableAccessorSpec}.
     * @return An immutable instance of AccessorSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAccessorSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAccessorSpec(
          accessor,
          key,
          defaultValue,
          mandatory,
          converter,
          listParser,
          methodName,
          type,
          collectionType);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ACCESSOR) != 0) attributes.add("accessor");
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_DEFAULT_VALUE) != 0) attributes.add("defaultValue");
      if ((initBits & INIT_BIT_MANDATORY) != 0) attributes.add("mandatory");
      if ((initBits & INIT_BIT_METHOD_NAME) != 0) attributes.add("methodName");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build AccessorSpec, some of required attributes are not set " + attributes;
    }
  }
}
