/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.example;

import de.poiu.coat.CoatConfig;
import de.poiu.coat.ConfigParam;
import de.poiu.coat.c14n.KeyC14n;
import de.poiu.coat.example.MqttConfig;
import de.poiu.coat.example.MqttConfigParam;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class ImmutableMqttConfig
extends CoatConfig
implements MqttConfig {
    private static final System.Logger LOGGER = System.getLogger(ImmutableMqttConfig.class.getName());

    private ImmutableMqttConfig(Map<String, String> props) {
        super((ConfigParam[])MqttConfigParam.values());
        this.add(props);
    }

    public static ImmutableMqttConfig from(Map<String, String> props) {
        return new ImmutableMqttConfig(props);
    }

    public static ImmutableMqttConfig from(File file) throws IOException {
        return new ImmutableMqttConfig(ImmutableMqttConfig.toMap((File)file));
    }

    public static ImmutableMqttConfig from(Properties jup) {
        return new ImmutableMqttConfig(ImmutableMqttConfig.toMap((Properties)jup));
    }

    public static ImmutableMqttConfig fromEnvVars() {
        return ImmutableMqttConfig.builder().addEnvVars().build();
    }

    @Override
    public Optional<String> getClientId() {
        return super.getOptional((ConfigParam)MqttConfigParam.GET_CLIENT_ID);
    }

    @Override
    public InetAddress[] getBrokerAddresses() {
        return (InetAddress[])super.getArray((ConfigParam)MqttConfigParam.GET_BROKER_ADDRESSES);
    }

    @Override
    public int getPort() {
        return super.getIntOrDefault((ConfigParam)MqttConfigParam.GET_PORT);
    }

    @Override
    public Optional<String> username() {
        return super.getOptional((ConfigParam)MqttConfigParam.USERNAME);
    }

    @Override
    public Optional<String> password() {
        return super.getOptional((ConfigParam)MqttConfigParam.PASSWORD);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableMqttConfig other = (ImmutableMqttConfig)obj;
        if (!Objects.equals(this.getClientId(), other.getClientId())) {
            return false;
        }
        if (!Objects.equals(this.getBrokerAddresses(), other.getBrokerAddresses())) {
            return false;
        }
        if (!Objects.equals(this.getPort(), other.getPort())) {
            return false;
        }
        if (!Objects.equals(this.username(), other.username())) {
            return false;
        }
        return Objects.equals(this.password(), other.password());
    }

    public int hashCode() {
        return Objects.hash(this.getClientId(), this.getBrokerAddresses(), this.getPort(), this.username(), this.password());
    }

    public static void writeExampleConfig(Writer writer) throws IOException {
        writer.append("## The clientId to send to the MQTT broker. \n# client_id = \n\n## The address(es) of the MQTT broker. \nbroker_addresses = \n\n## The port to communicate with the MQTT broker. \n# port = 1883\n\n## The username to connect to the MQTT broker. \n# username = \n\n## The password to connect to the MQTT broker. \n# password = \n\n");
        writer.flush();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> props = new HashMap<String, String>();

        public Builder add(Map<String, String> map) {
            this.props.putAll(map);
            return this;
        }

        public Builder add(File file) throws IOException {
            this.props.putAll(ImmutableMqttConfig.toMap((File)file));
            return this;
        }

        public Builder add(Properties jup) {
            this.props.putAll(ImmutableMqttConfig.toMap((Properties)jup));
            return this;
        }

        public Builder addEnvVars() {
            Map<String, String> envVars = System.getenv();
            String[] configKeys = new String[]{"client_id", "broker_addresses", "port", "username", "password"};
            for (String envVar : envVars.keySet()) {
                for (String configKey : configKeys) {
                    if (!envVar.toUpperCase().equals(KeyC14n.c14n((String)configKey))) continue;
                    LOGGER.log(System.Logger.Level.INFO, "Using environment variable {0} as config key {1}", envVar, configKey);
                    this.props.put(configKey, envVars.get(envVar));
                }
            }
            return this;
        }

        public ImmutableMqttConfig build() {
            return new ImmutableMqttConfig(this.props);
        }
    }
}

